/*
 * Copyright 2013 Proofpoint Inc.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.kairosdb.client.builder.aggregator;

import org.kairosdb.client.builder.Aggregator;
import org.kairosdb.client.builder.TimeUnit;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

public class SamplingAggregator extends Aggregator
{
	private Sampling sampling;

	public SamplingAggregator(String name, int value, TimeUnit unit)
	{
		super(name);
		checkArgument(value > 0, "value must be greater than 0.");

		sampling = new Sampling(value, unit);
	}

	public int getValue()
	{
		return sampling.value;
	}

	public TimeUnit getUnit()
	{
		return sampling.unit;
	}

	private class Sampling
	{
		private Sampling(int value, TimeUnit unit)
		{
			this.value = value;
			this.unit = checkNotNull(unit);
		}

		private int value;
		private TimeUnit unit;
	}
}