/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client;

import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.TimeZone;
import org.kairosdb.client.DataPointTypeRegistry;
import org.kairosdb.client.builder.Aggregator;
import org.kairosdb.client.builder.Grouper;
import org.kairosdb.client.deserializer.AggregatorDeserializer;
import org.kairosdb.client.deserializer.GroupByDeserializer;
import org.kairosdb.client.deserializer.GrouperDeserializer;
import org.kairosdb.client.deserializer.ListMultiMapDeserializer;
import org.kairosdb.client.deserializer.ResultsDeserializer;
import org.kairosdb.client.deserializer.TimeZoneDeserializer;
import org.kairosdb.client.response.GroupResult;
import org.kairosdb.client.response.Result;

public class JsonMapper {
    private Gson mapper;

    public JsonMapper(DataPointTypeRegistry typeRegistry) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GroupResult.class, (Object)new GroupByDeserializer());
        builder.registerTypeAdapter(Result.class, (Object)new ResultsDeserializer(typeRegistry));
        builder.registerTypeAdapter(ListMultimap.class, (Object)new ListMultiMapDeserializer());
        builder.registerTypeAdapter(TimeZone.class, (Object)new TimeZoneDeserializer());
        builder.registerTypeAdapter(Grouper.class, (Object)new GrouperDeserializer());
        builder.registerTypeAdapter(Aggregator.class, (Object)new AggregatorDeserializer());
        this.mapper = builder.create();
    }

    public <T> T fromJson(Reader json, Type typeOfT) {
        return (T)this.mapper.fromJson(json, typeOfT);
    }

    public <T> T fromJson(String json, Type typeOfT) {
        return (T)this.mapper.fromJson(json, typeOfT);
    }
}

