/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Objects;
import org.kairosdb.client.builder.BuilderUtils;
import org.kairosdb.client.builder.RelativeTime;
import org.kairosdb.client.builder.TimeUnit;
import org.kairosdb.client.util.Preconditions;

public abstract class AbstractQueryBuilder<B extends AbstractQueryBuilder<B>> {
    @SerializedName(value="start_absolute")
    Long startAbsolute;
    @SerializedName(value="end_absolute")
    Long endAbsolute;
    @SerializedName(value="start_relative")
    RelativeTime startRelative;
    @SerializedName(value="end_relative")
    RelativeTime endRelative;
    private transient Gson mapper = this.buildGson();

    AbstractQueryBuilder() {
    }

    protected abstract Gson buildGson();

    public Date getStartAbsolute() {
        return new Date(this.startAbsolute);
    }

    public Date getEndAbsolute() {
        return new Date(this.endAbsolute);
    }

    public RelativeTime getStartRelative() {
        return this.startRelative;
    }

    public RelativeTime getEndRelative() {
        return this.endRelative;
    }

    public B setStart(Date start) {
        Objects.requireNonNull(start, "start cannot be null");
        Preconditions.checkArgument(this.startRelative == null, "Both relative and absolute start times cannot be set.");
        this.startAbsolute = start.getTime();
        return (B)this;
    }

    public B setStart(int duration, TimeUnit unit) {
        Preconditions.checkArgument(duration > 0, "duration must be greater than 0");
        Objects.requireNonNull(unit, "unit cannot be null");
        Preconditions.checkArgument(this.startAbsolute == null, "Both relative and absolute start times cannot be set.");
        this.startRelative = new RelativeTime(duration, unit);
        return (B)this;
    }

    public B setEnd(Date end) {
        Preconditions.checkArgument(this.endRelative == null, "Both relative and absolute end times cannot be set.");
        this.endAbsolute = end.getTime();
        return (B)this;
    }

    public B setEnd(int duration, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit cannot be null");
        Preconditions.checkArgument(duration > 0, "duration must be greater than 0");
        Preconditions.checkArgument(this.endAbsolute == null, "Both relative and absolute end times cannot be set.");
        this.endRelative = new RelativeTime(duration, unit);
        return (B)this;
    }

    public String build() {
        this.validate();
        return this.mapper.toJson((Object)this);
    }

    void validate() {
        BuilderUtils.validateTimes(this.startAbsolute, this.endAbsolute, this.startRelative, this.endRelative);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractQueryBuilder that = (AbstractQueryBuilder)o;
        if (this.startAbsolute != null ? !this.startAbsolute.equals(that.startAbsolute) : that.startAbsolute != null) {
            return false;
        }
        if (this.endAbsolute != null ? !this.endAbsolute.equals(that.endAbsolute) : that.endAbsolute != null) {
            return false;
        }
        if (this.startRelative != null ? !this.startRelative.equals(that.startRelative) : that.startRelative != null) {
            return false;
        }
        return this.endRelative != null ? this.endRelative.equals(that.endRelative) : that.endRelative == null;
    }

    public int hashCode() {
        int result = this.startAbsolute != null ? this.startAbsolute.hashCode() : 0;
        result = 31 * result + (this.endAbsolute != null ? this.endAbsolute.hashCode() : 0);
        result = 31 * result + (this.startRelative != null ? this.startRelative.hashCode() : 0);
        result = 31 * result + (this.endRelative != null ? this.endRelative.hashCode() : 0);
        return result;
    }
}

