/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import java.util.Objects;
import org.kairosdb.client.builder.Aggregator;
import org.kairosdb.client.builder.TimeUnit;
import org.kairosdb.client.builder.aggregator.CustomAggregator;
import org.kairosdb.client.builder.aggregator.PercentileAggregator;
import org.kairosdb.client.builder.aggregator.RateAggregator;
import org.kairosdb.client.builder.aggregator.SamplingAggregator;
import org.kairosdb.client.util.Preconditions;

public class AggregatorFactory {
    public static SamplingAggregator createMinAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("min", value, unit);
    }

    public static SamplingAggregator createMaxAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("max", value, unit);
    }

    public static SamplingAggregator createAverageAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("avg", value, unit);
    }

    public static SamplingAggregator createStandardDeviationAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("dev", value, unit);
    }

    public static SamplingAggregator createSumAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("sum", value, unit);
    }

    public static SamplingAggregator createCountAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("count", value, unit);
    }

    public static PercentileAggregator createPercentileAggregator(double percentile, long value, TimeUnit unit) {
        return new PercentileAggregator(percentile, value, unit);
    }

    public static CustomAggregator createDivAggregator(double divisor) {
        Preconditions.checkArgument(divisor != 0.0, "Divisor cannot be zero.");
        return new CustomAggregator("div", "\"divisor\":" + divisor);
    }

    public static SamplingAggregator createLastAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("last", value, unit);
    }

    public static SamplingAggregator createFirstAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("first", value, unit);
    }

    public static SamplingAggregator createDataGapsMarkingAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("gaps", value, unit);
    }

    public static SamplingAggregator createLeastSquaresAggregator(long value, TimeUnit unit) {
        return new SamplingAggregator("least_squares", value, unit);
    }

    public static Aggregator createDiffAggregator() {
        return new Aggregator("diff");
    }

    public static Aggregator createSamplerAggregator() {
        return new Aggregator("sampler");
    }

    public static CustomAggregator createSimpleMovingAverage(int numPeriods) {
        return new CustomAggregator("sma", "'size':" + numPeriods);
    }

    public static CustomAggregator createScaleAggregator(double factor) {
        return new CustomAggregator("scale", "\"factor\":" + factor);
    }

    public static CustomAggregator createCustomAggregator(String name, String json) {
        return new CustomAggregator(name, json);
    }

    public static RateAggregator createRateAggregator(TimeUnit unit) {
        return new RateAggregator(unit);
    }

    public static CustomAggregator createSaveAsAggregator(String newMetricName) {
        Preconditions.checkNotNullOrEmpty(newMetricName, "newMetricName cannot be null or empty", new Object[0]);
        return new CustomAggregator("save_as", "\"metric_name\":\"" + newMetricName + "\"");
    }

    public static CustomAggregator createTrimAggregator(Trim trim) {
        Objects.requireNonNull(trim, "trim cannot be null");
        return new CustomAggregator("trim", "\"trim\":\"" + trim + "\"");
    }

    public static CustomAggregator createFilterAggregator(FilterOperation operation, double threshold) {
        Objects.requireNonNull(operation, "operation cannot be null");
        Preconditions.checkArgument(threshold >= 0.0, "threshold must be greater than or equal to zero");
        return new CustomAggregator("filter", "\"filter_op\":\"" + operation + "\", \"threshold\":" + threshold);
    }

    public static enum FilterOperation {
        LTE,
        LT,
        GTE,
        GT,
        EQUAL;

    }

    public static enum Trim {
        FIRST("first"),
        LAST("last"),
        BOTH("both");

        private String text;

        private Trim(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

