/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import org.kairosdb.client.builder.DataPoint;
import org.kairosdb.client.builder.Metric;
import org.kairosdb.client.builder.aggregator.CustomAggregator;
import org.kairosdb.client.builder.grouper.CustomGrouper;
import org.kairosdb.client.serializer.CustomAggregatorSerializer;
import org.kairosdb.client.serializer.CustomGrouperSerializer;
import org.kairosdb.client.serializer.DataPointSerializer;
import org.kairosdb.client.util.Preconditions;

public class MetricBuilder {
    private List<Metric> metrics = new ArrayList<Metric>();
    private transient Gson mapper;
    private boolean useCompression = false;

    private MetricBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(CustomAggregator.class, (Object)new CustomAggregatorSerializer());
        builder.registerTypeAdapter(CustomGrouper.class, (Object)new CustomGrouperSerializer());
        builder.registerTypeAdapter(DataPoint.class, (Object)new DataPointSerializer());
        this.mapper = builder.create();
    }

    public static MetricBuilder getInstance() {
        return new MetricBuilder();
    }

    public Metric addMetric(String metricName) {
        Metric metric = new Metric(metricName);
        this.metrics.add(metric);
        return metric;
    }

    public Metric addMetric(String metricName, String registeredType) {
        Metric metric = new Metric(metricName, registeredType);
        this.metrics.add(metric);
        return metric;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void setCompression(boolean compressionEnabled) {
        this.useCompression = compressionEnabled;
    }

    public boolean isCompressionEnabled() {
        return this.useCompression;
    }

    public String build() {
        for (Metric metric : this.metrics) {
            Preconditions.checkState(metric.getTags().size() > 0, metric.getName() + " must contain at least one tag.");
        }
        return this.mapper.toJson(this.metrics);
    }
}

