/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.kairosdb.client.builder.Aggregator;
import org.kairosdb.client.builder.Grouper;
import org.kairosdb.client.util.Preconditions;

public class QueryMetric {
    private final String name;
    private final ListMultimap<String, String> tags = ArrayListMultimap.create();
    @SerializedName(value="group_by")
    private final List<Grouper> groupers = new ArrayList<Grouper>();
    private final List<Aggregator> aggregators = new ArrayList<Aggregator>();
    private Integer limit;
    private Order order;
    @SerializedName(value="exclude_tags")
    private boolean excludeTags;

    public QueryMetric(String name) {
        this.name = Preconditions.checkNotNullOrEmpty(name);
    }

    public QueryMetric addMultiValuedTags(Map<String, List<String>> tags) {
        Objects.requireNonNull(tags);
        for (String key : tags.keySet()) {
            this.tags.putAll((Object)key, (Iterable)tags.get(key));
        }
        return this;
    }

    public QueryMetric addTags(Map<String, String> tags) {
        Objects.requireNonNull(tags);
        for (String key : tags.keySet()) {
            this.tags.put((Object)key, (Object)tags.get(key));
        }
        return this;
    }

    public QueryMetric addTag(String name, String ... values) {
        Preconditions.checkNotNullOrEmpty(name);
        Preconditions.checkArgument(values.length > 0);
        for (String value : values) {
            Preconditions.checkNotNullOrEmpty(value);
        }
        this.tags.putAll((Object)name, Arrays.asList(values));
        return this;
    }

    public QueryMetric addAggregator(Aggregator aggregator) {
        Objects.requireNonNull(aggregator);
        this.aggregators.add(aggregator);
        return this;
    }

    public QueryMetric addGrouper(Grouper grouper) {
        Objects.requireNonNull(grouper);
        this.groupers.add(grouper);
        return this;
    }

    public void setLimit(int limit) {
        Preconditions.checkArgument(limit > 0, "limit must be greater than 0");
        this.limit = limit;
    }

    public void setOrder(Order order) {
        Objects.requireNonNull(order);
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public ListMultimap<String, String> getTags() {
        return this.tags;
    }

    public List<Grouper> getGroupers() {
        return this.groupers;
    }

    public List<Aggregator> getAggregators() {
        return this.aggregators;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isExcludeTags() {
        return this.excludeTags;
    }

    public void setExcludeTags(boolean exclude) {
        this.excludeTags = exclude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryMetric that = (QueryMetric)o;
        return this.excludeTags == that.excludeTags && Objects.equals(this.name, that.name) && Objects.equals(this.tags, that.tags) && Objects.equals(this.groupers, that.groupers) && Objects.equals(this.aggregators, that.aggregators) && Objects.equals(this.limit, that.limit) && this.order == that.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.tags, this.groupers, this.aggregators, this.limit, this.order, this.excludeTags});
    }

    public String toString() {
        return new StringJoiner(", ", QueryMetric.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("tags=" + this.tags).add("groupers=" + this.groupers).add("aggregators=" + this.aggregators).add("limit=" + this.limit).add("order=" + this.order).add("excludeTags=" + this.excludeTags).toString();
    }

    public static enum Order {
        ASCENDING("asc"),
        DESCENDING("desc");

        private String text;

        private Order(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

