/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import org.kairosdb.client.builder.AbstractQueryBuilder;
import org.kairosdb.client.builder.QueryTagMetric;
import org.kairosdb.client.serializer.ListMultiMapSerializer;
import org.kairosdb.client.util.Preconditions;

public class QueryTagBuilder
extends AbstractQueryBuilder<QueryTagBuilder> {
    private List<QueryTagMetric> metrics = new ArrayList<QueryTagMetric>();

    private QueryTagBuilder() {
    }

    @Override
    protected Gson buildGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ListMultimap.class, (Object)new ListMultiMapSerializer());
        return builder.create();
    }

    public static QueryTagBuilder getInstance() {
        return new QueryTagBuilder();
    }

    public QueryTagMetric addMetric(String name) {
        Preconditions.checkNotNullOrEmpty(name, "Name cannot be null or empty.", new Object[0]);
        QueryTagMetric metric = new QueryTagMetric(name);
        this.metrics.add(metric);
        return metric;
    }

    public List<QueryTagMetric> getMetrics() {
        return this.metrics;
    }
}

