/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import java.util.Calendar;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TimeZone;
import org.kairosdb.client.builder.TimeUnit;

public class RelativeTime {
    private int value;
    private TimeUnit unit;
    private transient Calendar calendar;

    public RelativeTime() {
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public RelativeTime(int value, TimeUnit unit) {
        this.value = value;
        this.unit = unit;
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public int getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit.toString();
    }

    public long getTimeRelativeTo(long time) {
        int field = 0;
        if (this.unit == TimeUnit.SECONDS) {
            field = 13;
        } else if (this.unit == TimeUnit.MINUTES) {
            field = 12;
        } else if (this.unit == TimeUnit.HOURS) {
            field = 10;
        } else if (this.unit == TimeUnit.DAYS) {
            field = 5;
        } else if (this.unit == TimeUnit.WEEKS) {
            field = 4;
        } else if (this.unit == TimeUnit.MONTHS) {
            field = 2;
        } else if (this.unit == TimeUnit.YEARS) {
            field = 1;
        }
        this.calendar.setTimeInMillis(time);
        this.calendar.add(field, -this.value);
        return this.calendar.getTime().getTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeTime that = (RelativeTime)o;
        return this.value == that.value && this.unit == that.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.unit});
    }

    public String toString() {
        return new StringJoiner(", ", RelativeTime.class.getSimpleName() + "[", "]").add("value=" + this.value).add("unit=" + this.unit).add("calendar=" + this.calendar).toString();
    }
}

