/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder;

import org.kairosdb.client.builder.RelativeTime;
import org.kairosdb.client.util.Preconditions;

public class TimeValidator {
    private static final String START_TIME_EARLIER = "Start time must be equal to or earlier than the ending time";

    private TimeValidator() {
    }

    public static void validateEndTimeLaterThanStartTime(long startTime, long endTime) {
        Preconditions.checkState(endTime >= startTime, START_TIME_EARLIER);
    }

    public static void validateEndTimeLaterThanStartTime(RelativeTime startTime, RelativeTime endTime) {
        long now = System.currentTimeMillis();
        Preconditions.checkState(startTime.getTimeRelativeTo(now) <= endTime.getTimeRelativeTo(now), START_TIME_EARLIER);
    }

    public static void validateEndTimeLaterThanStartTime(long startTime, RelativeTime endTime) {
        long now = System.currentTimeMillis();
        Preconditions.checkState(startTime <= endTime.getTimeRelativeTo(now), START_TIME_EARLIER);
    }

    public static void validateEndTimeLaterThanStartTime(RelativeTime startTime, long endTime) {
        long now = System.currentTimeMillis();
        Preconditions.checkState(startTime.getTimeRelativeTo(now) <= endTime, START_TIME_EARLIER);
    }
}

