/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder.aggregator;

import org.kairosdb.client.builder.TimeUnit;
import org.kairosdb.client.builder.aggregator.SamplingAggregator;
import org.kairosdb.client.util.Preconditions;

public class PercentileAggregator
extends SamplingAggregator {
    private double percentile;

    public PercentileAggregator(double percentile, long value, TimeUnit unit) {
        super("percentile", value, unit);
        Preconditions.checkArgument(percentile >= 0.0, "value must be greater than or equal to 0.");
        Preconditions.checkArgument(percentile <= 1.0, "value must be less than or equal to 1.");
        this.percentile = percentile;
    }

    public double getPercentile() {
        return this.percentile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PercentileAggregator that = (PercentileAggregator)o;
        return Double.compare(that.percentile, this.percentile) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.percentile);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

