/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder.grouper;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.kairosdb.client.builder.Grouper;
import org.kairosdb.client.util.Preconditions;

public class BinGrouper
extends Grouper {
    @SerializedName(value="bins")
    private List<Double> bins;

    public BinGrouper(Double ... bins) {
        super("bin");
        Objects.requireNonNull(bins, "bins cannot be null");
        Preconditions.checkArgument(bins.length > 0, "bins cannot be empty");
        this.bins = Arrays.asList(bins);
    }

    public BinGrouper(List<Double> bins) {
        super("bin");
        Objects.requireNonNull(bins, "bins cannot be null");
        Preconditions.checkArgument(bins.size() > 0, "bins cannot be empty");
        this.bins = bins;
    }

    public List<Double> getBins() {
        return this.bins;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinGrouper that = (BinGrouper)o;
        return Objects.equals(this.bins, that.bins);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bins);
    }
}

