/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.builder.grouper;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.kairosdb.client.builder.Grouper;
import org.kairosdb.client.builder.RelativeTime;
import org.kairosdb.client.util.Preconditions;

public class TimeGrouper
extends Grouper {
    @SerializedName(value="range_size")
    private RelativeTime rangeSize;
    @SerializedName(value="group_count")
    private int count;

    public TimeGrouper(RelativeTime rangeSize, int count) {
        super("time");
        Preconditions.checkArgument(count > 0);
        this.rangeSize = Objects.requireNonNull(rangeSize);
        this.count = count;
    }

    public RelativeTime getRangeSize() {
        return this.rangeSize;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeGrouper that = (TimeGrouper)o;
        return this.count == that.count && !(this.rangeSize == null ? that.rangeSize != null : !this.rangeSize.equals(that.rangeSize));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.rangeSize != null ? this.rangeSize.hashCode() : 0);
        result = 31 * result + this.count;
        return result;
    }
}

