/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.deserializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kairosdb.client.DataPointTypeRegistry;
import org.kairosdb.client.builder.DataPoint;
import org.kairosdb.client.response.GroupResult;
import org.kairosdb.client.response.Result;
import org.kairosdb.client.response.grouping.DefaultGroupResult;
import org.kairosdb.client.util.Preconditions;

public class ResultsDeserializer
implements JsonDeserializer<Result> {
    private DataPointTypeRegistry typeRegistry;

    public ResultsDeserializer(DataPointTypeRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry);
    }

    public Result deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String name = json.getAsJsonObject().get("name").getAsString();
        Preconditions.checkState(name != null, "Missing name");
        JsonElement tagsElement = json.getAsJsonObject().get("tags");
        Map tags = (Map)context.deserialize(tagsElement, new TypeToken<Map<String, List<String>>>(){}.getType());
        JsonElement group_by = json.getAsJsonObject().get("group_by");
        List groupResults = (List)context.deserialize(group_by, new TypeToken<List<GroupResult>>(){}.getType());
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        if (group_by != null) {
            String type = null;
            for (GroupResult groupResult : groupResults) {
                if (!groupResult.getName().equals("type")) continue;
                type = ((DefaultGroupResult)groupResult).getType();
            }
            Preconditions.checkState(type != null, "Missing type");
            Class dataPointValueClass = this.typeRegistry.getDataPointValueClass(type);
            Preconditions.checkState(dataPointValueClass != null, "type: " + type + " is not registered to a custom data type.");
            JsonArray array = (JsonArray)json.getAsJsonObject().get("values");
            for (JsonElement element : array) {
                JsonArray pair = element.getAsJsonArray();
                dataPoints.add(new DataPoint(pair.get(0).getAsLong(), context.deserialize(pair.get(1), (Type)dataPointValueClass)));
            }
        }
        return new Result(name, tags, dataPoints, groupResults);
    }
}

