/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.response;

import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import org.apache.http.client.methods.HttpUriRequest;
import org.kairosdb.client.DataPointTypeRegistry;
import org.kairosdb.client.JsonMapper;
import org.kairosdb.client.response.ErrorResponse;
import org.kairosdb.client.response.JsonResponseHandler;
import org.kairosdb.client.response.ResponseHelper;
import org.kairosdb.client.response.UnexpectedResponseException;
import org.kairosdb.client.util.Exceptions;

public class DefaultJsonResponseHandler<T>
implements JsonResponseHandler {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final Set<Integer> successfulResponseCodes;
    private final JsonMapper mapper;
    private final Type type;

    public DefaultJsonResponseHandler(Class<T> clazz) {
        this(clazz, new DataPointTypeRegistry());
    }

    public DefaultJsonResponseHandler(Type type) {
        this(type, new DataPointTypeRegistry());
    }

    public DefaultJsonResponseHandler(Class<T> clazz, DataPointTypeRegistry typeRegistry) {
        this(TypeToken.of(clazz).getType(), typeRegistry);
    }

    public DefaultJsonResponseHandler(Type type, DataPointTypeRegistry typeRegistry) {
        Objects.requireNonNull(typeRegistry, "typeRegistry must not be null");
        this.mapper = new JsonMapper(typeRegistry);
        this.successfulResponseCodes = ImmutableSet.of((Object)200, (Object)204);
        this.type = Objects.requireNonNull(type, "type must not be null");
    }

    public Object handleException(HttpUriRequest request, Exception exception) throws RuntimeException {
        throw Exceptions.propagate(request, exception);
    }

    @Override
    public T handle(HttpUriRequest request, ResponseHelper response) throws RuntimeException {
        if (!this.successfulResponseCodes.contains(response.getStatusCode()) && response.getStatusCode() != 400) {
            throw new UnexpectedResponseException(String.format("Expected response code to be %s, but was %d: %s", this.successfulResponseCodes, response.getStatusCode(), response.getStatusMessage()), request, response);
        }
        if (response.getStatusCode() == 204) {
            return null;
        }
        String contentType = response.getFirstHeader("Content-Type");
        if (contentType == null) {
            throw new UnexpectedResponseException("Content-Type is not set for response", request, response);
        }
        if (!MediaType.parse((String)contentType).is(MEDIA_TYPE_JSON)) {
            throw new UnexpectedResponseException("Expected application/json response from server but got " + contentType, request, response);
        }
        Reader reader = null;
        try {
            if (response.getInputStream() == null) {
                T t = null;
                return t;
            }
            reader = new InputStreamReader(response.getInputStream(), StandardCharsets.UTF_8);
            if (response.getStatusCode() == 400) {
                ErrorResponse error = (ErrorResponse)this.mapper.fromJson(reader, (Type)((Object)ErrorResponse.class));
                throw new UnexpectedResponseException(String.format("Expected response code to be %s, but was %d: %s", this.successfulResponseCodes, response.getStatusCode(), error.toString()), request, response);
            }
            Object error = this.mapper.fromJson(reader, this.type);
            return error;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading JSON response from server", e);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new IllegalArgumentException("Unable to create parse JSON response:\n", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing reader ", e);
                }
            }
        }
    }
}

