/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.response.grouping;

import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.kairosdb.client.builder.RelativeTime;
import org.kairosdb.client.response.GroupResult;
import org.kairosdb.client.response.grouping.GroupingNumber;
import org.kairosdb.client.util.Preconditions;

public class TimeGroupResult
extends GroupResult {
    @SerializedName(value="range_size")
    private RelativeTime rangeSize;
    @SerializedName(value="group_count")
    private int groupCount;
    private GroupingNumber group;

    public TimeGroupResult(RelativeTime rangeSize, int groupCount, GroupingNumber group) {
        super("time");
        Preconditions.checkArgument(groupCount > 0);
        this.rangeSize = Objects.requireNonNull(rangeSize);
        this.groupCount = groupCount;
        this.group = Objects.requireNonNull(group);
    }

    public RelativeTime getRangeSize() {
        return this.rangeSize;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public GroupingNumber getGroup() {
        return this.group;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeGroupResult)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeGroupResult that = (TimeGroupResult)o;
        if (this.groupCount != that.groupCount) {
            return false;
        }
        if (!this.group.equals(that.group)) {
            return false;
        }
        return this.rangeSize.equals(that.rangeSize);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.rangeSize.hashCode();
        result = 31 * result + this.groupCount;
        result = 31 * result + this.group.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rangeSize", (Object)this.rangeSize).add("groupCount", this.groupCount).add("group", (Object)this.group).toString();
    }
}

