/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.client.response.grouping;

import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.kairosdb.client.response.GroupResult;
import org.kairosdb.client.response.grouping.GroupingNumber;
import org.kairosdb.client.util.Preconditions;

public class ValueGroupResult
extends GroupResult {
    @SerializedName(value="range_size")
    private int rangeSize;
    private GroupingNumber group;

    public ValueGroupResult(int rangeSize, GroupingNumber group) {
        super("value");
        Preconditions.checkArgument(rangeSize > 0);
        this.rangeSize = rangeSize;
        this.group = Objects.requireNonNull(group);
    }

    public int getRangeSize() {
        return this.rangeSize;
    }

    public GroupingNumber getGroup() {
        return this.group;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueGroupResult)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueGroupResult that = (ValueGroupResult)o;
        if (this.rangeSize != that.rangeSize) {
            return false;
        }
        return this.group.equals(that.group);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.rangeSize;
        result = 31 * result + this.group.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rangeSize", this.rangeSize).add("group", (Object)this.group).toString();
    }
}

