/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.metrics4jplugin.opentelemetry;

import org.kairosdb.metrics4j.MetricsContext;
import org.kairosdb.metrics4j.formatters.Formatter;
import org.kairosdb.metrics4j.reporting.ReportedMetric;

public class OtelFormatter
implements Formatter {
    public final String m_separator;
    public final boolean m_replaceDot;

    public OtelFormatter() {
        this(".");
    }

    public OtelFormatter(String separator) {
        this.m_separator = separator;
        this.m_replaceDot = !this.m_separator.equals(".");
    }

    public String formatReportedMetric(ReportedMetric reportedMetric, ReportedMetric.Sample sample, String metricName) {
        StringBuilder sb = new StringBuilder();
        if (metricName != null) {
            sb.append(metricName);
        } else {
            String className = reportedMetric.getClassName();
            if (this.m_replaceDot) {
                className = className.replace(".", this.m_separator);
            }
            sb.append(className).append(this.m_separator).append(reportedMetric.getMethodName());
        }
        if (!"summary".equals(reportedMetric.getContext().get("type"))) {
            sb.append(this.m_separator).append(sample.getFieldName());
        }
        return sb.toString();
    }

    public void init(MetricsContext context) {
    }
}

