/*
 * Decompiled with CFR 0.152.
 */
package org.kairosdb.metrics4jplugin.opentelemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableValueAtQuantile;
import io.opentelemetry.sdk.metrics.internal.data.M4jFactory;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kairosdb.metrics4j.MetricsContext;
import org.kairosdb.metrics4j.formatters.Formatter;
import org.kairosdb.metrics4j.internal.FormattedMetric;
import org.kairosdb.metrics4j.reporting.DoubleValue;
import org.kairosdb.metrics4j.reporting.LongValue;
import org.kairosdb.metrics4j.reporting.MetricValue;
import org.kairosdb.metrics4j.reporting.ReportedMetric;
import org.kairosdb.metrics4j.reporting.SummaryContext;
import org.kairosdb.metrics4j.sinks.MetricSink;
import org.kairosdb.metrics4jplugin.opentelemetry.OtelFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelSink
implements MetricSink,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(OtelSink.class);
    private static final Formatter DEFAULT_FORMATTER = new OtelFormatter();
    public static final String OTEL_UNIT = "otel_unit";
    public static final String OTEL_IS_MONOTONIC = "otel_is_monotonic";
    private static final List<Double> BOUNDARIES = Arrays.asList(0.0, 1.0);
    private String endpoint = "http://localhost:4317";
    private String name = "metrics4j";
    private InstrumentationScopeInfo m_scopeInfo;
    private MetricExporter m_exporter;

    private String escape(String in) {
        return in;
    }

    private String getChronoUnit(String chronoUnit, String defaultIfNull) {
        String ret = defaultIfNull;
        if (chronoUnit != null) {
            ChronoUnit unit = ChronoUnit.valueOf(chronoUnit);
            switch (unit) {
                case NANOS: {
                    ret = "ns";
                    break;
                }
                case MICROS: {
                    ret = "us";
                    break;
                }
                case MILLIS: {
                    ret = "ms";
                    break;
                }
                case SECONDS: {
                    ret = "s";
                    break;
                }
                case MINUTES: {
                    ret = "m";
                    break;
                }
                case HOURS: {
                    ret = "h";
                    break;
                }
                case DAYS: {
                    ret = "d";
                }
            }
        }
        return ret;
    }

    private double getValueAsDouble(MetricValue value) {
        double ret = 0.0;
        if ("long".equals(value.getType())) {
            ret = ((LongValue)value).getValue();
        } else if ("double".equals(value.getType())) {
            ret = ((DoubleValue)value).getValue();
        } else {
            logger.debug("Unable to convert MetricValue of type {} to double", (Object)value.getType());
        }
        return ret;
    }

    private SingleSample getSinglePointData(List<FormattedMetric.Sample> samples, Attributes attributes, boolean gauge) {
        FormattedMetric.Sample sample = samples.get(0);
        Long nanos = sample.getTime().toEpochMilli() * 1000000L;
        MetricValue value = sample.getValue();
        String valueType = value.getType();
        LongPointData pointData = null;
        MetricDataType type = null;
        if ("long".equals(valueType)) {
            pointData = ImmutableLongPointData.create((long)0L, (long)nanos, (Attributes)attributes, (long)((LongValue)value).getValue());
            type = gauge ? MetricDataType.LONG_GAUGE : MetricDataType.LONG_SUM;
        } else if ("double".equals(valueType)) {
            pointData = ImmutableDoublePointData.create((long)0L, (long)nanos, (Attributes)attributes, (double)((DoubleValue)value).getValue());
            type = gauge ? MetricDataType.DOUBLE_GAUGE : MetricDataType.DOUBLE_SUM;
        }
        return new SingleSample(sample.getMetricName(), type, (PointData)pointData);
    }

    private MetricData createData(FormattedMetric metric) {
        Map reportContext = metric.getContext();
        String metricType = reportContext.getOrDefault("type", "none");
        Map metricProperties = metric.getProps();
        String unit = this.getChronoUnit((String)reportContext.get("chrono_unit"), "1");
        unit = metricProperties.getOrDefault(OTEL_UNIT, unit);
        boolean isMonotonic = !metricProperties.getOrDefault(OTEL_IS_MONOTONIC, "false").equals("false");
        InstrumentationScopeInfo.create((String)this.name);
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry tagEntry : metric.getTags().entrySet()) {
            attributesBuilder.put((String)tagEntry.getKey(), (String)tagEntry.getValue());
        }
        Attributes attributes = attributesBuilder.build();
        ImmutableMetricData ret = null;
        if ("summary".equals(metricType)) {
            ArrayList<ValueAtQuantile> percentileValues = new ArrayList<ValueAtQuantile>();
            double sum = 0.0;
            long count = 0L;
            for (ReportedMetric.Sample sample : metric.getMetric().getSamples()) {
                SummaryContext sampleContext = (SummaryContext)sample.getSampleContext();
                switch (sampleContext.getSummaryType()) {
                    case SUM: {
                        sum = this.getValueAsDouble(sample.getValue());
                        break;
                    }
                    case COUNT: {
                        count = ((LongValue)sample.getValue()).getValue();
                        break;
                    }
                    case QUANTILE: {
                        percentileValues.add(ImmutableValueAtQuantile.create((double)sampleContext.getQuantileValue(), (double)this.getValueAsDouble(sample.getValue())));
                    }
                }
            }
            FormattedMetric.Sample firstSample = (FormattedMetric.Sample)metric.getSamples().get(0);
            Long nanos = firstSample.getTime().toEpochMilli() * 1000000L;
            ret = ImmutableMetricData.createDoubleSummary((Resource)Resource.getDefault(), (InstrumentationScopeInfo)this.m_scopeInfo, (String)firstSample.getMetricName(), (String)metric.getHelp(), (String)unit, (SummaryData)ImmutableSummaryData.create(Collections.singleton(ImmutableSummaryPointData.create((long)0L, (long)nanos, (Attributes)attributes, (long)count, (double)sum, percentileValues))));
        } else if ("gauge".equals(metricType)) {
            SingleSample singlePointData = this.getSinglePointData(metric.getSamples(), attributes, true);
            ret = M4jFactory.metricDataCreate(Resource.getDefault(), this.m_scopeInfo, singlePointData.getName(), metric.getHelp(), unit, singlePointData.getType(), ImmutableGaugeData.create(Collections.singleton(singlePointData.getPointData())));
        } else if ("counter".equals(metricType)) {
            String aggregation = reportContext.getOrDefault("aggregation", "delta");
            AggregationTemporality temporality = "delta".equals(aggregation) ? AggregationTemporality.DELTA : AggregationTemporality.CUMULATIVE;
            SingleSample singlePointData = this.getSinglePointData(metric.getSamples(), attributes, false);
            ret = M4jFactory.metricDataCreate(Resource.getDefault(), this.m_scopeInfo, singlePointData.getName(), metric.getHelp(), unit, singlePointData.getType(), ImmutableSumData.create((boolean)isMonotonic, (AggregationTemporality)temporality, Collections.singleton(singlePointData.getPointData())));
        } else {
            logger.debug("Unsupported context type for metric {}", (Object)metric.getClassName());
        }
        return ret;
    }

    public void reportMetrics(List<FormattedMetric> metrics) {
        ArrayList<MetricData> metricsToSend = new ArrayList<MetricData>();
        for (FormattedMetric metric : metrics) {
            MetricData data = this.createData(metric);
            if (data == null) continue;
            metricsToSend.add(data);
        }
        this.m_exporter.export(metricsToSend);
    }

    public Formatter getDefaultFormatter() {
        return DEFAULT_FORMATTER;
    }

    public void setExporter(MetricExporter exporter) {
        this.m_scopeInfo = InstrumentationScopeInfo.create((String)this.name);
        this.m_exporter = exporter;
    }

    public void init(MetricsContext context) {
        this.m_scopeInfo = InstrumentationScopeInfo.create((String)this.name);
        OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
        builder.setEndpoint(this.endpoint);
        this.m_exporter = builder.build();
    }

    @Override
    public void close() throws IOException {
        this.m_exporter.shutdown();
    }

    public String toString() {
        return "OtelSink{endpoint='" + this.endpoint + "', name='" + this.name + "'}";
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setName(String name) {
        this.name = name;
    }

    private class SingleSample {
        private final String m_name;
        private final MetricDataType m_type;
        private final PointData m_pointData;

        private SingleSample(String name, MetricDataType type, PointData pointData) {
            this.m_name = name;
            this.m_type = type;
            this.m_pointData = pointData;
        }

        public String getName() {
            return this.m_name;
        }

        public MetricDataType getType() {
            return this.m_type;
        }

        public PointData getPointData() {
            return this.m_pointData;
        }

        public String toString() {
            return "OtelSink.SingleSample(m_name=" + this.m_name + ", m_type=" + this.m_type + ", m_pointData=" + this.m_pointData + ")";
        }
    }
}

