package org.kathra.appmanager.service;

import org.kathra.core.model.Component;
import java.util.List;

public interface ComponentsService extends org.kathra.iface.KathraAuthRequestHandler {

    /**
    * Create a new Component
    * 
    * @param component The parameters for the component to create. Required: name and metadata.groupPath (optional)
    * @return Component
    */
    Component createComponent(Component component) throws Exception;

    /**
    * Delete the component having the given id
    * 
    * @param componentId The ID of the Component to delete (required)
    * @return Component
    */
    Component deleteComponentById(String componentId) throws Exception;

    /**
    * Get the component having the given id
    * 
    * @param componentId The ID of the Component to get (required)
    * @return Component
    */
    Component getComponentById(String componentId) throws Exception;

    /**
    * Get the components list
    * 
    * @return List<Component>
    */
    List<Component> getComponents() throws Exception;

}
