package org.kathra.appmanager.service;

import org.kathra.core.model.Implementation;
import org.kathra.appmanager.model.ImplementationParameters;
import java.util.List;

public interface ImplementationsService extends org.kathra.iface.KathraAuthRequestHandler {

    /**
    * Create a new Implementation for the given ApiVersion
    * 
    * @param implementationParameters The parameters for the implementation to create (optional)
    * @return Implementation
    */
    Implementation createImplementation(ImplementationParameters implementationParameters) throws Exception;

    /**
    * Delete the Implementation having the given id
    * 
    * @param implementationId The ID of the Implementation to delete (required)
    * @return Implementation
    */
    Implementation deleteImplementationById(String implementationId) throws Exception;

    /**
    * Get the component having the given id
    * 
    * @param componentId The ID of the Component to get the implementations from (required)
    * @return List<Implementation>
    */
    List<Implementation> getComponentImplementations(String componentId) throws Exception;

    /**
    * Get the Implementation having the given id
    * 
    * @param implementationId The ID of the Implementation to get (required)
    * @return Implementation
    */
    Implementation getImplementationById(String implementationId) throws Exception;

    /**
    * Get the Implementations list
    * 
    * @return List<Implementation>
    */
    List<Implementation> getImplementations() throws Exception;

}
