package org.kathra.appmanager.service;

import org.kathra.core.model.Build;
import java.util.List;

public interface PipelinesService extends org.kathra.iface.KathraAuthRequestHandler {

    /**
    * Execute pipeline
    * 
    * @param pipelineId The ID of the Pipeline to get the builds of (required)
    * @param branch The name of the branch to get the builds of (required)
    * @return Build
    */
    Build executePipeline(String pipelineId, String branch) throws Exception;

    /**
    * Get the builds for the given pipeline for a given branch
    * 
    * @param pipelineId The ID of the Pipeline to get the builds of (required)
    * @param branch The name of the branch to get the builds of (required)
    * @return List<Build>
    */
    List<Build> getPipelineBuildsForBranch(String pipelineId, String branch) throws Exception;

}
