package org.kathra.appmanager.service;

import org.kathra.appmanager.model.Commit;
import java.util.List;

public interface RepositoriesService extends org.kathra.iface.KathraAuthRequestHandler {

    /**
    * Get the branches for the given SourceRepository
    * 
    * @param sourceRepositoryId The ID of the SourceRepository to get (required)
    * @return List<String>
    */
    List<String> getRepositoryBranches(String sourceRepositoryId) throws Exception;

    /**
    * Get the commits for the given SourceRepository for a given branch
    * 
    * @param sourceRepositoryId The ID of the SourceRepository to get the commits from (required)
    * @param branch The name of the branch to get the commits from (required)
    * @return List<Commit>
    */
    List<Commit> getRepositoryCommitsForBranch(String sourceRepositoryId, String branch) throws Exception;

}
