/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestParamType;
import org.kathra.KathraAuthRequestHandlerImpl;
import org.kathra.appmanager.model.ApiFileValidationResponse;
import org.kathra.appmanager.model.CatalogEntryTemplate;
import org.kathra.appmanager.model.Commit;
import org.kathra.appmanager.model.ImplementationParameters;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Build;
import org.kathra.core.model.CatalogEntry;
import org.kathra.core.model.CatalogEntryPackage;
import org.kathra.core.model.Component;
import org.kathra.core.model.Group;
import org.kathra.core.model.Implementation;
import org.kathra.utils.security.KeycloakUtils;

@ContextName(value="AppManager")
public class AppManagerApi
extends RouteBuilder {
    public void configure() throws Exception {
        KeycloakUtils.init();
        this.restConfiguration().component("netty4-http").bindingMode(RestBindingMode.off).dataFormatProperty("prettyPrint", "true").dataFormatProperty("json.in.disableFeatures", "FAIL_ON_UNKNOWN_PROPERTIES").contextPath("/api/v1").port("{{env:HTTP_PORT:8080}}").componentProperty("chunkedMaxContentLength", String.valueOf(1468006400)).endpointProperty("chunkedMaxContentLength", String.valueOf(1468006400)).consumerProperty("chunkedMaxContentLength", String.valueOf(1468006400)).apiContextPath("/swagger.json").apiProperty("api.title", "Kathra Applications Manager").apiProperty("api.version", "1.2.0").apiProperty("api.description", "AppManager").apiProperty("cors", "true").enableCORS(true).corsAllowCredentials(true).corsHeaderProperty("Access-Control-Allow-Headers", "Origin, Accept, X-Requested-With, Content-Type,Access-Control-Request-Method, Access-Control-Request-Headers, Authorization");
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.rest().post("/components/{componentId}/apiVersions").outType(ApiVersion.class).consumes("multipart/form-data").description("Create a new ApiVersion via an OpenAPI file").param().required(Boolean.valueOf(true)).dataType("string").name("componentId").type(RestParamType.path).description("The ID of the Component the APIVersion will be created for").endParam().param().required(Boolean.valueOf(false)).dataType("file").name("openApiFile").type(RestParamType.formData).description("The OpenAPI file representing the APIVersion to create").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ApiVersionsController?method=createApiVersion(${header.componentId},${header.openApiFile})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().delete("/apiVersions/{apiVersionId}").outType(ApiVersion.class).consumes("multipart/form-data").description("Delete ApiVersion via an OpenAPI file").param().required(Boolean.valueOf(true)).dataType("string").name("apiVersionId").type(RestParamType.path).description("The ID of the Component the APIVersion will be deleted for").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ApiVersionsController?method=deleteApiVersion(${header.apiVersionId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/apiVersions/{apiVersionId}/apiFile").consumes("multipart/form-data").description("Get the API File from the specified source repository").param().required(Boolean.valueOf(true)).dataType("string").name("apiVersionId").type(RestParamType.path).description("The ID of the requested APIVersion file").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ApiVersionsController?method=getApiFile(${header.apiVersionId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").endRest().get("/apiVersions/{apiVersionId}").outType(ApiVersion.class).description("Get the Api Version having the given id").param().required(Boolean.valueOf(true)).dataType("string").name("apiVersionId").type(RestParamType.path).description("The ID of the Api Version to get").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ApiVersionsController?method=getApiVersionById(${header.apiVersionId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().put("/apiVersions/{apiVersionId}").outType(ApiVersion.class).consumes("multipart/form-data").description("Update ApiVersion via an OpenAPI file").param().required(Boolean.valueOf(true)).dataType("string").name("apiVersionId").type(RestParamType.path).description("The ID of the Component the APIVersion will be created for").endParam().param().required(Boolean.valueOf(false)).dataType("file").name("openApiFile").type(RestParamType.formData).description("The OpenAPI file representing the APIVersion to create").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ApiVersionsController?method=updateApiVersion(${header.apiVersionId},${header.openApiFile})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/apiFileValidation").outType(ApiFileValidationResponse.class).consumes("multipart/form-data").produces("application/json").description("Check the integrity of an API file").param().required(Boolean.valueOf(true)).dataType("file").name("apiFile").type(RestParamType.formData).description("API specification of the component's API").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleRequest").to("bean:AppManagerController?method=getApiFileValidation(${header.apiFile})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/catalog-entries").type(CatalogEntryTemplate.class).outType(CatalogEntry.class).description("Add a new entry to catalog from template").param().required(Boolean.valueOf(false)).name("catalogEntry").type(RestParamType.body).description("The catalog entry to create from template").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, CatalogEntryTemplate.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:CatalogEntriesController?method=addEntryToCatalogFromTemplate(${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().delete("/catalog-entries/{catalogEntryId}").outType(CatalogEntry.class).description("Delete the CatalogEntry having the given id").param().required(Boolean.valueOf(true)).dataType("string").name("catalogEntryId").type(RestParamType.path).description("The ID of the CatalogEntry to delete").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:CatalogEntriesController?method=deleteCatalogEntryById(${header.catalogEntryId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/catalog-entries").outType(CatalogEntry[].class).description("Get the catalog entries list").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:CatalogEntriesController?method=getCatalogEntries").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/catalog-entries/{catalogEntryId}").outType(CatalogEntry.class).description("Get the CatalogEntry having the given id").param().required(Boolean.valueOf(true)).dataType("string").name("catalogEntryId").type(RestParamType.path).description("The ID of the CatalogEntryId to get").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:CatalogEntriesController?method=getCatalogEntry(${header.catalogEntryId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/catalog-entries-packages/{providerId}").outType(CatalogEntryPackage.class).description("Get the CatalogEntryPackage having the given ProviderID [latest version]").param().required(Boolean.valueOf(true)).dataType("string").name("providerId").type(RestParamType.path).description("The ProviderId of the CatalogEntryPackage to get").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:CatalogEntriesController?method=getCatalogEntryPackageFromProviderId(${header.providerId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/catalog-entries-packages/{providerId}/versions/{version}").outType(CatalogEntryPackage.class).description("Get the CatalogEntryPackage having the given ProviderID and version").param().required(Boolean.valueOf(true)).dataType("string").name("providerId").type(RestParamType.path).description("The ProviderId of the CatalogEntryPackage to get").endParam().param().required(Boolean.valueOf(true)).dataType("string").name("version").type(RestParamType.path).description("The Version of the CatalogEntryPackage to get").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:CatalogEntriesController?method=getCatalogEntryPackageFromProviderIdAndVersion(${header.providerId},${header.version})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/catalog-entries-packages/").outType(CatalogEntryPackage[].class).description("Get all CatalogEntryPackage with ProviderID").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:CatalogEntriesController?method=getCatalogEntryPackages").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/catalog-entries-templates").outType(CatalogEntryTemplate[].class).description("Get codegen templates").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:CatalogEntriesController?method=getCatalogEntryTemplates").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/components").type(Component.class).outType(Component.class).description("Create a new Component").param().required(Boolean.valueOf(false)).name("component").type(RestParamType.body).description("The parameters for the component to create. Required: name and metadata.groupPath").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, Component.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ComponentsController?method=createComponent(${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().delete("/components/{componentId}").outType(Component.class).description("Delete the component having the given id").param().required(Boolean.valueOf(true)).dataType("string").name("componentId").type(RestParamType.path).description("The ID of the Component to delete").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ComponentsController?method=deleteComponentById(${header.componentId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/components/{componentId}").outType(Component.class).description("Get the component having the given id").param().required(Boolean.valueOf(true)).dataType("string").name("componentId").type(RestParamType.path).description("The ID of the Component to get").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ComponentsController?method=getComponentById(${header.componentId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/components").outType(Component[].class).description("Get the components list").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ComponentsController?method=getComponents").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/groups").outType(Group[].class).description("Get the groups list").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:GroupsController?method=getGroups").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/implementations").type(ImplementationParameters.class).outType(Implementation.class).description("Create a new Implementation for the given ApiVersion").param().required(Boolean.valueOf(false)).name("implementationParameters").type(RestParamType.body).description("The parameters for the implementation to create").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().unmarshal().json(JsonLibrary.Gson, ImplementationParameters.class).bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ImplementationsController?method=createImplementation(${body})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().delete("/implementations/{implementationId}").outType(Implementation.class).description("Delete the Implementation having the given id").param().required(Boolean.valueOf(true)).dataType("string").name("implementationId").type(RestParamType.path).description("The ID of the Implementation to delete").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ImplementationsController?method=deleteImplementationById(${header.implementationId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/components/{componentId}/implementations").outType(Implementation[].class).description("Get the component having the given id").param().required(Boolean.valueOf(true)).dataType("string").name("componentId").type(RestParamType.path).description("The ID of the Component to get the implementations from").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ImplementationsController?method=getComponentImplementations(${header.componentId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/implementations/{implementationId}").outType(Implementation.class).description("Get the Implementation having the given id").param().required(Boolean.valueOf(true)).dataType("string").name("implementationId").type(RestParamType.path).description("The ID of the Implementation to get").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ImplementationsController?method=getImplementationById(${header.implementationId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/implementations").outType(Implementation[].class).description("Get the Implementations list").route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:ImplementationsController?method=getImplementations").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().post("/pipelines/{pipelineId}/builds").outType(Build.class).description("Execute pipeline").param().required(Boolean.valueOf(true)).dataType("string").name("pipelineId").type(RestParamType.path).description("The ID of the Pipeline to get the builds of").endParam().param().required(Boolean.valueOf(true)).dataType("string").name("branch").type(RestParamType.query).description("The name of the branch to get the builds of").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:PipelinesController?method=executePipeline(${header.pipelineId},${header.branch})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/pipelines/{pipelineId}/builds").outType(Build[].class).description("Get the builds for the given pipeline for a given branch").param().required(Boolean.valueOf(true)).dataType("string").name("pipelineId").type(RestParamType.path).description("The ID of the Pipeline to get the builds of").endParam().param().required(Boolean.valueOf(true)).dataType("string").name("branch").type(RestParamType.query).description("The name of the branch to get the builds of").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:PipelinesController?method=getPipelineBuildsForBranch(${header.pipelineId},${header.branch})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/sourceRepositories/branches/{sourceRepositoryId}").outType(String[].class).description("Get the branches for the given SourceRepository").param().required(Boolean.valueOf(true)).dataType("string").name("sourceRepositoryId").type(RestParamType.path).description("The ID of the SourceRepository to get").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:RepositoriesController?method=getRepositoryBranches(${header.sourceRepositoryId})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest().get("/commits/{sourceRepositoryId}").outType(Commit[].class).description("Get the commits for the given SourceRepository for a given branch").param().required(Boolean.valueOf(true)).dataType("string").name("sourceRepositoryId").type(RestParamType.path).description("The ID of the SourceRepository to get the commits from").endParam().param().required(Boolean.valueOf(true)).dataType("string").name("branch").type(RestParamType.query).description("The name of the branch to get the commits from").endParam().route().onException(Exception.class).bean(KathraAuthRequestHandlerImpl.class, "handleException")).bean(KathraAuthRequestHandlerImpl.class, "deleteSession")).handled(true).stop()).end().bean(KathraAuthRequestHandlerImpl.class, "handleAuthenticatedRequest").to("bean:RepositoriesController?method=getRepositoryCommitsForBranch(${header.sourceRepositoryId},${header.branch})").bean(KathraAuthRequestHandlerImpl.class, "postProcessResponse").marshal().json(JsonLibrary.Gson).endRest();
    }
}

