/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.apiversion;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.NotFoundException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.apiversion.OpenApiParser;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.implementationversion.ImplementationVersionService;
import org.kathra.appmanager.library.LibraryService;
import org.kathra.appmanager.libraryapiversion.LibraryApiVersionService;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Asset;
import org.kathra.core.model.Component;
import org.kathra.core.model.ImplementationVersion;
import org.kathra.core.model.Library;
import org.kathra.core.model.LibraryApiVersion;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.core.model.SourceRepositoryCommit;
import org.kathra.resourcemanager.client.ApiVersionsClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;

public class ApiVersionService
extends AbstractResourceService<ApiVersion> {
    private ComponentService componentService;
    private ApiVersionsClient resourceManager;
    private OpenApiParser openApiParser;
    private SourceRepositoryService sourceRepositoryService;
    private LibraryService libraryService;
    private LibraryApiVersionService libraryApiVersionService;
    private ImplementationVersionService implementationVersionService;
    public static final String METADATA_API_GROUP_ID = "artifact-groupId";
    public static final String METADATA_API_ARTIFACT_NAME = "artifact-artifactName";
    public static final String DEFAULT_BRANCH = "dev";
    public static final String API_FILENAME = "swagger.yaml";
    private static final Pattern PATTERN_NAME = Pattern.compile("^[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}$");

    public ApiVersionService() {
    }

    @Override
    public void configure(ServiceInjection service) {
        super.configure(service);
        this.resourceManager = new ApiVersionsClient(service.getConfig().getResourceManagerUrl(), service.getSessionManager());
        this.sourceRepositoryService = service.getService(SourceRepositoryService.class);
        this.libraryService = service.getService(LibraryService.class);
        this.openApiParser = new OpenApiParser();
        this.componentService = service.getService(ComponentService.class);
        this.libraryApiVersionService = service.getService(LibraryApiVersionService.class);
        this.implementationVersionService = service.getService(ImplementationVersionService.class);
    }

    public ApiVersionService(ApiVersionsClient resourceManager, ComponentService componentService, OpenApiParser openApiParser, LibraryService libraryService, LibraryApiVersionService libraryApiVersionService, SourceRepositoryService sourceRepositoryService, KathraSessionManager kathraSessionManager, ImplementationVersionService implementationVersionService) {
        this.componentService = componentService;
        this.resourceManager = resourceManager;
        this.openApiParser = openApiParser;
        this.libraryService = libraryService;
        this.libraryApiVersionService = libraryApiVersionService;
        this.sourceRepositoryService = sourceRepositoryService;
        this.kathraSessionManager = kathraSessionManager;
        this.implementationVersionService = implementationVersionService;
    }

    public ApiVersion create(String componentId, File apiFile, Runnable callback) throws Exception {
        if (StringUtils.isEmpty((CharSequence)componentId)) {
            throw new IllegalArgumentException("componentId is null or empty");
        }
        Component component = this.componentService.getById(componentId).orElseThrow(() -> new IllegalArgumentException("Component '" + componentId + "' doesn't exist"));
        return this.create(component, apiFile, callback);
    }

    public ApiVersion create(Component component, File apiFile, Runnable callback) throws ApiException, IOException {
        ApiVersion apiVersion;
        Component componentWithDetails = this.componentService.getById(component.getId()).orElseThrow(() -> new IllegalArgumentException("Component '" + component.getId() + "' doesn't exist"));
        if (!this.isReady((Resource)componentWithDetails)) {
            throw new IllegalStateException("Component '" + componentWithDetails.getId() + "' is not READY.");
        }
        try {
            apiVersion = this.openApiParser.getApiVersionFromApiFile(apiFile);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (!apiVersion.getMetadata().containsKey(METADATA_API_ARTIFACT_NAME) || StringUtils.isEmpty((CharSequence)((String)apiVersion.getMetadata().get(METADATA_API_ARTIFACT_NAME)))) {
            String swagger = FileUtils.readFileToString((File)apiFile, (String)"UTF-8");
            swagger = StringUtils.replace((String)swagger, (String)"  x-groupId", (String)("  x-artifactName: " + componentWithDetails.getName().toLowerCase() + "\n  x-groupId"));
            FileUtils.writeStringToFile((File)apiFile, (String)swagger, (Charset)Charset.forName("UTF-8"), (boolean)false);
            apiVersion.getMetadata().put(METADATA_API_ARTIFACT_NAME, componentWithDetails.getName().toLowerCase());
        }
        this.checkApiVersionFromApiFile(apiVersion);
        if (this.getApiVersion(componentWithDetails, apiVersion.getVersion()).isPresent()) {
            throw new IllegalArgumentException("Component with version '" + apiVersion.getVersion() + "' already existing");
        }
        List<ApiVersion> existingApiVersionWithSameArtifactIdentifier = this.getApiVersionByArtifact((String)apiVersion.getMetadata().get(METADATA_API_GROUP_ID), (String)apiVersion.getMetadata().get(METADATA_API_ARTIFACT_NAME));
        Optional<Component> componentWithSameArtifactIdentifier = existingApiVersionWithSameArtifactIdentifier.parallelStream().filter(apiV -> !apiV.getComponent().getId().equals(component.getId())).map(ApiVersion::getComponent).findAny();
        if (componentWithSameArtifactIdentifier.isPresent()) {
            throw new IllegalArgumentException("A another component '" + componentWithSameArtifactIdentifier.get().getId() + "' using the same groupId and artifactId");
        }
        if (componentWithDetails.getMetadata() == null || !componentWithDetails.getMetadata().containsKey(METADATA_API_GROUP_ID) || !componentWithDetails.getMetadata().containsKey(METADATA_API_ARTIFACT_NAME)) {
            this.componentService.patch(new Component().id(componentWithDetails.getId()).putMetadataItem(METADATA_API_GROUP_ID, apiVersion.getMetadata().get(METADATA_API_GROUP_ID)).putMetadataItem(METADATA_API_ARTIFACT_NAME, apiVersion.getMetadata().get(METADATA_API_ARTIFACT_NAME)));
        }
        apiVersion.component(new Component().id(componentWithDetails.getId()));
        apiVersion.released(Boolean.valueOf(false));
        apiVersion.apiRepositoryStatus(ApiVersion.ApiRepositoryStatusEnum.PENDING);
        ApiVersion apiVersionWithId = this.resourceManager.addApiVersion(apiVersion);
        Session session = this.kathraSessionManager.getCurrentSession();
        File permApiFile = this.tmpFileToPermanentFile(apiFile);
        if (!permApiFile.getName().equals(API_FILENAME)) {
            throw new ApiException("Filename is not 'swagger.yaml'");
        }
        CompletableFuture.runAsync(() -> {
            this.kathraSessionManager.handleSession(session);
            this.createLibrariesApiVersionUpdateSourceAndBuild(apiVersionWithId, permApiFile, callback);
        });
        return apiVersionWithId;
    }

    private File tmpFileToPermanentFile(File apiFile) throws IOException {
        File tmpFile = new File(apiFile.getParentFile().getPath() + File.separator + "AppManager-Swagger_" + apiFile.getName() + File.separator + API_FILENAME);
        FileUtils.copyFile((File)apiFile, (File)tmpFile);
        return tmpFile;
    }

    private void checkApiVersionFromApiFile(ApiVersion apiVersion) {
        if (StringUtils.isEmpty((CharSequence)apiVersion.getVersion())) {
            throw new IllegalArgumentException("Version should be defined");
        }
        if (!PATTERN_NAME.matcher(apiVersion.getVersion()).find()) {
            throw new IllegalArgumentException("Version do not respect nomenclature X.X.X (ex: 1.0.1)");
        }
        if (StringUtils.isEmpty((CharSequence)((CharSequence)apiVersion.getMetadata().get(METADATA_API_GROUP_ID)))) {
            throw new IllegalArgumentException("Metadata artifact-groupId not defined");
        }
        if (StringUtils.isEmpty((CharSequence)((CharSequence)apiVersion.getMetadata().get(METADATA_API_ARTIFACT_NAME)))) {
            throw new IllegalArgumentException("Metadata artifact-artifactName not defined");
        }
    }

    public ApiVersion update(ApiVersion apiVersion, File apiFile, Runnable callback) throws ApiException, IOException {
        if (apiVersion == null) {
            throw new IllegalArgumentException("ApiVersion is null.");
        }
        if (apiFile == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (this.isReady((Resource)apiVersion) && apiVersion.isReleased().booleanValue()) {
            throw new IllegalStateException("ApiVersion '" + apiVersion.getId() + "' is already released.");
        }
        ApiVersion apiVersionFromFile = this.openApiParser.getApiVersionFromApiFile(apiFile);
        apiVersionFromFile.getMetadata().putIfAbsent(METADATA_API_ARTIFACT_NAME, apiVersion.getMetadata().get(METADATA_API_ARTIFACT_NAME));
        apiVersionFromFile.getMetadata().putIfAbsent(METADATA_API_GROUP_ID, apiVersion.getMetadata().get(METADATA_API_GROUP_ID));
        this.checkApiVersionFromApiFile(apiVersion);
        if (!apiVersionFromFile.getVersion().equals(apiVersion.getVersion())) {
            throw new IllegalArgumentException("ApiVersion and apiFile have different version. ApiVersion=" + apiVersion.getVersion() + " apiFile=" + apiVersionFromFile.getVersion());
        }
        if (!apiVersion.getMetadata().get(METADATA_API_GROUP_ID).equals(apiVersionFromFile.getMetadata().get(METADATA_API_GROUP_ID))) {
            throw new IllegalArgumentException("ApiVersion and apiFile have different artifact's groupId. ApiVersion=" + apiVersion.getMetadata().get(METADATA_API_GROUP_ID) + " apiFile=" + apiVersionFromFile.getMetadata().get(METADATA_API_GROUP_ID));
        }
        if (!apiVersion.getMetadata().get(METADATA_API_ARTIFACT_NAME).equals(apiVersionFromFile.getMetadata().get(METADATA_API_ARTIFACT_NAME))) {
            throw new IllegalArgumentException("ApiVersion and apiFile have different artifact's name. ApiVersion=" + apiVersion.getMetadata().get(METADATA_API_ARTIFACT_NAME) + " apiFile=" + apiVersionFromFile.getMetadata().get(METADATA_API_ARTIFACT_NAME));
        }
        this.updateStatus(apiVersion, Resource.StatusEnum.UPDATING);
        File permApiFile = this.tmpFileToPermanentFile(apiFile);
        if (!permApiFile.getName().equals(API_FILENAME)) {
            throw new ApiException("Filename is not 'swagger.yaml'");
        }
        Session session = this.kathraSessionManager.getCurrentSession();
        CompletableFuture.runAsync(() -> {
            try {
                this.kathraSessionManager.handleSession(session);
                this.patch(apiVersion.apiRepositoryStatus(ApiVersion.ApiRepositoryStatusEnum.UPDATING));
                this.updateSwaggerFileIntoApiRepository(apiVersion, permApiFile);
                for (LibraryApiVersion libraryApiVersion : apiVersion.getLibrariesApiVersions()) {
                    this.libraryApiVersionService.update(libraryApiVersion, permApiFile, () -> this.notifyWhenLibraryRepositoryIsUpdated(apiVersion, permApiFile, callback));
                }
            }
            catch (Exception e) {
                try {
                    this.patch(apiVersion.apiRepositoryStatus(ApiVersion.ApiRepositoryStatusEnum.ERROR));
                }
                catch (ApiException e1) {
                    this.deleteApiFile(permApiFile);
                }
                this.manageError(apiVersion, e);
                if (callback != null) {
                    callback.run();
                }
            }
        });
        return apiVersion;
    }

    private List<ApiVersion> getApiVersionByArtifact(String groupId, String artifactName) throws ApiException {
        return this.resourceManager.getApiVersions().parallelStream().filter(item -> artifactName.equals(item.getMetadata().get(METADATA_API_ARTIFACT_NAME)) && groupId.equals(item.getMetadata().get(METADATA_API_GROUP_ID))).collect(Collectors.toList());
    }

    private void createLibrariesApiVersionUpdateSourceAndBuild(ApiVersion apiVersion, File apiFile, Runnable callback) {
        try {
            this.updateSwaggerFileIntoApiRepository(apiVersion, apiFile);
            ArrayList<LibraryApiVersion> librariesApiVersion = new ArrayList<LibraryApiVersion>();
            for (Library library : this.componentService.getById(apiVersion.getComponent().getId()).get().getLibraries()) {
                librariesApiVersion.add(this.createLibraryApiVersion(apiVersion, library, apiFile, callback));
            }
            this.patch(new ApiVersion().id(apiVersion.getId()).librariesApiVersions(librariesApiVersion));
        }
        catch (Exception e) {
            this.manageError(apiVersion, e);
            this.deleteApiFile(apiFile);
        }
    }

    private void updateSwaggerFileIntoApiRepository(ApiVersion apiVersion, File file) throws ApiException, NotFoundException {
        block3: {
            Component component = this.componentService.getById(apiVersion.getComponent().getId()).orElseThrow(() -> new NotFoundException("Component not found"));
            SourceRepository sourceRepository = this.sourceRepositoryService.getById(component.getApiRepository().getId()).orElseThrow(() -> new NotFoundException("SourceRepository not found"));
            try {
                SourceRepositoryCommit commit = this.sourceRepositoryService.commitFileAndTag(sourceRepository, DEFAULT_BRANCH, file, API_FILENAME, apiVersion.getVersion());
                if (commit == null || StringUtils.isEmpty((CharSequence)commit.getId())) {
                    throw new IllegalStateException("A commit with id should be return by SourceRepositoryService");
                }
            }
            catch (ApiException e) {
                if (e.getCode() == KathraException.ErrorCode.PRECONDITION_FAILED.getCode()) break block3;
                throw e;
            }
        }
    }

    private LibraryApiVersion createLibraryApiVersion(ApiVersion apiVersion, Library library, File apiFile, Runnable callback) throws ApiException {
        LibraryApiVersion libraryApiVersion = this.libraryApiVersionService.create(apiVersion, library, apiFile, () -> this.notifyWhenLibraryRepositoryIsUpdated(apiVersion, apiFile, callback));
        this.logger.info("apiVersion '" + apiVersion.getId() + "' - LibraryApiVersion created with id " + libraryApiVersion.getId());
        if (apiVersion.getLibrariesApiVersions() == null || !apiVersion.getLibrariesApiVersions().contains(libraryApiVersion)) {
            apiVersion.addLibrariesApiVersionsItem(libraryApiVersion);
        }
        return libraryApiVersion;
    }

    private synchronized boolean notifyWhenLibraryRepositoryIsUpdated(ApiVersion apiVersion, File apiFile, Runnable callback) {
        this.logger.debug("ApiVersion '" + apiVersion.getId() + "' - '" + apiVersion.getName() + "' - a library's repository is updated");
        try {
            ApiVersion apiVersionFromDb = this.getById(apiVersion.getId()).get();
            this.logger.debug("ApiVersion '" + apiVersion.getId() + "' - '" + apiVersion.getName() + "' - has status " + apiVersionFromDb.getStatus());
            this.logger.debug("ApiVersion '" + apiVersion.getId() + "' - '" + apiVersion.getName() + "' - has ApiRepositoryStatus " + apiVersionFromDb.getApiRepositoryStatus());
            if (apiVersionFromDb.getApiRepositoryStatus().equals((Object)ApiVersion.ApiRepositoryStatusEnum.READY)) {
                return true;
            }
            if (apiVersionFromDb.getApiRepositoryStatus().equals((Object)ApiVersion.ApiRepositoryStatusEnum.ERROR)) {
                return false;
            }
            ArrayList librariesApiVersionDetailed = new ArrayList();
            AtomicReference exceptionFound = new AtomicReference();
            List librariesFromComponent = this.componentService.getById(apiVersion.getComponent().getId()).orElseThrow(() -> new IllegalStateException("Unable")).getLibraries();
            List librariesApiVersions = apiVersionFromDb.getLibrariesApiVersions();
            if (librariesFromComponent.size() != librariesApiVersions.size()) {
                this.logger.debug("All libraries are not created yet expect: " + librariesFromComponent.size() + " / created: " + librariesApiVersions.size());
                return false;
            }
            Session session = this.kathraSessionManager.getCurrentSession();
            boolean libraryIsNotReadyFound = apiVersionFromDb.getLibrariesApiVersions().parallelStream().map(Resource::getId).filter(Objects::nonNull).anyMatch(id -> {
                try {
                    this.kathraSessionManager.handleSession(session);
                    LibraryApiVersion libraryApiVersion = this.libraryApiVersionService.getById((String)id).orElseThrow(() -> new IllegalStateException("Unable to find libraryApiVersion"));
                    if (!this.checkLibraryApiVersionIsUpdated(libraryApiVersion)) {
                        this.logger.debug("LibraryApiVersion: " + libraryApiVersion.getId() + " / pipelineStatus: " + libraryApiVersion.getApiRepositoryStatus());
                        return true;
                    }
                    libraryApiVersion.library(this.libraryService.getById(libraryApiVersion.getLibrary().getId()).get());
                    librariesApiVersionDetailed.add(libraryApiVersion);
                    return false;
                }
                catch (Exception e) {
                    exceptionFound.set(e);
                    return true;
                }
            });
            if (exceptionFound.get() != null) {
                throw (Exception)exceptionFound.get();
            }
            if (!libraryIsNotReadyFound) {
                this.logger.info("ApiVersion '" + apiVersion.getId() + "' - '" + apiVersion.getName() + "' - all libraries are updated and tagged to version " + apiVersion.getVersion());
                apiVersionFromDb.setApiRepositoryStatus(ApiVersion.ApiRepositoryStatusEnum.READY);
                this.patch(apiVersionFromDb);
                this.deleteApiFile(apiFile);
                apiVersionFromDb.librariesApiVersions(librariesApiVersionDetailed);
                this.build(apiVersionFromDb, callback);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.manageError(apiVersion, e);
            this.deleteApiFile(apiFile);
            if (callback != null) {
                callback.run();
            }
            return false;
        }
    }

    private void deleteApiFile(File apiFile) {
        try {
            FileUtils.deleteDirectory((File)apiFile.getParentFile());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private boolean checkLibraryApiVersionIsUpdated(LibraryApiVersion libraryApiVersion) {
        if (this.isError((Resource)libraryApiVersion)) {
            throw new IllegalStateException("The LibraryApiVersion has status ERROR. LibraryApiVersion:" + libraryApiVersion.getId());
        }
        if (libraryApiVersion.getApiRepositoryStatus().equals((Object)LibraryApiVersion.ApiRepositoryStatusEnum.ERROR)) {
            throw new IllegalStateException("The library's repository have an error during update. LibraryApiVersion:" + libraryApiVersion.getId());
        }
        return libraryApiVersion.getApiRepositoryStatus().equals((Object)LibraryApiVersion.ApiRepositoryStatusEnum.READY);
    }

    private void build(ApiVersion apiVersion, Runnable callback) throws ApiException {
        this.logger.info("apiVersion '" + apiVersion.getId() + "' - build ");
        Session session = this.kathraSessionManager.getCurrentSession();
        AtomicReference exceptionFound = new AtomicReference();
        List libraryApiVersionWithLibraryDetails = this.getById(apiVersion.getId()).get().getLibrariesApiVersions().parallelStream().map(libraryApiVersion -> {
            try {
                this.kathraSessionManager.handleSession(session);
                LibraryApiVersion libraryApiVersionWithDetails = this.libraryApiVersionService.getById(libraryApiVersion.getId()).get();
                libraryApiVersionWithDetails.setLibrary(this.libraryService.getById(libraryApiVersionWithDetails.getLibrary().getId()).get());
                return libraryApiVersionWithDetails;
            }
            catch (ApiException e) {
                exceptionFound.set(e);
                return null;
            }
        }).collect(Collectors.toList());
        if (exceptionFound.get() != null) {
            throw (ApiException)((Object)exceptionFound.get());
        }
        apiVersion.setLibrariesApiVersions(libraryApiVersionWithLibraryDetails);
        ((Stream)Arrays.stream(Asset.LanguageEnum.values()).parallel()).forEach(lang -> {
            this.kathraSessionManager.handleSession(session);
            this.buildForLanguage(apiVersion, (Asset.LanguageEnum)lang, callback);
        });
    }

    private void buildForLanguage(ApiVersion apiVersion, Asset.LanguageEnum language, Runnable callback) {
        Session session = this.kathraSessionManager.getCurrentSession();
        Runnable buildApiClient = () -> {
            this.kathraSessionManager.handleSession(session);
            Runnable callbackPostBuild = () -> this.notifyWhenBuildLibraryPipelineIsFinished(apiVersion, callback);
            this.buildForLanguageAndTypeLib(apiVersion, language, Library.TypeEnum.CLIENT, callbackPostBuild, callback);
        };
        Runnable buildInterface = () -> {
            this.kathraSessionManager.handleSession(session);
            this.buildForLanguageAndTypeLib(apiVersion, language, Library.TypeEnum.INTERFACE, buildApiClient, callback);
        };
        this.buildForLanguageAndTypeLib(apiVersion, language, Library.TypeEnum.MODEL, buildInterface, callback);
    }

    private LibraryApiVersion findLibraryApiVersion(ApiVersion apiVersion, Asset.LanguageEnum language, Library.TypeEnum type) throws ApiException {
        AtomicReference exceptionFound = new AtomicReference();
        List libraries = apiVersion.getLibrariesApiVersions().parallelStream().filter(libraryApiVersion -> libraryApiVersion.getLibrary().getLanguage().equals((Object)language) && libraryApiVersion.getLibrary().getType().equals((Object)type)).collect(Collectors.toList());
        if (exceptionFound.get() != null) {
            throw (ApiException)((Object)exceptionFound.get());
        }
        if (libraries.isEmpty()) {
            throw new IllegalStateException("Not library found for apiVersion " + apiVersion.getId() + ", lang " + language + ", type=" + type);
        }
        if (libraries.size() > 1) {
            throw new IllegalStateException("Several libraries found for apiVersion " + apiVersion.getId() + ", lang " + language + ", type=" + type);
        }
        return (LibraryApiVersion)libraries.get(0);
    }

    private void buildForLanguageAndTypeLib(ApiVersion apiVersion, Asset.LanguageEnum language, Library.TypeEnum type, Runnable callbackNextBuild, Runnable finalCallback) {
        block2: {
            this.logger.info("ApiVersion '" + apiVersion.getId() + "' - '" + apiVersion.getName() + "' - build language " + language + " libType " + type);
            try {
                LibraryApiVersion libraryApiVersion = this.findLibraryApiVersion(apiVersion, language, type);
                this.libraryApiVersionService.build(libraryApiVersion, callbackNextBuild);
            }
            catch (ApiException e) {
                this.logger.error("apiVersion '" + apiVersion.getId() + "' - unable to build apiVersion for language " + language);
                this.manageError(apiVersion, (Exception)((Object)e));
                if (finalCallback == null) break block2;
                finalCallback.run();
            }
        }
    }

    private synchronized boolean notifyWhenBuildLibraryPipelineIsFinished(ApiVersion apiVersion, Runnable callback) {
        block6: {
            this.logger.info("ApiVersion '" + apiVersion.getId() + "' - '" + apiVersion.getName() + "' - the pipeline have finished.. Check if apiVersion is ready");
            try {
                ApiVersion apiVersionWithDetails = this.getById(apiVersion.getId()).orElseThrow(() -> new IllegalStateException("Unable to find ApiVersion " + apiVersion.getId() + "."));
                if (this.isError((Resource)apiVersionWithDetails)) {
                    return false;
                }
                if (this.isReady((Resource)apiVersionWithDetails)) {
                    return true;
                }
                AtomicReference exceptionFound = new AtomicReference();
                Session session = this.kathraSessionManager.getCurrentSession();
                boolean libraryIsNotReadyFound = apiVersionWithDetails.getLibrariesApiVersions().parallelStream().map(Resource::getId).anyMatch(id -> {
                    try {
                        this.kathraSessionManager.handleSession(session);
                        LibraryApiVersion libraryApiVersionWithDetails = this.libraryApiVersionService.getById((String)id).orElseThrow(() -> new IllegalStateException("Unable to find LibraryApiVersion with id :" + id));
                        return !this.checkLibraryApiVersionIsBuild(libraryApiVersionWithDetails);
                    }
                    catch (Exception e) {
                        exceptionFound.set(e);
                        return true;
                    }
                });
                if (exceptionFound.get() != null) {
                    throw (Exception)exceptionFound.get();
                }
                if (!libraryIsNotReadyFound) {
                    this.logger.info("ApiVersion '" + apiVersion.getId() + "' - '" + apiVersion.getName() + "' - all libraries are updated and build");
                    this.validate(apiVersion, callback);
                    return true;
                }
            }
            catch (Exception e) {
                this.manageError(apiVersion, e);
                if (callback == null) break block6;
                callback.run();
            }
        }
        return false;
    }

    private boolean checkLibraryApiVersionIsBuild(LibraryApiVersion libraryApiVersionWithDetails) {
        if (this.isError((Resource)libraryApiVersionWithDetails)) {
            throw new IllegalStateException("The LibraryApiVersion has status ERROR. LibraryApiVersion:" + libraryApiVersionWithDetails.getId());
        }
        if (!this.isReady((Resource)libraryApiVersionWithDetails)) {
            return false;
        }
        if (libraryApiVersionWithDetails.getPipelineStatus().equals((Object)LibraryApiVersion.PipelineStatusEnum.ERROR)) {
            throw new IllegalStateException("The library's repository have an error during build. LibraryApiVersion:" + libraryApiVersionWithDetails.getId());
        }
        return libraryApiVersionWithDetails.getPipelineStatus().equals((Object)LibraryApiVersion.PipelineStatusEnum.READY);
    }

    private synchronized boolean validate(ApiVersion apiVersion, Runnable apiVersionReadyCallback) {
        if (this.isReady((Resource)apiVersion)) {
            return true;
        }
        if (this.isError((Resource)apiVersion)) {
            return false;
        }
        this.logger.info("ApiVersion '" + apiVersion.getId() + "' - '" + apiVersion.getName() + "' - all libraries are updated and build");
        this.updateStatus(apiVersion, Resource.StatusEnum.READY);
        if (apiVersionReadyCallback != null) {
            apiVersionReadyCallback.run();
        }
        return true;
    }

    public Optional<ApiVersion> getApiVersion(Component component, String versionName) throws ApiException {
        return this.resourceManager.getApiVersions().parallelStream().filter(item -> item.getComponent().getId().equals(component.getId()) && item.getVersion().equals(versionName)).findFirst();
    }

    public List<ApiVersion> getApiVersions(List<Component> components) throws ApiException {
        if (components == null || components.isEmpty()) {
            return new ArrayList<ApiVersion>();
        }
        return this.resourceManager.getApiVersions().stream().filter(apiVersion -> components.stream().anyMatch(component -> apiVersion.getComponent().getId().equals(component.getId()))).collect(Collectors.toList());
    }

    public List<ApiVersion> getApiVersionsForImplementationVersion(List<ImplementationVersion> implementationVersions) throws ApiException {
        if (implementationVersions == null || implementationVersions.isEmpty()) {
            return new ArrayList<ApiVersion>();
        }
        return this.resourceManager.getApiVersions().stream().filter(apiVersion -> implementationVersions.stream().anyMatch(implementationVersion -> apiVersion.getId().equals(implementationVersion.getApiVersion().getId()))).collect(Collectors.toList());
    }

    @Override
    protected void patch(ApiVersion object) throws ApiException {
        this.resourceManager.updateApiVersionAttributes(object.getId(), object);
    }

    @Override
    public Optional<ApiVersion> getById(String id) throws ApiException {
        ApiVersion apiVersion = this.resourceManager.getApiVersion(id);
        return apiVersion == null ? Optional.empty() : Optional.of(apiVersion);
    }

    @Override
    public List<ApiVersion> getAll() throws ApiException {
        return this.resourceManager.getApiVersions();
    }

    public void delete(ApiVersion apiVersion, boolean purge, boolean force) throws ApiException {
        try {
            ApiVersion apiVersionToDeleted = this.resourceManager.getApiVersion(apiVersion.getId());
            if (this.isDeleted((Resource)apiVersionToDeleted)) {
                return;
            }
            if (apiVersionToDeleted.getImplementationsVersions().size() > 0 && !force) {
                throw new IllegalStateException("ApiVersion " + apiVersionToDeleted.getId() + " is used by some versions of implementations, delete its versions implementations before");
            }
            AtomicReference exceptionFound = new AtomicReference();
            Session session = this.kathraSessionManager.getCurrentSession();
            apiVersionToDeleted.getImplementationsVersions().parallelStream().forEach(implementationVersion -> {
                this.kathraSessionManager.handleSession(session);
                try {
                    this.implementationVersionService.delete((ImplementationVersion)implementationVersion, purge);
                }
                catch (ApiException e) {
                    exceptionFound.set(e);
                }
            });
            if (exceptionFound.get() != null) {
                throw (ApiException)((Object)exceptionFound.get());
            }
            apiVersionToDeleted.getLibrariesApiVersions().parallelStream().forEach(libApiVersion -> {
                this.kathraSessionManager.handleSession(session);
                try {
                    this.libraryApiVersionService.delete((LibraryApiVersion)libApiVersion, purge);
                }
                catch (ApiException e) {
                    exceptionFound.set(e);
                }
            });
            if (exceptionFound.get() != null) {
                throw (ApiException)((Object)exceptionFound.get());
            }
            this.resourceManager.deleteApiVersion(apiVersionToDeleted.getId());
            apiVersion.status(Resource.StatusEnum.DELETED);
        }
        catch (ApiException e) {
            this.manageError(apiVersion, (Exception)((Object)e));
            throw e;
        }
    }
}

