/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.apiversion;

import java.io.File;
import java.security.InvalidParameterException;
import javassist.NotFoundException;
import javax.activation.FileDataSource;
import javax.inject.Named;
import org.apache.camel.cdi.ContextName;
import org.kathra.appmanager.Config;
import org.kathra.appmanager.apiversion.ApiVersionService;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.service.ApiVersionsService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Component;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.utils.KathraException;

@Named(value="ApiVersionsController")
@ContextName(value="AppManager")
public class ApiVersionsController
implements ApiVersionsService {
    private static final String apiFilePath = "swagger.yaml";
    private ServiceInjection serviceInjection;
    private final ApiVersionService apiVersionService;
    private final ComponentService componentService;
    private final SourceRepositoryService sourceRepositoryService;

    public ApiVersionsController(ApiVersionService apiVersionService, ComponentService componentService, SourceRepositoryService sourceRepositoryService) {
        this.apiVersionService = apiVersionService;
        this.componentService = componentService;
        this.sourceRepositoryService = sourceRepositoryService;
    }

    public ApiVersionsController() {
        this.serviceInjection = new ServiceInjection(new Config(), this.getSessionManager());
        this.apiVersionService = this.serviceInjection.getService(ApiVersionService.class);
        this.componentService = this.serviceInjection.getService(ComponentService.class);
        this.sourceRepositoryService = this.serviceInjection.getService(SourceRepositoryService.class);
    }

    public ApiVersion createApiVersion(String componentId, FileDataSource openApiFile) throws Exception {
        if (openApiFile == null) {
            throw new InvalidParameterException("File source is not present");
        }
        return this.apiVersionService.create(componentId, openApiFile.getFile(), null);
    }

    public ApiVersion deleteApiVersion(String apiVersionId) throws Exception {
        ApiVersion apiVersion = this.apiVersionService.getById(apiVersionId).orElseThrow(() -> new NotFoundException("ApiVersion not found"));
        this.apiVersionService.delete(apiVersion, true, true);
        return apiVersion.status(Resource.StatusEnum.DELETED);
    }

    public FileDataSource getApiFile(String apiVersionId) throws Exception {
        File file;
        ApiVersion apiVersion = this.apiVersionService.getById(apiVersionId).orElseThrow(() -> new NotFoundException("ApiVersion not found"));
        Component component = this.componentService.getById(apiVersion.getComponent().getId()).orElseThrow(() -> new NotFoundException("Component not found"));
        SourceRepository sourceRepository = this.sourceRepositoryService.getById(component.getApiRepository().getId()).orElseThrow(() -> new NotFoundException("Component not found"));
        try {
            file = this.sourceRepositoryService.getFile(sourceRepository, apiVersion.getVersion(), apiFilePath);
        }
        catch (Exception e) {
            file = this.sourceRepositoryService.getFile(sourceRepository, apiVersion.getVersion(), "swagger.yml");
        }
        return new FileDataSource(file);
    }

    public ApiVersion getApiVersionById(String apiVersionId) throws Exception {
        return this.apiVersionService.getById(apiVersionId).orElseThrow(() -> new KathraException("Unable to find Api Version '" + apiVersionId + "'", null, KathraException.ErrorCode.NOT_FOUND));
    }

    public ApiVersion updateApiVersion(String apiVersionId, FileDataSource openApiFile) throws Exception {
        if (openApiFile == null) {
            throw new InvalidParameterException("File source is not present");
        }
        ApiVersion apiVersion = this.apiVersionService.getById(apiVersionId).orElseThrow(() -> new NotFoundException("ApiVersion not found"));
        return this.apiVersionService.update(apiVersion, openApiFile.getFile(), null);
    }
}

