/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.apiversion;

import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import org.kathra.core.model.ApiVersion;

public class OpenApiParser {
    private SwaggerParser parser;

    public OpenApiParser() {
        this.parser = new SwaggerParser();
    }

    public OpenApiParser(SwaggerParser parser) {
        this.parser = parser;
    }

    public ApiVersion getApiVersionFromApiFile(File file) {
        try {
            Swagger swagger = this.parser.read(file.getPath());
            return new ApiVersion().name(swagger.getInfo().getTitle()).version(swagger.getInfo().getVersion()).putMetadataItem("artifact-groupId", swagger.getInfo().getVendorExtensions().get("x-groupId")).putMetadataItem("artifact-artifactName", swagger.getInfo().getVendorExtensions().get("x-artifactName"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ApiFile doesn't respect OpenApi specifications");
        }
    }
}

