/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.component;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.apiversion.ApiVersionService;
import org.kathra.appmanager.group.GroupService;
import org.kathra.appmanager.implementation.ImplementationService;
import org.kathra.appmanager.library.LibraryService;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Asset;
import org.kathra.core.model.Component;
import org.kathra.core.model.Group;
import org.kathra.core.model.Implementation;
import org.kathra.core.model.Library;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.resourcemanager.client.ComponentsClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentService
extends AbstractResourceService<Component> {
    public static final String METADATA_GROUP_PATH = "groupPath";
    public static final String METADATA_GROUP_ID = "groupId";
    public static final String METADATA_API_GROUP_ID = "artifact-groupId";
    public static final String METADATA_API_ARTIFACT_NAME = "artifact-artifactName";
    private static final Pattern PATTERN_NAME = Pattern.compile("^[0-9A-Za-z_\\-]+$");
    private GroupService groupsService;
    private SourceRepositoryService sourceRepositoryService;
    private LibraryService libraryService;
    private ComponentsClient componentsClient;
    private ApiVersionService apiVersionService;
    private ImplementationService implementationService;
    private Logger logger = LoggerFactory.getLogger(ComponentService.class);

    public ComponentService() {
    }

    @Override
    public void configure(ServiceInjection service) {
        super.configure(service);
        this.componentsClient = new ComponentsClient(service.getConfig().getResourceManagerUrl(), service.getSessionManager());
        this.sourceRepositoryService = service.getService(SourceRepositoryService.class);
        this.libraryService = service.getService(LibraryService.class);
        this.groupsService = service.getService(GroupService.class);
        this.apiVersionService = service.getService(ApiVersionService.class);
        this.implementationService = service.getService(ImplementationService.class);
    }

    public ComponentService(ComponentsClient componentsClient, SourceRepositoryService sourceRepositoryService, ApiVersionService apiVersionService, LibraryService libraryService, GroupService groupsService, KathraSessionManager kathraSessionManager, ImplementationService implementationService) {
        this.componentsClient = componentsClient;
        this.implementationService = implementationService;
        this.sourceRepositoryService = sourceRepositoryService;
        this.libraryService = libraryService;
        this.groupsService = groupsService;
        this.apiVersionService = apiVersionService;
        this.kathraSessionManager = kathraSessionManager;
    }

    public Component create(@NotNull Component component, @NotNull String groupPath) throws ApiException {
        return this.create(component, groupPath, null);
    }

    public Component create(@NotNull Component component, @NotNull String groupPath, Runnable callback) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)groupPath)) {
            throw new IllegalArgumentException("GroupPath should be defined");
        }
        Optional<Group> group = this.groupsService.findByPath(groupPath);
        if (!group.isPresent()) {
            throw new IllegalArgumentException("GroupPath defined '" + groupPath + "' doesn't exist.");
        }
        if (StringUtils.isEmpty((CharSequence)component.getName())) {
            throw new IllegalArgumentException("Component's name is empty");
        }
        if (!PATTERN_NAME.matcher(component.getName()).find()) {
            throw new IllegalArgumentException("Component's name do not respect regex's pattern " + PATTERN_NAME.pattern());
        }
        if (this.getByNameAndGroupPath(component.getName(), groupPath).isPresent()) {
            throw new IllegalArgumentException("Component already exists");
        }
        Component componentToAdd = new Component().name(component.getName()).title(component.getTitle()).description(component.getDescription()).putMetadataItem(METADATA_GROUP_ID, (Object)group.get().getId()).putMetadataItem(METADATA_GROUP_PATH, (Object)group.get().getPath()).status(Resource.StatusEnum.PENDING);
        try {
            Component componentAdded = this.componentsClient.addComponent(componentToAdd, group.get().getPath());
            try {
                if (StringUtils.isEmpty((CharSequence)componentAdded.getId())) {
                    throw new IllegalStateException("Component'id should be defined");
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)componentAdded.getMetadata().get(METADATA_GROUP_ID)))) {
                    throw new IllegalStateException("Metadata 'groupId' of component should be defined");
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)componentAdded.getMetadata().get(METADATA_GROUP_PATH)))) {
                    throw new IllegalStateException("Metadata 'groupPath' of component should be defined");
                }
            }
            catch (Exception e) {
                this.manageError(componentAdded, e);
                throw e;
            }
            Session session = this.kathraSessionManager.getCurrentSession();
            CompletableFuture.runAsync(() -> {
                try {
                    this.kathraSessionManager.handleSession(session);
                    SourceRepository sourceRepositoryApi = this.createSourceRepositoryApi(componentAdded, callback);
                    for (Asset.LanguageEnum languageProgramming : Asset.LanguageEnum.values()) {
                        for (Library.TypeEnum libraryType : Library.TypeEnum.values()) {
                            Thread.sleep(200L);
                            this.createLibrary(componentAdded, languageProgramming, libraryType, callback);
                        }
                    }
                }
                catch (Exception e) {
                    this.manageError(componentAdded, e);
                }
            });
            return componentAdded;
        }
        catch (Exception e) {
            this.manageError(component, e);
            throw e;
        }
    }

    public void delete(Component component, boolean force, boolean purge) throws ApiException {
        Component componentToDeleted = this.componentsClient.getComponent(component.getId());
        if (this.isDeleted((Resource)componentToDeleted)) {
            return;
        }
        if (componentToDeleted.getImplementations().size() > 0 && !force) {
            throw new IllegalStateException("Component " + component.getId() + " contains implementations, delete its implementations before");
        }
        try {
            AtomicReference exceptionFound = new AtomicReference();
            Session session = this.kathraSessionManager.getCurrentSession();
            componentToDeleted.getImplementations().parallelStream().forEach(implementation -> {
                this.kathraSessionManager.handleSession(session);
                try {
                    this.implementationService.delete((Implementation)implementation, purge);
                }
                catch (ApiException e) {
                    exceptionFound.set(e);
                }
            });
            if (exceptionFound.get() != null) {
                throw (ApiException)((Object)exceptionFound.get());
            }
            componentToDeleted.getVersions().parallelStream().forEach(apiVersion -> {
                this.kathraSessionManager.handleSession(session);
                try {
                    this.apiVersionService.delete((ApiVersion)apiVersion, force, purge);
                }
                catch (ApiException e) {
                    exceptionFound.set(e);
                }
            });
            if (exceptionFound.get() != null) {
                throw (ApiException)((Object)exceptionFound.get());
            }
            if (componentToDeleted.getApiRepository() != null) {
                this.sourceRepositoryService.delete(componentToDeleted.getApiRepository(), purge);
            }
            componentToDeleted.getLibraries().parallelStream().forEach(library -> {
                this.kathraSessionManager.handleSession(session);
                try {
                    this.libraryService.delete((Library)library, force, purge);
                }
                catch (ApiException e) {
                    exceptionFound.set(e);
                }
            });
            if (exceptionFound.get() != null) {
                throw (ApiException)((Object)exceptionFound.get());
            }
            this.componentsClient.deleteComponent(componentToDeleted.getId());
            component.status(Resource.StatusEnum.DELETED);
        }
        catch (ApiException e) {
            this.manageError(component, (Exception)((Object)e));
            throw e;
        }
    }

    public synchronized boolean validate(Component component, Runnable callback) {
        try {
            Component componentUpdated = this.componentsClient.getComponent(component.getId());
            if (this.isReady((Resource)componentUpdated)) {
                return true;
            }
            boolean apiRepositoryReady = this.checkRepositoryIsReady(componentUpdated);
            boolean librariesReady = this.checkLibraryIsReady(componentUpdated);
            this.logger.info("validate component id=" + componentUpdated.getId() + ", apiRepositoryReady=" + apiRepositoryReady + ", librariesReady=" + librariesReady);
            if (apiRepositoryReady && librariesReady) {
                this.updateStatus(componentUpdated, Resource.StatusEnum.READY);
                if (callback != null) {
                    callback.run();
                }
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to validate post creating", (Throwable)e);
            this.manageError(component, e);
        }
        return false;
    }

    private synchronized boolean checkRepositoryIsReady(Component component) throws ApiException {
        if (component.getApiRepository() == null || component.getApiRepository().getId() == null) {
            return false;
        }
        SourceRepository sourceRepository = this.sourceRepositoryService.getById(component.getApiRepository().getId()).orElse(null);
        this.throwExceptionIfError((Resource)sourceRepository);
        return this.isReady((Resource)sourceRepository);
    }

    private synchronized boolean checkLibraryIsReady(Component component) throws ApiException {
        if (component.getLibraries() == null || component.getLibraries().isEmpty()) {
            return false;
        }
        if (component.getLibraries().size() < Asset.LanguageEnum.values().length * Library.TypeEnum.values().length) {
            this.logger.info("All libraries are not initialized : " + component.getLibraries().size());
            return false;
        }
        for (Library item : component.getLibraries()) {
            if (item.getId() == null) {
                return false;
            }
            Optional<Library> library = this.libraryService.getById(item.getId());
            if (library.isPresent()) {
                this.throwExceptionIfError((Resource)library.get());
            }
            if (library.isPresent() && this.isReady((Resource)library.get())) continue;
            this.logger.info("Library '" + item.getId() + "' is not ready or not exist.");
            return false;
        }
        return true;
    }

    @Override
    public void patch(Component component) throws ApiException {
        this.componentsClient.updateComponentAttributes(component.getId(), component);
    }

    private Library createLibrary(Component component, Asset.LanguageEnum languageProgramming, Library.TypeEnum typeLibrary, Runnable afterReadyCallBack) throws ApiException {
        Runnable callback = () -> this.validate(component, afterReadyCallBack);
        return this.libraryService.add(component, languageProgramming, typeLibrary, callback);
    }

    private SourceRepository createSourceRepositoryApi(Component component, Runnable afterReadyCallBack) throws ApiException {
        String[] deploysKeys = new String[]{(String)component.getMetadata().get(METADATA_GROUP_ID)};
        String groupPathApi = component.getMetadata().get(METADATA_GROUP_PATH) + "/components/" + component.getName() + "/api";
        SourceRepository sourceRepositoryApi = this.sourceRepositoryService.create(component.getName(), groupPathApi, deploysKeys, () -> this.validate(component, afterReadyCallBack));
        component.setApiRepository(sourceRepositoryApi);
        this.componentsClient.updateComponentAttributes(component.getId(), new Component().id(component.getId()).apiRepository(sourceRepositoryApi));
        return sourceRepositoryApi;
    }

    @Override
    public Optional<Component> getById(String componentId) throws ApiException {
        Component component = this.componentsClient.getComponent(componentId);
        return component == null ? Optional.empty() : Optional.of(component);
    }

    public Optional<Component> getByNameAndGroupPath(String componentName, String groupPath) throws ApiException {
        return this.componentsClient.getComponents().stream().filter(existingComponent -> componentName != null && componentName.equals(existingComponent.getName()) && groupPath != null && groupPath.equals(existingComponent.getMetadata().get(METADATA_GROUP_PATH))).findFirst();
    }

    public List<Component> getAllComponentsWithApiVersions() throws ApiException {
        List components = this.componentsClient.getComponents();
        if (components == null || components.isEmpty()) {
            return new ArrayList<Component>();
        }
        for (Component component2 : components) {
            component2.setVersions(new LinkedList());
        }
        Map<String, Component> componentMap = components.stream().collect(Collectors.toMap(Resource::getId, component -> component));
        List<ApiVersion> apiVersions = this.apiVersionService.getApiVersions(components);
        for (ApiVersion apiVersion : apiVersions) {
            Component apiComponent = componentMap.get(apiVersion.getComponent().getId());
            if (apiComponent == null) continue;
            apiComponent.addVersionsItem(apiVersion);
        }
        return components;
    }

    @Override
    public List<Component> getAll() throws ApiException {
        return this.componentsClient.getComponents();
    }
}

