/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.component;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javassist.NotFoundException;
import javax.inject.Named;
import org.apache.camel.cdi.ContextName;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.Config;
import org.kathra.appmanager.apiversion.ApiVersionService;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.service.ComponentsService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Component;
import org.kathra.core.model.Resource;

@Named(value="ComponentsController")
@ContextName(value="AppManager")
public class ComponentsController
implements ComponentsService {
    private ServiceInjection serviceInjection;
    private ComponentService componentService;
    private ApiVersionService apiVersionService;

    public ComponentsController(ComponentService componentService, ApiVersionService apiVersionService) {
        this.componentService = componentService;
        this.apiVersionService = apiVersionService;
    }

    public ComponentsController() {
        this.serviceInjection = new ServiceInjection(new Config(), this.getSessionManager());
        this.componentService = this.serviceInjection.getService(ComponentService.class);
        this.apiVersionService = this.serviceInjection.getService(ApiVersionService.class);
    }

    public Component createComponent(Component component) throws Exception {
        if (component.getMetadata().containsKey("groupPath") && !StringUtils.isEmpty((CharSequence)((CharSequence)component.getMetadata().get("groupPath")))) {
            String groupPath = (String)component.getMetadata().get("groupPath");
            return this.componentService.create(new Component().name(component.getName()).title(component.getTitle()).description(component.getDescription()), groupPath);
        }
        throw new IllegalArgumentException("Metadata groupPath should be defined into Component");
    }

    public Component deleteComponentById(String componentId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)componentId)) {
            throw new IllegalArgumentException("componentId must be specified");
        }
        Component component = this.componentService.getById(componentId).orElseThrow(() -> new NotFoundException("Component not found"));
        this.componentService.delete(component, true, true);
        return component.status(Resource.StatusEnum.DELETED);
    }

    public Component getComponentById(String componentId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)componentId)) {
            throw new IllegalArgumentException("componentId must be specified");
        }
        Component component = this.componentService.getById(componentId).orElseThrow(() -> new NotFoundException("Component not found"));
        List<ApiVersion> componentApiVersions = this.apiVersionService.getApiVersions((List<Component>)ImmutableList.of((Object)component));
        component.setVersions(componentApiVersions);
        return component;
    }

    public List<Component> getComponents() throws Exception {
        return this.componentService.getAllComponentsWithApiVersions();
    }
}

