/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.group;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kathra.appmanager.Config;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.SecurityService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.core.model.Group;
import org.kathra.resourcemanager.client.GroupsClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraException;
import org.kathra.utils.KathraSessionManager;

public class GroupService
extends AbstractResourceService<Group> {
    private GroupsClient resourceManager;
    private SecurityService securityService;

    public GroupService() {
    }

    @Override
    public void configure(ServiceInjection serviceInjection) {
        this.resourceManager = new GroupsClient(serviceInjection.getConfig().getResourceManagerUrl(), serviceInjection.getSessionManager());
        this.securityService = new SecurityService(serviceInjection.getSessionManager());
    }

    public GroupService(GroupsClient resourceManager, SecurityService securityService) {
        this.resourceManager = resourceManager;
        this.securityService = securityService;
    }

    public GroupService(Config config, KathraSessionManager sessionManager) {
        this.resourceManager = new GroupsClient(config.getResourceManagerUrl(), sessionManager);
    }

    @Override
    protected void patch(Group object) throws ApiException {
        this.resourceManager.updateGroupAttributes(object.getId(), object);
    }

    @Override
    public Optional<Group> getById(String id) throws ApiException {
        return Optional.empty();
    }

    @Override
    public List<Group> getAll() throws ApiException {
        return this.resourceManager.getGroups();
    }

    public Optional<Group> findByPath(String path) throws ApiException {
        return this.resourceManager.getGroups().parallelStream().filter(group -> group.getPath().equals(path)).findFirst();
    }

    public List<Group> getGroupsFromCurrentUser() throws KathraException {
        try {
            List groupsFromToken = (List)this.securityService.getUserInfo(SecurityService.UserInformation.GROUPS);
            List groupsExisting = this.resourceManager.getGroups();
            groupsFromToken.stream().filter(groupToken -> groupsExisting.stream().noneMatch(group -> group.getPath().equals(groupToken))).forEach(groupToken -> this.logger.warn("Group '" + groupToken + "' from token no existing in db"));
            return groupsExisting.stream().filter(group -> groupsFromToken.contains(group.getPath())).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.error("Error getMyGroups", (Throwable)e);
            throw new KathraException("Error getMyGroups", (Throwable)e, KathraException.ErrorCode.INTERNAL_SERVER_ERROR);
        }
    }
}

