/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.implementation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.apiversion.ApiVersionService;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.implementationversion.ImplementationVersionService;
import org.kathra.appmanager.pipeline.PipelineService;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Asset;
import org.kathra.core.model.Component;
import org.kathra.core.model.Implementation;
import org.kathra.core.model.ImplementationVersion;
import org.kathra.core.model.Pipeline;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.resourcemanager.client.ImplementationsClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationService
extends AbstractResourceService<Implementation> {
    private Logger logger = LoggerFactory.getLogger(ImplementationService.class);
    public static final String METADATA_PATH = "path";
    public static final String METADATA_DEPLOY_KEY = "deployKey";
    public static final String METADATA_GROUP_ID = "groupId";
    public static final String METADATA_GROUP_PATH = "groupPath";
    public static final String METADATA_ARTIFACT_GROUP_ID = "artifact-groupId";
    public static final String METADATA_ARTIFACT_NAME = "artifact-artifactName";
    private static final Pattern PATTERN_NAME = Pattern.compile("^[0-9A-Za-z_\\-]+$");
    private ApiVersionService apiVersionService;
    private ComponentService componentService;
    private SourceRepositoryService sourceRepositoryService;
    private PipelineService pipelineService;
    private ImplementationsClient resourceManager;
    private ImplementationVersionService implementationVersionService;

    public ImplementationService() {
    }

    @Override
    public void configure(ServiceInjection serviceInjection) {
        super.configure(serviceInjection);
        this.resourceManager = new ImplementationsClient(serviceInjection.getConfig().getResourceManagerUrl(), serviceInjection.getSessionManager());
        this.componentService = serviceInjection.getService(ComponentService.class);
        this.apiVersionService = serviceInjection.getService(ApiVersionService.class);
        this.sourceRepositoryService = serviceInjection.getService(SourceRepositoryService.class);
        this.implementationVersionService = serviceInjection.getService(ImplementationVersionService.class);
        this.pipelineService = serviceInjection.getService(PipelineService.class);
    }

    public ImplementationService(ComponentService componentService, ApiVersionService apiVersionService, SourceRepositoryService sourceRepositoryService, ImplementationVersionService implementationVersionService, ImplementationsClient resourceManager, PipelineService pipelineService, KathraSessionManager kathraSessionManager) {
        this.componentService = componentService;
        this.apiVersionService = apiVersionService;
        this.sourceRepositoryService = sourceRepositoryService;
        this.implementationVersionService = implementationVersionService;
        this.resourceManager = resourceManager;
        this.pipelineService = pipelineService;
        this.kathraSessionManager = kathraSessionManager;
    }

    public Implementation create(@NotNull String name, Asset.LanguageEnum language, ApiVersion apiVersion, String description) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Implementation's name is null or empty.");
        }
        if (!PATTERN_NAME.matcher(name).find()) {
            throw new IllegalArgumentException("Implementation's name do not respect regex's pattern " + PATTERN_NAME.pattern());
        }
        if (language == null) {
            throw new IllegalArgumentException("Language is null.");
        }
        if (apiVersion == null) {
            throw new IllegalArgumentException("ApiVersion is null.");
        }
        if (this.getAll().parallelStream().anyMatch(impl -> impl.getName().equals(name))) {
            throw new IllegalArgumentException("Implementation's name already exists.");
        }
        ApiVersion apiVersionWithDetails = this.apiVersionService.getById(apiVersion.getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find ApiVersion with id : '" + apiVersion.getId() + "'"));
        if (!this.isReady((Resource)apiVersionWithDetails)) {
            throw new IllegalStateException("ApiVersion '" + apiVersionWithDetails.getId() + "' is not READY");
        }
        Component componentWithDetails = this.componentService.getById(apiVersionWithDetails.getComponent().getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find Component with id : '" + apiVersionWithDetails.getComponent().getId() + "'"));
        if (componentWithDetails.getName().equals(name)) {
            throw new IllegalArgumentException("Implementation's name should be different component's name.");
        }
        if (componentWithDetails.getMetadata() == null || !(componentWithDetails.getMetadata().get(METADATA_GROUP_ID) instanceof String)) {
            throw new IllegalArgumentException("Component's metadata should contains entry with key 'groupId'.");
        }
        if (componentWithDetails.getMetadata() == null || !(componentWithDetails.getMetadata().get(METADATA_GROUP_PATH) instanceof String)) {
            throw new IllegalArgumentException("Component's metadata should contains entry with key 'groupPath'.");
        }
        if (componentWithDetails.getMetadata() == null || !(componentWithDetails.getMetadata().get(METADATA_ARTIFACT_GROUP_ID) instanceof String)) {
            throw new IllegalArgumentException("Component's metadata should contains entry with key 'artifact-groupId'.");
        }
        String path = componentWithDetails.getMetadata().get(METADATA_GROUP_PATH) + "/components/" + componentWithDetails.getName() + "/implementations/" + language.getValue() + "/" + name;
        String artifactName = this.getArtifactName(name);
        String artifactGroupId = (String)componentWithDetails.getMetadata().get(METADATA_ARTIFACT_GROUP_ID);
        Implementation impl2 = this.resourceManager.addImplementation(new Implementation().name(name).component(componentWithDetails).language(language).status(Resource.StatusEnum.PENDING).description(description == null ? "" : description).putMetadataItem(METADATA_PATH, (Object)path).putMetadataItem(METADATA_DEPLOY_KEY, componentWithDetails.getMetadata().get(METADATA_GROUP_ID)).putMetadataItem(METADATA_GROUP_ID, componentWithDetails.getMetadata().get(METADATA_GROUP_ID)).putMetadataItem(METADATA_GROUP_PATH, componentWithDetails.getMetadata().get(METADATA_GROUP_PATH)).putMetadataItem(METADATA_ARTIFACT_NAME, (Object)artifactName).putMetadataItem(METADATA_ARTIFACT_GROUP_ID, (Object)artifactGroupId));
        Session session = this.kathraSessionManager.getCurrentSession();
        CompletableFuture.runAsync(() -> {
            this.kathraSessionManager.handleSession(session);
            this.createSourceRepository(impl2, apiVersionWithDetails);
        });
        return impl2;
    }

    private String getArtifactName(String implementationName) {
        return implementationName.toLowerCase().replaceAll("[^a-z]*", "");
    }

    public void createSourceRepository(Implementation implementation, ApiVersion apiVersion) {
        try {
            Session session = this.kathraSessionManager.getCurrentSession();
            Runnable callback = () -> {
                this.kathraSessionManager.handleSession(session);
                try {
                    Implementation implementationWithDetails = this.resourceManager.getImplementation(implementation.getId());
                    if (this.isError((Resource)implementationWithDetails)) {
                        return;
                    }
                    SourceRepository sourceRepository = this.sourceRepositoryService.getById(implementationWithDetails.getSourceRepository().getId()).orElseThrow(() -> new IllegalStateException("Unable to find SourceRepository " + implementationWithDetails.getSourceRepository().getId()));
                    switch (sourceRepository.getStatus()) {
                        case READY: {
                            this.createPipeline(implementationWithDetails, apiVersion);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("SourceRepository '" + sourceRepository.getId() + "' is not READY");
                        }
                    }
                }
                catch (ApiException e) {
                    this.manageError(implementation, (Exception)((Object)e));
                }
            };
            String[] deployKeys = new String[]{(String)implementation.getMetadata().get(METADATA_DEPLOY_KEY)};
            SourceRepository src = this.sourceRepositoryService.create("impl-" + implementation.getName(), (String)implementation.getMetadata().get(METADATA_PATH), deployKeys, callback);
            this.patch(new Implementation().id(implementation.getId()).sourceRepository(src));
        }
        catch (Exception e) {
            this.manageError(implementation, e);
        }
    }

    private void createPipeline(Implementation implementation, ApiVersion apiVersion) {
        Pipeline.TemplateEnum template = this.getTemplateFromImplementation(implementation);
        String pathPipeline = (String)implementation.getMetadata().get(METADATA_PATH);
        String credentialId = (String)implementation.getMetadata().get(METADATA_DEPLOY_KEY);
        try {
            SourceRepository sourceRepository = this.sourceRepositoryService.getById(implementation.getSourceRepository().getId()).orElseThrow(() -> new IllegalStateException("Unable to find SourceRepository '" + implementation.getSourceRepository().getId() + "'"));
            Session session = this.kathraSessionManager.getCurrentSession();
            Runnable callback = () -> {
                try {
                    this.kathraSessionManager.handleSession(session);
                    Implementation implementationWithDetails = this.resourceManager.getImplementation(implementation.getId());
                    if (this.isError((Resource)implementationWithDetails)) {
                        return;
                    }
                    Pipeline pipeline = this.pipelineService.getById(implementationWithDetails.getPipeline().getId()).orElseThrow(() -> new IllegalStateException("Unable to find Pipeline " + implementationWithDetails.getPipeline().getId()));
                    switch (pipeline.getStatus()) {
                        case READY: {
                            this.createFirstImplementationVersion(implementationWithDetails, apiVersion);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Pipeline '" + pipeline.getId() + "' is not READY");
                        }
                    }
                }
                catch (Exception e) {
                    this.manageError(implementation, e);
                }
            };
            Pipeline pipeline = this.pipelineService.create(implementation.getName(), pathPipeline, sourceRepository, template, credentialId, callback);
            this.patch(new Implementation().id(implementation.getId()).pipeline(pipeline));
        }
        catch (Exception e) {
            this.manageError(implementation, e);
        }
    }

    private Pipeline.TemplateEnum getTemplateFromImplementation(Implementation implementation) {
        switch (implementation.getLanguage()) {
            case JAVA: {
                return Pipeline.TemplateEnum.JAVA_SERVICE;
            }
            case PYTHON: {
                return Pipeline.TemplateEnum.PYTHON_SERVICE;
            }
        }
        throw new NotImplementedException("Implementation's language " + implementation.getLanguage() + " not implemented");
    }

    private void createFirstImplementationVersion(Implementation implementationWithDetails, ApiVersion apiVersion) {
        Session session = this.kathraSessionManager.getCurrentSession();
        Runnable callbackAfterImplementationVersionReadyOrError = () -> {
            try {
                this.kathraSessionManager.handleSession(session);
                String implVersionId = ((ImplementationVersion)this.resourceManager.getImplementation(implementationWithDetails.getId()).getVersions().get(0)).getId();
                ImplementationVersion firstVersion = this.implementationVersionService.getById(implVersionId).orElseThrow(() -> new IllegalStateException("Unable to find ImplementationVersion with id :" + implVersionId));
                switch (firstVersion.getStatus()) {
                    case READY: {
                        this.updateStatus(implementationWithDetails, Resource.StatusEnum.READY);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("ImplementationVersion '" + firstVersion.getId() + "' is not READY");
                    }
                }
            }
            catch (Exception e) {
                this.manageError(implementationWithDetails, e);
            }
        };
        try {
            implementationWithDetails.addVersionsItem(this.implementationVersionService.create(implementationWithDetails, apiVersion, "1.0.0", callbackAfterImplementationVersionReadyOrError));
        }
        catch (Exception e) {
            this.manageError(implementationWithDetails, e);
        }
    }

    public List<Implementation> getComponentImplementations(String componentId) throws ApiException {
        List implementations = this.resourceManager.getImplementations();
        if (implementations == null || implementations.isEmpty()) {
            return new ArrayList<Implementation>();
        }
        return implementations.stream().filter(implementation -> implementation.getComponent().getId().equals(componentId)).collect(Collectors.toList());
    }

    @Override
    public Optional<Implementation> getById(String implemId) throws ApiException {
        Implementation implem = this.resourceManager.getImplementation(implemId);
        return implem == null ? Optional.empty() : Optional.of(implem);
    }

    @Override
    public void patch(Implementation implem) throws ApiException {
        this.resourceManager.updateImplementationAttributes(implem.getId(), implem);
    }

    @Override
    public List<Implementation> getAll() throws ApiException {
        List implementations = this.resourceManager.getImplementations();
        if (implementations == null || implementations.isEmpty()) {
            return new ArrayList<Implementation>();
        }
        return implementations;
    }

    public List<Implementation> fillImplementationWithVersions(List<Implementation> implementations, List<ImplementationVersion> implementationVersions) throws ApiException {
        if (implementations == null || implementations.isEmpty()) {
            return new ArrayList<Implementation>();
        }
        for (Implementation implementation2 : implementations) {
            implementation2.setVersions(new LinkedList());
        }
        Map<String, Implementation> implementationMap = implementations.stream().collect(Collectors.toMap(Resource::getId, implementation -> implementation));
        for (ImplementationVersion implementationVersion : implementationVersions) {
            Implementation implementation3 = implementationMap.get(implementationVersion.getImplementation().getId());
            if (implementation3 == null) continue;
            implementation3.addVersionsItem(implementationVersion);
        }
        return implementations;
    }

    public void delete(Implementation implementation, boolean purge) throws ApiException {
        try {
            Implementation implementationToDelete = this.resourceManager.getImplementation(implementation.getId());
            if (this.isDeleted((Resource)implementationToDelete)) {
                return;
            }
            AtomicReference exceptionFound = new AtomicReference();
            Session session = this.kathraSessionManager.getCurrentSession();
            implementationToDelete.getVersions().parallelStream().forEach(version -> {
                this.kathraSessionManager.handleSession(session);
                try {
                    this.implementationVersionService.delete((ImplementationVersion)version, purge);
                }
                catch (ApiException e) {
                    exceptionFound.set(e);
                }
            });
            if (exceptionFound.get() != null) {
                throw (ApiException)((Object)exceptionFound.get());
            }
            if (implementation.getPipeline() != null) {
                this.pipelineService.delete(implementation.getPipeline(), purge);
            }
            if (implementation.getSourceRepository() != null) {
                this.sourceRepositoryService.delete(implementation.getSourceRepository(), purge);
            }
            this.resourceManager.deleteImplementation(implementation.getId());
            implementation.status(Resource.StatusEnum.DELETED);
        }
        catch (ApiException e) {
            this.manageError(implementation, (Exception)((Object)e));
            throw e;
        }
    }
}

