/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.implementation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.apache.camel.cdi.ContextName;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.Config;
import org.kathra.appmanager.apiversion.ApiVersionService;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.implementation.ImplementationService;
import org.kathra.appmanager.implementationversion.ImplementationVersionService;
import org.kathra.appmanager.model.ImplementationParameters;
import org.kathra.appmanager.pipeline.PipelineService;
import org.kathra.appmanager.service.ImplementationsService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Asset;
import org.kathra.core.model.Implementation;
import org.kathra.core.model.ImplementationVersion;
import org.kathra.core.model.Resource;
import org.kathra.utils.KathraException;

@Named(value="ImplementationsController")
@ContextName(value="AppManager")
public class ImplementationsController
implements ImplementationsService {
    private ServiceInjection serviceInjection;
    private final ImplementationService implementationService;
    private final ImplementationVersionService implementationVersionService;
    private final ComponentService componentService;
    private final SourceRepositoryService sourceRepositoryService;
    private final PipelineService pipelineService;
    private final ApiVersionService apiVersionService;

    public ImplementationsController() {
        this.serviceInjection = new ServiceInjection(new Config(), this.getSessionManager());
        this.apiVersionService = this.serviceInjection.getService(ApiVersionService.class);
        this.implementationService = this.serviceInjection.getService(ImplementationService.class);
        this.implementationVersionService = this.serviceInjection.getService(ImplementationVersionService.class);
        this.componentService = this.serviceInjection.getService(ComponentService.class);
        this.sourceRepositoryService = this.serviceInjection.getService(SourceRepositoryService.class);
        this.pipelineService = this.serviceInjection.getService(PipelineService.class);
    }

    public ImplementationsController(ImplementationService implementationService, ImplementationVersionService implementationVersionService, ApiVersionService apiVersionService, ComponentService componentService, SourceRepositoryService sourceRepositoryService, PipelineService pipelineService) {
        this.implementationService = implementationService;
        this.implementationVersionService = implementationVersionService;
        this.apiVersionService = apiVersionService;
        this.componentService = componentService;
        this.sourceRepositoryService = sourceRepositoryService;
        this.pipelineService = pipelineService;
    }

    public Implementation createImplementation(ImplementationParameters implementationParameters) throws Exception {
        Asset.LanguageEnum lang = Asset.LanguageEnum.fromValue((String)implementationParameters.getLanguage());
        if (lang == null) {
            throw new IllegalArgumentException("Language " + implementationParameters.getLanguage() + " not found");
        }
        String regex = "[0-9a-z]+";
        Pattern patternImpl = Pattern.compile(regex);
        if (StringUtils.isEmpty((CharSequence)implementationParameters.getName()) || !patternImpl.matcher(implementationParameters.getName()).find()) {
            throw new IllegalArgumentException("Implementation's name should respect regex pattern " + regex);
        }
        if (implementationParameters.getApiVersion() == null) {
            throw new IllegalArgumentException("ApiVersion is null");
        }
        return this.implementationService.create(implementationParameters.getName(), lang, implementationParameters.getApiVersion(), implementationParameters.getDesc());
    }

    public Implementation deleteImplementationById(String implementationId) throws Exception {
        Implementation implementation = this.implementationService.getById(implementationId).orElseThrow(() -> new KathraException("Unable to find Implementation '" + implementationId + "'", null, KathraException.ErrorCode.NOT_FOUND));
        this.implementationService.delete(implementation, true);
        return implementation.status(Resource.StatusEnum.DELETED);
    }

    public List<Implementation> getComponentImplementations(String componentId) throws Exception {
        List<Implementation> implementations = this.implementationService.getComponentImplementations(componentId);
        List<ImplementationVersion> implementationVersions = this.implementationVersionService.getImplementationVersions(implementations);
        List<ApiVersion> apiVersions = this.apiVersionService.getApiVersionsForImplementationVersion(implementationVersions);
        implementationVersions = this.implementationVersionService.fillImplementationVersionWithApiVersion(implementationVersions, apiVersions);
        return this.implementationService.fillImplementationWithVersions(implementations, implementationVersions);
    }

    public Implementation getImplementationById(String implementationId) throws Exception {
        Implementation implementation = this.implementationService.getById(implementationId).orElseThrow(() -> new KathraException("Unable to find Implementation '" + implementationId + "'", null, KathraException.ErrorCode.NOT_FOUND));
        List<ImplementationVersion> implementationVersions = this.implementationVersionService.getImplementationVersions((List<Implementation>)ImmutableList.of((Object)implementation));
        implementation.setComponent(this.componentService.getById(implementation.getComponent().getId()).get());
        if (implementation.getSourceRepository() != null && StringUtils.isNotEmpty((CharSequence)implementation.getSourceRepository().getId())) {
            implementation.setSourceRepository(this.sourceRepositoryService.getById(implementation.getSourceRepository().getId()).get());
        }
        if (implementation.getPipeline() != null && StringUtils.isNotEmpty((CharSequence)implementation.getPipeline().getId())) {
            implementation.setPipeline(this.pipelineService.getById(implementation.getPipeline().getId()).get());
        }
        return this.implementationService.fillImplementationWithVersions((List<Implementation>)ImmutableList.of((Object)implementation), implementationVersions).get(0);
    }

    public List<Implementation> getImplementations() throws Exception {
        List<Implementation> implementations = this.implementationService.getAll();
        List<ImplementationVersion> implementationVersions = this.implementationVersionService.getImplementationVersions(implementations);
        return this.implementationService.fillImplementationWithVersions(implementations, implementationVersions);
    }
}

