/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.implementationversion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.Config;
import org.kathra.appmanager.apiversion.ApiVersionService;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.implementation.ImplementationService;
import org.kathra.appmanager.pipeline.PipelineService;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.codegen.client.CodegenClient;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Build;
import org.kathra.core.model.Component;
import org.kathra.core.model.Implementation;
import org.kathra.core.model.ImplementationVersion;
import org.kathra.core.model.Pipeline;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.core.model.SourceRepositoryCommit;
import org.kathra.resourcemanager.client.ImplementationVersionsClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplementationVersionService
extends AbstractResourceService<ImplementationVersion> {
    public static final String METADATA_LAST_BUILD_NUMBER = "last-build-number";
    public static final String DEFAULT_BRANCH = "dev";
    public static final Pattern patternVersion = Pattern.compile("^[0-9]\\.[0-9]\\.[0-9]$");
    private ImplementationVersionsClient implementationVersionsClient;
    private ComponentService componentService;
    private ApiVersionService apiVersionService;
    private ImplementationService implementationService;
    private PipelineService pipelineService;
    private SourceRepositoryService sourceRepositoryService;
    private CodegenClient codegenClient;
    private Logger logger = LoggerFactory.getLogger(ImplementationVersionService.class);
    private String imageRegistryHost;

    public ImplementationVersionService() {
        this.imageRegistryHost = null;
    }

    public ImplementationVersionService(Config config, ImplementationVersionsClient implementationVersionsClient, ApiVersionService apiVersionService, ComponentService componentService, ImplementationService implementationService, SourceRepositoryService sourceRepositoryService, CodegenClient codegenClient, KathraSessionManager kathraSessionManager, PipelineService pipelineService) {
        this.implementationVersionsClient = implementationVersionsClient;
        this.sourceRepositoryService = sourceRepositoryService;
        this.codegenClient = codegenClient;
        this.implementationService = implementationService;
        this.apiVersionService = apiVersionService;
        this.componentService = componentService;
        this.kathraSessionManager = kathraSessionManager;
        this.pipelineService = pipelineService;
        this.imageRegistryHost = config.getImageRegistryHost();
    }

    @Override
    public void configure(ServiceInjection serviceInjection) {
        super.configure(serviceInjection);
        this.implementationVersionsClient = new ImplementationVersionsClient(serviceInjection.getConfig().getResourceManagerUrl(), serviceInjection.getSessionManager());
        this.sourceRepositoryService = serviceInjection.getService(SourceRepositoryService.class);
        this.implementationService = serviceInjection.getService(ImplementationService.class);
        this.pipelineService = serviceInjection.getService(PipelineService.class);
        this.codegenClient = new CodegenClient(serviceInjection.getConfig().getCodegenUrl(), serviceInjection.getSessionManager());
        this.componentService = serviceInjection.getService(ComponentService.class);
        this.apiVersionService = serviceInjection.getService(ApiVersionService.class);
        this.imageRegistryHost = serviceInjection.getConfig().getImageRegistryHost();
    }

    @Override
    protected void patch(ImplementationVersion object) throws ApiException {
        this.implementationVersionsClient.updateImplementationVersionAttributes(object.getId(), object);
    }

    public List<ImplementationVersion> getImplementationVersions(List<Implementation> implementations) throws ApiException {
        if (implementations == null || implementations.isEmpty()) {
            return new ArrayList<ImplementationVersion>();
        }
        return this.implementationVersionsClient.getImplementationVersions().stream().filter(implementationVersion -> implementations.stream().anyMatch(implementation -> implementationVersion.getImplementation().getId().equals(implementation.getId()))).collect(Collectors.toList());
    }

    @Override
    public Optional<ImplementationVersion> getById(String id) throws ApiException {
        ImplementationVersion result = this.implementationVersionsClient.getImplementationVersion(id);
        return result == null ? Optional.empty() : Optional.of(result);
    }

    @Override
    public List<ImplementationVersion> getAll() throws ApiException {
        return this.implementationVersionsClient.getImplementationVersions();
    }

    public List<ImplementationVersion> fillImplementationVersionWithApiVersion(List<ImplementationVersion> implementationVersions, List<ApiVersion> apiVersions) throws ApiException {
        if (implementationVersions == null || implementationVersions.isEmpty()) {
            return implementationVersions;
        }
        Map<String, ApiVersion> apiVersionMap = apiVersions.stream().collect(Collectors.toMap(Resource::getId, apiVersion -> apiVersion));
        for (ImplementationVersion implementationVersion : implementationVersions) {
            ApiVersion apiVersion2 = apiVersionMap.get(implementationVersion.getApiVersion().getId());
            implementationVersion.setApiVersion(apiVersion2);
        }
        return implementationVersions;
    }

    public ImplementationVersion create(Implementation implementation, ApiVersion apiVersion, String versionImpl, Runnable callback) throws ApiException {
        if (this.isError((Resource)implementation)) {
            throw new IllegalStateException("Implementation " + implementation.getId() + " has an error");
        }
        if (!implementation.getMetadata().containsKey("artifact-artifactName") || StringUtils.isEmpty((CharSequence)((CharSequence)implementation.getMetadata().get("artifact-artifactName")))) {
            throw new IllegalArgumentException("Implementation's metadata artifact-artifactName is null or empty");
        }
        if (!implementation.getMetadata().containsKey("artifact-groupId") || StringUtils.isEmpty((CharSequence)((CharSequence)implementation.getMetadata().get("artifact-groupId")))) {
            throw new IllegalArgumentException("Implementation's metadata artifact-groupId is null or empty");
        }
        if (!patternVersion.matcher(versionImpl).find()) {
            throw new IllegalArgumentException("Implementation's version doesn't respect nomenclature X.X.X (ex: 1.0.1)");
        }
        List<ImplementationVersion> implementationExisting = this.getImplementationVersions((List<Implementation>)ImmutableList.of((Object)implementation));
        if (implementationExisting.parallelStream().anyMatch(implV -> implV.getVersion().equals(versionImpl))) {
            throw new IllegalStateException("Implementation's version already exists");
        }
        ApiVersion apiVersionWithDetails = this.apiVersionService.getById(apiVersion.getId()).orElseThrow(() -> new IllegalArgumentException("ApiVersion " + apiVersion.getId() + " not found"));
        if (this.isError((Resource)apiVersionWithDetails)) {
            throw new IllegalStateException("ApiVersion " + apiVersion.getId() + " has an error");
        }
        Component component = this.componentService.getById(apiVersionWithDetails.getComponent().getId()).orElseThrow(() -> new IllegalArgumentException("Component " + apiVersionWithDetails.getComponent().getId() + " not found"));
        SourceRepository apiRepository = this.sourceRepositoryService.getById(component.getApiRepository().getId()).orElseThrow(() -> new IllegalArgumentException("SourceRepository " + component.getApiRepository().getId() + " not found"));
        File apiFile = this.sourceRepositoryService.getFile(apiRepository, apiVersion.getVersion(), "swagger.yaml");
        if (apiFile == null) {
            throw new IllegalStateException("ApiFile is null or empty");
        }
        ImplementationVersion implVersion = this.implementationVersionsClient.addImplementationVersion(new ImplementationVersion().name(implementation.getName() + ":" + versionImpl).apiVersion(apiVersion).implementation(implementation).version(versionImpl).status(Resource.StatusEnum.PENDING));
        Session session = this.kathraSessionManager.getCurrentSession();
        CompletableFuture.runAsync(() -> {
            try {
                this.kathraSessionManager.handleSession(session);
                this.generateAndUpdateSrc(implVersion.implementation(implementation), apiFile);
                Pipeline implementationPipeline = this.getPipeline(implVersion);
                this.build(implVersion, implementationPipeline, () -> this.validateBuilding(implVersion, implementationPipeline, callback));
            }
            catch (Exception e) {
                this.manageError(implVersion, e);
                if (callback != null) {
                    callback.run();
                }
            }
        });
        return implVersion;
    }

    private void generateAndUpdateSrc(ImplementationVersion implVersion, File apiFile) throws ApiException {
        block4: {
            String artifactName = (String)implVersion.getImplementation().getMetadata().get("artifact-artifactName");
            String artifactGroup = (String)implVersion.getImplementation().getMetadata().get("artifact-groupId");
            SourceRepository sourceRepository = this.sourceRepositoryService.getById(implVersion.getImplementation().getSourceRepository().getId()).orElseThrow(() -> new IllegalStateException("Unable to find SourceRepository " + implVersion.getImplementation().getSourceRepository().getId()));
            File implementationFiles = this.codegenClient.generateImplementation(apiFile, implVersion.getImplementation().getName(), implVersion.getImplementation().getLanguage().toString(), artifactName, artifactGroup, implVersion.getVersion());
            if (implementationFiles == null) {
                throw new IllegalStateException("Implementation's file generated is null or empty");
            }
            try {
                SourceRepositoryCommit commit = this.sourceRepositoryService.commitArchiveAndTag(sourceRepository, DEFAULT_BRANCH, implementationFiles, ".", implVersion.getVersion());
                if (commit == null) {
                    throw new IllegalStateException("Commit is null");
                }
            }
            catch (ApiException e) {
                if (e.getCode() == KathraException.ErrorCode.PRECONDITION_FAILED.getCode()) break block4;
                throw e;
            }
        }
    }

    private boolean validateBuilding(ImplementationVersion implementationVersion, Pipeline pipeline, Runnable callback) {
        try {
            ImplementationVersion implementationVersionDetailed = this.implementationVersionsClient.getImplementationVersion(implementationVersion.getId());
            if (implementationVersionDetailed.getMetadata() == null || !implementationVersionDetailed.getMetadata().containsKey(METADATA_LAST_BUILD_NUMBER)) {
                throw new IllegalStateException("Unable to get metadata 'last-build-number' for ImplementationVersion " + implementationVersion.getId());
            }
            Build build = this.pipelineService.getBuild(pipeline, (String)implementationVersionDetailed.getMetadata().get(METADATA_LAST_BUILD_NUMBER));
            switch (build.getStatus()) {
                case SCHEDULED: 
                case PROCESSING: {
                    throw new IllegalStateException("Implementation " + implementationVersionDetailed.getId() + " building should be finished");
                }
                case SUCCESS: {
                    this.logger.info("LibraryApiVersion " + implementationVersionDetailed.getId() + " has been build");
                    this.updateStatus(implementationVersionDetailed, Resource.StatusEnum.READY);
                    if (callback != null) {
                        callback.run();
                    }
                    return true;
                }
                case FAILED: {
                    throw new Exception("An error occurred during building ImplementationVersion " + implementationVersionDetailed.getId());
                }
            }
            throw new IllegalStateException("ImplementationVersion " + implementationVersionDetailed.getId() + " building have not implemented status " + build.getStatus());
        }
        catch (Exception e) {
            this.manageError(implementationVersion, e);
            if (callback != null) {
                callback.run();
            }
            return false;
        }
    }

    private Pipeline getPipeline(ImplementationVersion implementationVersion) throws ApiException {
        Implementation implementation = this.implementationService.getById(implementationVersion.getImplementation().getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find Implementation with id : " + implementationVersion.getImplementation().getId()));
        return this.pipelineService.getById(implementation.getPipeline().getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find Pipeline with id : " + implementation.getPipeline().getId()));
    }

    private Build build(ImplementationVersion implementationVersion, Pipeline pipeline, Runnable callback) throws ApiException {
        Build build = this.pipelineService.build(pipeline, DEFAULT_BRANCH, (Map<String, String>)ImmutableMap.of((Object)"DOCKER_URL", (Object)this.imageRegistryHost), callback);
        implementationVersion.putMetadataItem(METADATA_LAST_BUILD_NUMBER, (Object)build.getBuildNumber());
        this.implementationVersionsClient.updateImplementationVersionAttributes(implementationVersion.getId(), new ImplementationVersion().metadata(implementationVersion.getMetadata()));
        return build;
    }

    public void delete(ImplementationVersion version, boolean purge) throws ApiException {
        try {
            ImplementationVersion versionToDelete = this.implementationVersionsClient.getImplementationVersion(version.getId());
            if (this.isDeleted((Resource)versionToDelete)) {
                return;
            }
            this.implementationVersionsClient.deleteImplementationVersion(versionToDelete.getId());
            version.status(Resource.StatusEnum.DELETED);
        }
        catch (ApiException e) {
            this.manageError(version, (Exception)((Object)e));
            throw e;
        }
    }
}

