/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.library;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.pipeline.PipelineService;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.core.model.Asset;
import org.kathra.core.model.Component;
import org.kathra.core.model.Library;
import org.kathra.core.model.Pipeline;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.resourcemanager.client.LibrariesClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;

public class LibraryService
extends AbstractResourceService<Library> {
    private SourceRepositoryService sourceRepositoryService;
    private PipelineService pipelineService;
    private LibrariesClient resourceManager;
    private ComponentService componentService;

    public LibraryService() {
    }

    @Override
    public void configure(ServiceInjection serviceInjection) {
        super.configure(serviceInjection);
        this.sourceRepositoryService = serviceInjection.getService(SourceRepositoryService.class);
        this.pipelineService = serviceInjection.getService(PipelineService.class);
        this.componentService = serviceInjection.getService(ComponentService.class);
        this.resourceManager = new LibrariesClient(serviceInjection.getConfig().getResourceManagerUrl(), serviceInjection.getSessionManager());
    }

    public LibraryService(LibrariesClient resourceManager, ComponentService componentService, PipelineService pipelineService, SourceRepositoryService sourceRepositoryService, KathraSessionManager kathraSessionManager) {
        this.sourceRepositoryService = sourceRepositoryService;
        this.componentService = componentService;
        this.pipelineService = pipelineService;
        this.resourceManager = resourceManager;
        this.kathraSessionManager = kathraSessionManager;
    }

    public Optional<Library> getLibraryByComponentAndLanguageAndType(Component component, Asset.LanguageEnum languageProgramming, Library.TypeEnum typeLib) throws ApiException {
        Component componentWithDetails = this.componentService.getById(component.getId()).get();
        Session session = this.kathraSessionManager.getCurrentSession();
        AtomicReference exception = new AtomicReference();
        if (componentWithDetails.getLibraries() == null) {
            return Optional.empty();
        }
        Optional<Library> exist = componentWithDetails.getLibraries().parallelStream().filter(lib -> {
            try {
                this.kathraSessionManager.handleSession(session);
                Library libWithDetails = this.resourceManager.getLibrary(lib.getId());
                return libWithDetails.getLanguage().equals((Object)languageProgramming) && libWithDetails.getType().equals((Object)typeLib);
            }
            catch (ApiException e) {
                e.printStackTrace();
                exception.set(e);
                return false;
            }
        }).findFirst();
        if (exception.get() != null) {
            throw (ApiException)((Object)exception.get());
        }
        return exist;
    }

    public Library add(Component component, Asset.LanguageEnum languageProgramming, Library.TypeEnum typeLib, Runnable callback) throws ApiException {
        if (component == null) {
            throw new IllegalArgumentException("Component is null");
        }
        if (languageProgramming == null) {
            throw new IllegalArgumentException("Programming language is null");
        }
        if (typeLib == null) {
            throw new IllegalArgumentException("Library's type is null");
        }
        if (this.getLibraryByComponentAndLanguageAndType(component, languageProgramming, typeLib).isPresent()) {
            throw new IllegalArgumentException("This library component already exists");
        }
        Library toAdd = new Library().name(component.getName() + "-" + languageProgramming.toString() + "-" + typeLib.toString()).component(component).language(languageProgramming).type(typeLib);
        try {
            Library library = this.resourceManager.addLibrary(toAdd);
            Session session = this.kathraSessionManager.getCurrentSession();
            CompletableFuture.runAsync(() -> {
                block2: {
                    try {
                        this.kathraSessionManager.handleSession(session);
                        SourceRepository sourceRepository = this.sourceRepositoryService.createLibraryRepository(library, () -> this.validationSourceRepositoryReady(library, callback));
                        this.patch(new Library().id(library.getId()).sourceRepository(sourceRepository));
                    }
                    catch (Exception e) {
                        this.manageError(library, e);
                        if (callback == null) break block2;
                        callback.run();
                    }
                }
            });
            return library;
        }
        catch (Exception e) {
            this.manageError(toAdd, e);
            throw e;
        }
    }

    private synchronized boolean validationSourceRepositoryReady(Library library, Runnable callbackIfReady) {
        try {
            Library libraryUpdated = this.resourceManager.getLibrary(library.getId());
            if (libraryUpdated == null) {
                this.logger.error("Library '" + library.getId() + "' doesn't exist.");
                return false;
            }
            if (this.isReady((Resource)libraryUpdated)) {
                return true;
            }
            boolean sourceRepositoryIsReady = this.sourceRepositoryIsReady(libraryUpdated);
            this.logger.info("Library '" + libraryUpdated.getId() + "': SourceRepository '" + libraryUpdated.getSourceRepository().getId() + "' is ready = " + sourceRepositoryIsReady);
            if (sourceRepositoryIsReady && (library.getPipeline() == null || library.getPipeline().getId() == null)) {
                this.logger.info("SourceRepository " + libraryUpdated.getSourceRepository().getId() + " is ready, create pipeline for library " + libraryUpdated.getId());
                Pipeline pipeline = this.pipelineService.createLibraryPipeline(libraryUpdated, () -> this.validationPipelineReady(libraryUpdated, callbackIfReady));
                library.setPipeline(pipeline);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.manageError(library, e);
            if (callbackIfReady != null) {
                callbackIfReady.run();
            }
            return false;
        }
    }

    private synchronized boolean validationPipelineReady(Library library, Runnable callbackIfReady) {
        try {
            Library libraryUpdated = this.resourceManager.getLibrary(library.getId());
            if (libraryUpdated == null) {
                this.logger.error("Library '" + library.getId() + "' doesn't exist.");
                return false;
            }
            if (this.isReady((Resource)libraryUpdated)) {
                return true;
            }
            boolean pipelineIsReady = this.pipelineIsReady(libraryUpdated);
            this.logger.info("Library '" + libraryUpdated.getId() + "': Pipeline is ready = " + pipelineIsReady);
            if (pipelineIsReady) {
                this.logger.info("Library '" + libraryUpdated.getId() + "' is ready");
                this.updateStatus(libraryUpdated, Resource.StatusEnum.READY);
                if (callbackIfReady != null) {
                    callbackIfReady.run();
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.manageError(library, e);
            if (callbackIfReady != null) {
                callbackIfReady.run();
            }
            return false;
        }
    }

    private boolean sourceRepositoryIsReady(Library library) throws Exception {
        if (library.getSourceRepository() == null) {
            return false;
        }
        Optional<SourceRepository> sourceRepository = this.sourceRepositoryService.getById(library.getSourceRepository().getId());
        if (sourceRepository.isPresent()) {
            this.throwExceptionIfError((Resource)sourceRepository.get());
            if (StringUtils.isEmpty((CharSequence)sourceRepository.get().getSshUrl())) {
                throw new Exception("SourceRepository's sshUrl should be defined");
            }
            return this.isReady((Resource)sourceRepository.get());
        }
        return false;
    }

    private boolean pipelineIsReady(Library library) throws ApiException {
        if (library.getPipeline() == null) {
            return false;
        }
        Optional<Pipeline> pipeline = this.pipelineService.getById(library.getPipeline().getId());
        if (pipeline.isPresent()) {
            this.throwExceptionIfError((Resource)pipeline.get());
            return this.isReady((Resource)pipeline.get());
        }
        return false;
    }

    @Override
    public void patch(Library object) throws ApiException {
        this.resourceManager.updateLibraryAttributes(object.getId(), object);
    }

    @Override
    public Optional<Library> getById(String id) throws ApiException {
        Library lib = this.resourceManager.getLibrary(id);
        return lib == null ? Optional.empty() : Optional.of(lib);
    }

    @Override
    public List<Library> getAll() throws ApiException {
        return this.resourceManager.getLibraries();
    }

    public void delete(Library library, boolean force, boolean purge) throws ApiException {
        try {
            Library libraryToDeleted = this.resourceManager.getLibrary(library.getId());
            if (this.isDeleted((Resource)libraryToDeleted)) {
                return;
            }
            if (libraryToDeleted.getPipeline() != null) {
                this.pipelineService.delete(libraryToDeleted.getPipeline(), purge);
            }
            if (libraryToDeleted.getSourceRepository() != null) {
                this.sourceRepositoryService.delete(libraryToDeleted.getSourceRepository(), purge);
            }
            this.resourceManager.deleteLibrary(library.getId());
            library.status(Resource.StatusEnum.DELETED);
        }
        catch (ApiException e) {
            this.manageError(library, (Exception)((Object)e));
            throw e;
        }
    }
}

