/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.libraryapiversion;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.apiversion.ApiVersionService;
import org.kathra.appmanager.library.LibraryService;
import org.kathra.appmanager.pipeline.PipelineService;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.codegen.client.CodegenClient;
import org.kathra.core.model.ApiVersion;
import org.kathra.core.model.Build;
import org.kathra.core.model.Library;
import org.kathra.core.model.LibraryApiVersion;
import org.kathra.core.model.Pipeline;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.core.model.SourceRepositoryCommit;
import org.kathra.resourcemanager.client.LibraryApiVersionsClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;

public class LibraryApiVersionService
extends AbstractResourceService<LibraryApiVersion> {
    private LibraryApiVersionsClient resourceManager;
    private ApiVersionService apiVersionService;
    private SourceRepositoryService sourceRepositoryService;
    private LibraryService libraryService;
    private PipelineService pipelineService;
    private CodegenClient codegenClient;
    private final String METADATA_LAST_BUILD_NUMBER = "last-build-number";

    public LibraryApiVersionService() {
    }

    @Override
    public void configure(ServiceInjection serviceInjection) {
        super.configure(serviceInjection);
        this.resourceManager = new LibraryApiVersionsClient(serviceInjection.getConfig().getResourceManagerUrl(), serviceInjection.getSessionManager());
        this.sourceRepositoryService = serviceInjection.getService(SourceRepositoryService.class);
        this.pipelineService = serviceInjection.getService(PipelineService.class);
        this.libraryService = serviceInjection.getService(LibraryService.class);
        this.codegenClient = new CodegenClient(serviceInjection.getConfig().getCodegenUrl(), serviceInjection.getSessionManager());
        this.apiVersionService = serviceInjection.getService(ApiVersionService.class);
    }

    public LibraryApiVersionService(LibraryApiVersionsClient resourceManager, CodegenClient codegenClient, LibraryService libraryService, PipelineService pipelineService, SourceRepositoryService sourceRepositoryService, ApiVersionService apiVersionService, KathraSessionManager kathraSessionManager) {
        this.resourceManager = resourceManager;
        this.libraryService = libraryService;
        this.pipelineService = pipelineService;
        this.sourceRepositoryService = sourceRepositoryService;
        this.codegenClient = codegenClient;
        this.apiVersionService = apiVersionService;
        this.kathraSessionManager = kathraSessionManager;
    }

    @Override
    protected void patch(LibraryApiVersion object) throws ApiException {
        this.resourceManager.updateLibraryApiVersionAttributes(object.getId(), object);
    }

    @Override
    public Optional<LibraryApiVersion> getById(String id) throws ApiException {
        LibraryApiVersion libraryApiVersion = this.resourceManager.getLibraryApiVersion(id);
        return libraryApiVersion == null ? Optional.empty() : Optional.of(libraryApiVersion);
    }

    @Override
    public List<LibraryApiVersion> getAll() throws ApiException {
        return this.resourceManager.getLibraryApiVersions();
    }

    public Optional<LibraryApiVersion> findByApiVersionAndLibrary(ApiVersion apiVersion, Library library) throws ApiException {
        Session session = this.kathraSessionManager.getCurrentSession();
        return apiVersion.getLibrariesApiVersions().parallelStream().map(apiLib -> {
            try {
                this.kathraSessionManager.handleSession(session);
                return this.getById(apiLib.getId()).get();
            }
            catch (ApiException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(apiLib -> apiLib.getLibrary().getId().equals(library.getId())).findFirst();
    }

    public LibraryApiVersion create(ApiVersion apiVersion, Library library, File apiFile, Runnable callback) throws ApiException {
        if (apiVersion == null) {
            throw new IllegalArgumentException("ApiVersion is null");
        }
        if (StringUtils.isEmpty((CharSequence)apiVersion.getVersion())) {
            throw new IllegalArgumentException("ApiVersion's version is null or empty");
        }
        if (!apiVersion.getMetadata().containsKey("artifact-groupId") || StringUtils.isEmpty((CharSequence)((CharSequence)apiVersion.getMetadata().get("artifact-groupId")))) {
            throw new IllegalArgumentException("ApiVersion's artifact-groupId is null or empty");
        }
        if (!apiVersion.getMetadata().containsKey("artifact-artifactName") || StringUtils.isEmpty((CharSequence)((CharSequence)apiVersion.getMetadata().get("artifact-artifactName")))) {
            throw new IllegalArgumentException("ApiVersion's artifact-artifactName is null or empty");
        }
        if (library == null) {
            throw new IllegalArgumentException("Library is null");
        }
        if (apiFile == null) {
            throw new IllegalArgumentException("File is null or empty");
        }
        Library libraryWithDetails = this.libraryService.getById(library.getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find Library '" + library.getId() + "'"));
        if (!this.isReady((Resource)libraryWithDetails)) {
            throw new IllegalStateException("Library '" + library.getId() + "' is not READY");
        }
        if (libraryWithDetails.getSourceRepository() == null) {
            throw new IllegalStateException("Library '" + library.getId() + "' doesn't have a sourceRepository");
        }
        if (this.findByApiVersionAndLibrary(apiVersion, library).isPresent()) {
            throw new IllegalArgumentException("LibraryApiVersion linked ApiVersion '" + apiVersion.getId() + "' and Library '" + library.getId() + "' already exists");
        }
        SourceRepository sourceRepositoryWithDetails = this.sourceRepositoryService.getById(libraryWithDetails.getSourceRepository().getId()).orElseThrow(() -> new IllegalStateException("Unable to find SourceRepository '" + libraryWithDetails.getSourceRepository().getId() + "'"));
        if (!this.isReady((Resource)sourceRepositoryWithDetails)) {
            throw new IllegalStateException("SourceRepository '" + sourceRepositoryWithDetails.getId() + "' is not READY");
        }
        LibraryApiVersion libraryApiToAdd = new LibraryApiVersion().name(libraryWithDetails.getName() + "-" + apiVersion.getName()).status(Resource.StatusEnum.PENDING).apiVersion(new ApiVersion().id(apiVersion.getId())).library(new Library().id(library.getId())).pipelineStatus(LibraryApiVersion.PipelineStatusEnum.PENDING).apiRepositoryStatus(LibraryApiVersion.ApiRepositoryStatusEnum.PENDING);
        LibraryApiVersion libraryApiVersion = this.resourceManager.addLibraryApiVersion(libraryApiToAdd);
        if (StringUtils.isEmpty((CharSequence)libraryApiVersion.getId())) {
            throw new IllegalStateException("LibraryApiVersion's id should be defined by resourceManager");
        }
        if (!this.isPending((Resource)libraryApiVersion)) {
            throw new IllegalStateException("LibraryApiVersion should have status PENDING");
        }
        if (libraryApiVersion.getLibrary() == null || libraryApiVersion.getApiVersion() == null) {
            throw new IllegalStateException("LibraryApiVersion should have a ApiVersion and Library defined");
        }
        Session session = this.kathraSessionManager.getCurrentSession();
        CompletableFuture.runAsync(() -> {
            try {
                this.kathraSessionManager.handleSession(session);
                libraryApiVersion.library(libraryWithDetails.sourceRepository(sourceRepositoryWithDetails));
                libraryApiVersion.apiVersion(apiVersion);
                this.generateAndUpdateSrc(libraryApiVersion, apiFile, callback);
            }
            catch (Exception e) {
                this.manageError(libraryApiVersion, e);
                if (callback != null) {
                    callback.run();
                }
            }
        });
        this.logger.info("ApiVersionLibrary created with id " + libraryApiVersion.getId());
        return libraryApiVersion;
    }

    public LibraryApiVersion update(LibraryApiVersion libraryApiVersion, File apiFile, Runnable callback) throws ApiException {
        Library libraryWithDetails;
        if (libraryApiVersion == null) {
            throw new IllegalArgumentException("LibraryApiVersion is null");
        }
        if (StringUtils.isEmpty((CharSequence)libraryApiVersion.getId())) {
            throw new IllegalArgumentException("LibraryApiVersion's id is null or empty");
        }
        LibraryApiVersion libraryApiVersionWithDetails = this.resourceManager.getLibraryApiVersion(libraryApiVersion.getId());
        if (apiFile == null) {
            throw new IllegalArgumentException("File is null or empty");
        }
        if (!this.isReady((Resource)libraryApiVersionWithDetails)) {
            // empty if block
        }
        if (!this.isReady((Resource)(libraryWithDetails = this.libraryService.getById(libraryApiVersionWithDetails.getLibrary().getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find Library '" + libraryApiVersion.getLibrary().getId() + "'"))))) {
            throw new IllegalStateException("Library '" + libraryWithDetails.getId() + "' is not READY");
        }
        if (libraryWithDetails.getSourceRepository() == null) {
            throw new IllegalStateException("Library '" + libraryWithDetails.getId() + "' doesn't have a sourceRepository");
        }
        SourceRepository sourceRepositoryWithDetails = this.sourceRepositoryService.getById(libraryWithDetails.getSourceRepository().getId()).orElseThrow(() -> new IllegalStateException("Unable to find SourceRepository '" + libraryWithDetails.getSourceRepository().getId() + "'"));
        if (!this.isReady((Resource)sourceRepositoryWithDetails)) {
            throw new IllegalStateException("SourceRepository '" + sourceRepositoryWithDetails.getId() + "' is not READY");
        }
        ApiVersion apiVersionWithDetails = this.apiVersionService.getById(libraryApiVersionWithDetails.getApiVersion().getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find ApiVersion '" + libraryApiVersion.getApiVersion().getId() + "'"));
        this.patch(new LibraryApiVersion().id(libraryApiVersionWithDetails.getId()).apiRepositoryStatus(LibraryApiVersion.ApiRepositoryStatusEnum.UPDATING).status(Resource.StatusEnum.UPDATING));
        Session session = this.kathraSessionManager.getCurrentSession();
        CompletableFuture.runAsync(() -> {
            try {
                this.kathraSessionManager.handleSession(session);
                LibraryApiVersion libraryApiVersionDetails = new LibraryApiVersion().id(libraryApiVersionWithDetails.getId()).library(libraryWithDetails.sourceRepository(sourceRepositoryWithDetails)).apiVersion(apiVersionWithDetails);
                this.generateAndUpdateSrc(libraryApiVersionDetails, apiFile, callback);
            }
            catch (Exception e) {
                this.manageError(libraryApiVersionWithDetails, e);
                if (callback != null) {
                    callback.run();
                }
            }
        });
        return libraryApiVersion.status(Resource.StatusEnum.UPDATING).apiRepositoryStatus(LibraryApiVersion.ApiRepositoryStatusEnum.UPDATING);
    }

    private void generateAndUpdateSrc(LibraryApiVersion libraryApiVersion, File apiFile, Runnable callback) throws ApiException {
        try {
            block13: {
                File sourceGenerated;
                String artifactGroup = (String)libraryApiVersion.getApiVersion().getMetadata().get("artifact-groupId");
                String artifactName = (String)libraryApiVersion.getApiVersion().getMetadata().get("artifact-artifactName");
                switch (libraryApiVersion.getLibrary().getType()) {
                    case MODEL: {
                        sourceGenerated = this.codegenClient.generateModel(apiFile, libraryApiVersion.getLibrary().getLanguage().toString(), artifactName, artifactGroup, libraryApiVersion.getApiVersion().getVersion());
                        break;
                    }
                    case CLIENT: {
                        sourceGenerated = this.codegenClient.generateClient(apiFile, libraryApiVersion.getLibrary().getLanguage().toString(), artifactName, artifactGroup, libraryApiVersion.getApiVersion().getVersion());
                        break;
                    }
                    case INTERFACE: {
                        sourceGenerated = this.codegenClient.generateInterface(apiFile, libraryApiVersion.getLibrary().getLanguage().toString(), artifactName, artifactGroup, libraryApiVersion.getApiVersion().getVersion());
                        break;
                    }
                    default: {
                        throw new NotImplementedException("Library type " + libraryApiVersion.getLibrary().getType().toString() + " not implemented");
                    }
                }
                if (sourceGenerated == null) {
                    throw new IllegalArgumentException("CodeGenClient's File is null");
                }
                if (!this.isReady((Resource)libraryApiVersion.getLibrary().getSourceRepository())) {
                    throw new IllegalStateException("SourceRepository '" + libraryApiVersion.getLibrary().getSourceRepository().getId() + "' is not READY");
                }
                try {
                    SourceRepositoryCommit commit = this.sourceRepositoryService.commitArchiveAndTag(libraryApiVersion.getLibrary().getSourceRepository(), "dev", sourceGenerated, ".", libraryApiVersion.getApiVersion().getVersion());
                    if (StringUtils.isEmpty((CharSequence)commit.getId())) {
                        throw new IllegalStateException("SourceManager doesn't return commit with id");
                    }
                }
                catch (ApiException e) {
                    if (e.getCode() == KathraException.ErrorCode.PRECONDITION_FAILED.getCode()) break block13;
                    throw e;
                }
            }
            this.patch(new LibraryApiVersion().id(libraryApiVersion.getId()).apiRepositoryStatus(LibraryApiVersion.ApiRepositoryStatusEnum.READY));
            if (callback != null) {
                callback.run();
            }
        }
        catch (Exception e) {
            this.patch(new LibraryApiVersion().id(libraryApiVersion.getId()).apiRepositoryStatus(LibraryApiVersion.ApiRepositoryStatusEnum.ERROR));
            throw e;
        }
    }

    public Build build(LibraryApiVersion libraryApiVersion, Runnable callback) throws ApiException {
        if (libraryApiVersion == null) {
            throw new IllegalArgumentException("LibraryApiVersion is null");
        }
        LibraryApiVersion libraryApiVersionWithDetails = this.getById(libraryApiVersion.getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find LibraryApiVersion with id " + libraryApiVersion.getId()));
        if (this.isError((Resource)libraryApiVersionWithDetails)) {
            throw new IllegalArgumentException("LibraryApiVersion has status " + libraryApiVersionWithDetails.getStatus());
        }
        if (!LibraryApiVersion.ApiRepositoryStatusEnum.READY.equals((Object)libraryApiVersionWithDetails.getApiRepositoryStatus())) {
            throw new IllegalArgumentException("LibraryApiVersion's repository status is not READY");
        }
        if (libraryApiVersionWithDetails.getApiVersion() == null) {
            throw new IllegalArgumentException("LibraryApiVersion's ApiVersion is null");
        }
        if (libraryApiVersionWithDetails.getLibrary() == null) {
            throw new IllegalArgumentException("LibraryApiVersion's Library is null");
        }
        ApiVersion apiVersionWithDetails = this.apiVersionService.getById(libraryApiVersion.getApiVersion().getId()).orElseThrow(() -> new IllegalArgumentException("Unable to find ApiVersion with id " + libraryApiVersion.getApiVersion().getId()));
        if (StringUtils.isEmpty((CharSequence)apiVersionWithDetails.getVersion())) {
            throw new IllegalArgumentException("LibraryApiVersion's version is null or empty");
        }
        Optional<Library> library = this.libraryService.getById(libraryApiVersionWithDetails.getLibrary().getId());
        Optional<Pipeline> pipeline = this.pipelineService.getById(library.get().getPipeline().getId());
        if (!pipeline.isPresent()) {
            throw new IllegalStateException("Pipeline with id '" + library.get().getPipeline().getId() + "' for apiVersion " + library.get().getId() + " not found.");
        }
        this.logger.info("libraryApiVersion '" + libraryApiVersion.getId() + "' '" + libraryApiVersion.getName() + "' - build pipeline " + pipeline.get().getPath());
        Runnable callbackIfBuildIsFinished = () -> this.validateBuilding(libraryApiVersionWithDetails, (Pipeline)pipeline.get(), callback);
        Build build = this.pipelineService.build(pipeline.get(), "dev", null, callbackIfBuildIsFinished);
        libraryApiVersionWithDetails.setPipelineStatus(LibraryApiVersion.PipelineStatusEnum.PENDING);
        libraryApiVersionWithDetails.putMetadataItem("last-build-number", (Object)build.getBuildNumber());
        this.patch(libraryApiVersionWithDetails);
        return build;
    }

    private boolean validateBuilding(LibraryApiVersion libraryApiVersion, Pipeline pipeline, Runnable callback) {
        try {
            if (!libraryApiVersion.getMetadata().containsKey("last-build-number")) {
                throw new IllegalStateException("Unable to get metadata 'last-build-number' for LibraryApiVersion " + libraryApiVersion.getId());
            }
            Build build = this.pipelineService.getBuild(pipeline, (String)libraryApiVersion.getMetadata().get("last-build-number"));
            switch (build.getStatus()) {
                case SCHEDULED: 
                case PROCESSING: {
                    throw new IllegalStateException("LibraryApiVersion '" + libraryApiVersion.getId() + "' '" + libraryApiVersion.getName() + " building should be finished");
                }
                case SUCCESS: {
                    this.logger.info("LibraryApiVersion '" + libraryApiVersion.getId() + "' '" + libraryApiVersion.getName() + "' has been build");
                    libraryApiVersion.pipelineStatus(LibraryApiVersion.PipelineStatusEnum.READY);
                    this.patch(new LibraryApiVersion().id(libraryApiVersion.getId()).pipelineStatus(LibraryApiVersion.PipelineStatusEnum.READY));
                    if (!this.isReady((Resource)libraryApiVersion)) {
                        this.updateStatus(libraryApiVersion, Resource.StatusEnum.READY);
                    }
                    if (callback != null) {
                        callback.run();
                    }
                    return true;
                }
                case FAILED: {
                    this.patch(new LibraryApiVersion().id(libraryApiVersion.getId()).pipelineStatus(LibraryApiVersion.PipelineStatusEnum.ERROR));
                    throw new Exception("An error occurred during building libraryApiVersion '" + libraryApiVersion.getId() + "' '" + libraryApiVersion.getName());
                }
            }
            throw new IllegalStateException("LibraryApiVersion '" + libraryApiVersion.getId() + "' '" + libraryApiVersion.getName() + " building have not implemented status " + build.getStatus());
        }
        catch (Exception e) {
            this.manageError(libraryApiVersion, e);
            if (callback != null) {
                callback.run();
            }
            return false;
        }
    }

    public void delete(LibraryApiVersion libApiVersion, boolean purge) throws ApiException {
        try {
            LibraryApiVersion libApiVersionToDeleted = this.resourceManager.getLibraryApiVersion(libApiVersion.getId());
            if (this.isDeleted((Resource)libApiVersionToDeleted)) {
                return;
            }
            this.resourceManager.deleteLibraryApiVersion(libApiVersionToDeleted.getId());
            libApiVersion.status(Resource.StatusEnum.DELETED);
        }
        catch (ApiException e) {
            this.manageError(libApiVersion, (Exception)((Object)e));
            throw e;
        }
    }
}

