/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.pipeline;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.library.LibraryService;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.core.model.Build;
import org.kathra.core.model.BuildArgument;
import org.kathra.core.model.Component;
import org.kathra.core.model.Library;
import org.kathra.core.model.Pipeline;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.pipelinemanager.client.PipelineManagerClient;
import org.kathra.resourcemanager.client.PipelinesClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;

public class PipelineService
extends AbstractResourceService<Pipeline> {
    private PipelinesClient resourceManager;
    private PipelineManagerClient pipelineManagerClient;
    private LibraryService libraryService;
    private SourceRepositoryService sourceRepositoryService;
    private ComponentService componentService;
    private static final String BUILD_PARAM_BRANCH = "GIT_BRANCH";
    private static final String BUILD_PARAM_SRC_URL = "GIT_URL";
    public int intervalCheckMs = 30000;
    public int intervalTimeoutMs = 600000;

    public PipelineService() {
    }

    @Override
    public void configure(ServiceInjection serviceInjection) {
        super.configure(serviceInjection);
        this.resourceManager = new PipelinesClient(serviceInjection.getConfig().getResourceManagerUrl(), serviceInjection.getSessionManager());
        this.pipelineManagerClient = new PipelineManagerClient(serviceInjection.getConfig().getPipelineManagerUrl(), serviceInjection.getSessionManager());
        this.libraryService = serviceInjection.getService(LibraryService.class);
        this.sourceRepositoryService = serviceInjection.getService(SourceRepositoryService.class);
        this.componentService = serviceInjection.getService(ComponentService.class);
    }

    public PipelineService(PipelinesClient resourceManager, PipelineManagerClient pipelineManagerClient, LibraryService libraryService, SourceRepositoryService sourceRepositoryService, KathraSessionManager kathraSessionManager, ComponentService componentService) {
        this.libraryService = libraryService;
        this.pipelineManagerClient = pipelineManagerClient;
        this.resourceManager = resourceManager;
        this.sourceRepositoryService = sourceRepositoryService;
        this.componentService = componentService;
        this.kathraSessionManager = kathraSessionManager;
    }

    public void setIntervalCheckMs(int intervalCheckMs) {
        this.intervalCheckMs = intervalCheckMs;
    }

    public void setIntervalTimeoutMs(int intervalTimeoutMs) {
        this.intervalTimeoutMs = intervalTimeoutMs;
    }

    public Build build(Pipeline pipeline, String branchOrTag, Map<String, String> extrasArgs, Runnable callback) throws ApiException {
        if (pipeline == null) {
            throw new IllegalArgumentException("Pipeline is null");
        }
        if (StringUtils.isEmpty((CharSequence)pipeline.getPath())) {
            throw new IllegalArgumentException("Pipeline's path is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)pipeline.getProviderId())) {
            throw new IllegalArgumentException("Pipeline's providerId is null or empty");
        }
        if (pipeline.getSourceRepository() == null) {
            throw new IllegalArgumentException("Pipeline's SourceRepository is null");
        }
        if (StringUtils.isEmpty((CharSequence)branchOrTag)) {
            throw new IllegalArgumentException("branch or tag is null or empty");
        }
        String sshUrl = this.getSshUrlRepository(pipeline);
        Build build = new Build().path(pipeline.getProviderId()).addBuildArgumentsItem(new BuildArgument().key(BUILD_PARAM_BRANCH).value(branchOrTag)).addBuildArgumentsItem(new BuildArgument().key(BUILD_PARAM_SRC_URL).value(sshUrl));
        if (extrasArgs != null) {
            for (Map.Entry<String, String> entry : extrasArgs.entrySet()) {
                build.addBuildArgumentsItem(new BuildArgument().key(entry.getKey()).value(entry.getValue()));
            }
        }
        Build buildWithNumber = this.pipelineManagerClient.createBuild(build);
        if (callback != null) {
            Session session = this.kathraSessionManager.getCurrentSession();
            CompletableFuture.runAsync(() -> {
                this.kathraSessionManager.handleSession(session);
                this.checkBuildPipeline(pipeline, buildWithNumber, callback);
            });
        }
        return buildWithNumber;
    }

    private String getSshUrlRepository(Pipeline pipeline) throws ApiException {
        String sshUrl;
        if (StringUtils.isEmpty((CharSequence)pipeline.getSourceRepository().getSshUrl())) {
            Optional<SourceRepository> sourceRepositoryWithDetails = this.sourceRepositoryService.getById(pipeline.getSourceRepository().getId());
            if (!sourceRepositoryWithDetails.isPresent()) {
                throw new IllegalArgumentException("SourceRepository not found");
            }
            if (StringUtils.isEmpty((CharSequence)sourceRepositoryWithDetails.get().getSshUrl())) {
                throw new IllegalArgumentException("SourceRepository's sshUrl is null or empty");
            }
            sshUrl = sourceRepositoryWithDetails.get().getSshUrl();
        } else {
            sshUrl = pipeline.getSourceRepository().getSshUrl();
        }
        return sshUrl;
    }

    private void checkBuildPipeline(Pipeline pipeline, Build build, Runnable callback) {
        long start = System.currentTimeMillis();
        try {
            block8: while (true) {
                if (System.currentTimeMillis() - start > (long)this.intervalTimeoutMs) {
                    throw new Exception("Build " + pipeline.getProviderId() + " #" + build.getBuildNumber() + " timeout");
                }
                Thread.sleep(this.intervalCheckMs);
                try {
                    Build buildWithStatus = this.pipelineManagerClient.getBuild(pipeline.getProviderId(), build.getBuildNumber());
                    switch (buildWithStatus.getStatus()) {
                        case PROCESSING: 
                        case SCHEDULED: {
                            continue block8;
                        }
                        case SUCCESS: 
                        case FAILED: {
                            this.logger.info("Build " + pipeline.getProviderId() + " #" + build.getBuildNumber() + " has finished with status " + buildWithStatus.getStatus());
                            callback.run();
                            return;
                        }
                    }
                    throw new NotImplementedException("Build status not implemented " + buildWithStatus.getStatus());
                }
                catch (ApiException exception) {
                    this.logger.warn(exception.getMessage(), (Throwable)exception);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("Error during check pipeline's build PipelineId:" + pipeline.getId() + " build:" + pipeline.getProviderId() + " #" + build.getBuildNumber(), (Throwable)e);
            super.updateStatus(pipeline, Resource.StatusEnum.UNSTABLE);
            return;
        }
    }

    public Pipeline create(String name, String path, SourceRepository sourceRepository, Pipeline.TemplateEnum template, String credentialId, Runnable callback) throws ApiException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Name is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Path is null or empty");
        }
        if (template == null) {
            throw new IllegalArgumentException("Template is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)credentialId)) {
            throw new IllegalArgumentException("Credential is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)sourceRepository.getSshUrl())) {
            throw new IllegalArgumentException("SourceRepository sshUrl is null or empty");
        }
        if (!this.isReady((Resource)sourceRepository)) {
            throw new IllegalArgumentException("SourceRepository's library is not ready");
        }
        Pipeline toAdd = new Pipeline().name(name).sourceRepository(sourceRepository).path(path).template(template).credentialId(credentialId);
        Pipeline pipeline = this.resourceManager.addPipeline(toAdd);
        try {
            Session session = this.kathraSessionManager.getCurrentSession();
            CompletableFuture.runAsync(() -> {
                block8: {
                    try {
                        this.kathraSessionManager.handleSession(session);
                        Pipeline pipelineUpdated = this.pipelineManagerClient.createPipeline(pipeline.sourceRepository(sourceRepository));
                        pipeline.provider(pipelineUpdated.getProvider());
                        pipeline.providerId(pipelineUpdated.getProviderId());
                        pipeline.status(Resource.StatusEnum.READY);
                        this.resourceManager.updatePipeline(pipeline.getId(), pipeline);
                        if (callback == null) break block8;
                        try {
                            callback.run();
                        }
                        catch (Exception e) {
                            this.logger.error("Unable run callback", (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        this.manageError(pipeline, e);
                        if (callback == null) break block8;
                        try {
                            callback.run();
                        }
                        catch (Exception e2) {
                            this.logger.error("Unable run callback", (Throwable)e2);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.manageError(pipeline, e);
        }
        return pipeline;
    }

    public Pipeline createLibraryPipeline(Library library, Runnable callback) throws ApiException {
        if (library == null) {
            throw new IllegalArgumentException("library is null");
        }
        if (library.getLanguage() == null) {
            throw new IllegalArgumentException("Programming language's library is null");
        }
        if (library.getType() == null) {
            throw new IllegalArgumentException("Type's library is null");
        }
        if (library.getComponent() == null) {
            throw new IllegalArgumentException("Component's library is null");
        }
        Component component = this.componentService.getById(library.getComponent().getId()).orElseThrow(() -> new IllegalStateException("Unable to find component " + library.getComponent().getId()));
        if (StringUtils.isEmpty((CharSequence)component.getName())) {
            throw new IllegalArgumentException("Component name is null or empty");
        }
        if (component.getMetadata() == null || !component.getMetadata().containsKey("groupPath") || StringUtils.isEmpty((CharSequence)((CharSequence)component.getMetadata().get("groupPath")))) {
            throw new IllegalArgumentException("Component groupPath is null or empty");
        }
        if (component.getMetadata() == null || !component.getMetadata().containsKey("groupId") || StringUtils.isEmpty((CharSequence)((CharSequence)component.getMetadata().get("groupId")))) {
            throw new IllegalArgumentException("Component groupId is null or empty");
        }
        if (library.getSourceRepository() == null) {
            throw new IllegalArgumentException("SourceRepository's library is null");
        }
        SourceRepository sourceRepository = this.sourceRepositoryService.getById(library.getSourceRepository().getId()).orElseThrow(() -> new IllegalStateException("Unable to find SourceRepository " + library.getSourceRepository().getId()));
        if (StringUtils.isEmpty((CharSequence)sourceRepository.getSshUrl())) {
            throw new IllegalArgumentException("SourceRepository sshUrl is null or empty");
        }
        if (!this.isReady((Resource)sourceRepository)) {
            throw new IllegalArgumentException("SourceRepository's library is not ready");
        }
        String path = component.getMetadata().get("groupPath") + "/components/" + component.getName() + "/" + library.getLanguage() + "/" + library.getType();
        String credentialId = (String)component.getMetadata().get("groupId");
        Pipeline.TemplateEnum template = null;
        switch (library.getLanguage()) {
            case JAVA: {
                template = Pipeline.TemplateEnum.JAVA_LIBRARY;
                break;
            }
            case PYTHON: {
                template = Pipeline.TemplateEnum.PYTHON_LIBRARY;
                break;
            }
            default: {
                throw new NotImplementedException("language " + library.getLanguage() + " not implemented");
            }
        }
        Pipeline pipeline = this.create(library.getName(), path, sourceRepository, template, credentialId, callback);
        this.libraryService.patch(new Library().id(library.getId()).pipeline(pipeline));
        return pipeline;
    }

    public Build getBuild(Pipeline pipeline, String buildNumber) throws ApiException {
        return this.pipelineManagerClient.getBuild(pipeline.getProviderId(), buildNumber);
    }

    @Override
    protected void patch(Pipeline object) throws ApiException {
        this.resourceManager.updatePipelineAttributes(object.getId(), object);
    }

    @Override
    public Optional<Pipeline> getById(String id) throws ApiException {
        Pipeline pipeline = this.resourceManager.getPipeline(id);
        return pipeline == null ? Optional.of(null) : Optional.of(pipeline);
    }

    @Override
    public List<Pipeline> getAll() throws ApiException {
        return this.resourceManager.getPipelines();
    }

    public List<Build> getBuildsByBranch(Pipeline pipeline, String branch) throws ApiException {
        return this.pipelineManagerClient.getBuilds(pipeline.getProviderId(), branch, null);
    }

    public void delete(Pipeline pipeline, boolean purge) throws ApiException {
        try {
            Pipeline pipelineToDeleted = this.resourceManager.getPipeline(pipeline.getId());
            if (this.isDeleted((Resource)pipelineToDeleted)) {
                return;
            }
            if (purge) {
                this.pipelineManagerClient.deletePipeline(pipelineToDeleted.getProviderId());
            }
            this.resourceManager.deletePipeline(pipelineToDeleted.getId());
            pipeline.status(Resource.StatusEnum.DELETED);
        }
        catch (ApiException e) {
            this.manageError(pipeline, (Exception)((Object)e));
            throw e;
        }
    }
}

