/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.pipeline;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.camel.cdi.ContextName;
import org.kathra.appmanager.Config;
import org.kathra.appmanager.implementation.ImplementationService;
import org.kathra.appmanager.pipeline.PipelineService;
import org.kathra.appmanager.service.PipelinesService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.core.model.Build;
import org.kathra.core.model.Pipeline;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraException;

@Named(value="PipelinesController")
@ContextName(value="AppManager")
public class PipelinesController
implements PipelinesService {
    private ServiceInjection serviceInjection;
    private ImplementationService implementationService;
    private PipelineService pipelineService;

    public PipelinesController(PipelineService pipelineService, ImplementationService implementationService) {
        this.pipelineService = pipelineService;
        this.implementationService = implementationService;
    }

    public PipelinesController() {
        this.serviceInjection = new ServiceInjection(new Config(), this.getSessionManager());
        this.pipelineService = this.serviceInjection.getService(PipelineService.class);
        this.implementationService = this.serviceInjection.getService(ImplementationService.class);
    }

    public Build executePipeline(String pipelineId, String branch) throws Exception {
        Pipeline implementationPipeline = this.getPipeline(pipelineId);
        return this.pipelineService.build(implementationPipeline, branch, null, null);
    }

    public List<Build> getPipelineBuildsForBranch(String pipelineId, String branch) throws Exception {
        return this.pipelineService.getBuildsByBranch(this.getPipeline(pipelineId), branch).stream().map(build -> new Build().buildNumber(build.getBuildNumber()).status(build.getStatus()).creationDate(build.getCreationDate()).duration(build.getDuration())).collect(Collectors.toList());
    }

    private Pipeline getPipeline(String pipelineId) throws ApiException, KathraException {
        Pipeline pipeline = this.pipelineService.getById(pipelineId).orElseThrow(() -> new KathraException("Pipeline " + pipelineId + " not found", null, KathraException.ErrorCode.NOT_FOUND));
        boolean pipelineImplementationAuthorized = this.implementationService.getAll().stream().anyMatch(implementation -> implementation.getPipeline() != null && implementation.getPipeline().getId() != null && implementation.getPipeline().getId().equals(pipelineId));
        if (!pipelineImplementationAuthorized) {
            throw new KathraException("Pipeline's implementation '" + pipelineId + "' forbidden", null, KathraException.ErrorCode.FORBIDDEN);
        }
        return pipeline;
    }
}

