/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.core.model.Resource;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceService<X extends Resource> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected KathraSessionManager kathraSessionManager;

    public void configure(ServiceInjection serviceInjection) {
        this.kathraSessionManager = serviceInjection.getSessionManager();
    }

    public boolean isReady(Resource resource) {
        return resource != null && resource.getStatus() != null && resource.getStatus().equals((Object)Resource.StatusEnum.READY);
    }

    public boolean isPending(Resource resource) {
        return resource != null && resource.getStatus() != null && resource.getStatus().equals((Object)Resource.StatusEnum.PENDING);
    }

    public boolean isError(Resource resource) {
        return resource != null && resource.getStatus() != null && resource.getStatus().equals((Object)Resource.StatusEnum.ERROR);
    }

    public boolean isDeleted(Resource resource) {
        return resource != null && resource.getStatus() != null && resource.getStatus().equals((Object)Resource.StatusEnum.DELETED);
    }

    public void throwExceptionIfError(Resource resource) {
        if (this.isError(resource)) {
            throw new IllegalStateException("Resource " + resource.getClass().getSimpleName() + " " + resource.getId() + " has status error");
        }
    }

    protected void updateStatus(X object, Resource.StatusEnum status) {
        try {
            if (object.getId() != null) {
                Resource patched = (Resource)object.getClass().getConstructors()[0].newInstance(new Object[0]);
                patched.setId(object.getId());
                object.setStatus(status);
                patched.setStatus(status);
                this.patch(patched);
                this.logger.info("Resource " + object.getId() + " has status " + status);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to change resource " + object.getId() + " status to " + status, (Throwable)e);
        }
    }

    protected abstract void patch(X var1) throws ApiException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageError(X object, Exception exception) {
        this.logger.error("Error occurred for resource " + object.getClass() + " with id " + object.getId(), (Throwable)exception);
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        exception.printStackTrace(printWriter);
        try {
            if (object.getId() != null) {
                Resource patched = (Resource)object.getClass().getConstructors()[0].newInstance(new Object[0]);
                patched.setId(object.getId());
                object.setStatus(Resource.StatusEnum.ERROR);
                patched.setStatus(Resource.StatusEnum.ERROR);
                patched.putMetadataItem("error-stack-trace", (Object)writer.toString());
                this.patch(patched);
                this.logger.info("Resource " + object.getId() + " has status " + Resource.StatusEnum.ERROR);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to change resource " + object.getId() + " status to " + Resource.StatusEnum.ERROR, (Throwable)e);
        }
        finally {
            printWriter.flush();
            exception.printStackTrace();
        }
    }

    protected Map<String, X> mapById(List<X> resourcesToMap) {
        return resourcesToMap.stream().collect(Collectors.toMap(Resource::getId, item -> item));
    }

    public abstract Optional<X> getById(String var1) throws ApiException;

    public abstract List<X> getAll() throws ApiException;
}

