/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.kathra.appmanager.Config;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.utils.KathraSessionManager;

public class ServiceInjection {
    private final Map<Class, AbstractResourceService> instancesServices = new HashMap<Class, AbstractResourceService>();
    Config config;
    KathraSessionManager kathraSessionManager;

    public ServiceInjection(Config config, KathraSessionManager sessionManager) {
        this.config = config;
        this.kathraSessionManager = sessionManager;
    }

    public synchronized <T extends AbstractResourceService> T getService(Class<T> clazz) {
        AbstractResourceService instance = this.instancesServices.get(clazz);
        if (instance == null) {
            try {
                Constructor<T> defaultConstructor = clazz.getConstructor(new Class[0]);
                instance = (AbstractResourceService)defaultConstructor.newInstance(new Object[0]);
                this.instancesServices.put(clazz, instance);
                instance.configure(this);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return (T)instance;
    }

    public KathraSessionManager getSessionManager() {
        return this.kathraSessionManager;
    }

    public Config getConfig() {
        return this.config;
    }
}

