/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.sourcerepository;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.camel.cdi.ContextName;
import org.kathra.appmanager.Config;
import org.kathra.appmanager.implementation.ImplementationService;
import org.kathra.appmanager.model.Commit;
import org.kathra.appmanager.service.RepositoriesService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.appmanager.sourcerepository.SourceRepositoryService;
import org.kathra.core.model.SourceRepository;
import org.kathra.core.model.SourceRepositoryCommit;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraException;

@Named(value="RepositoriesController")
@ContextName(value="AppManager")
public class SourceRepositoriesController
implements RepositoriesService {
    private ServiceInjection serviceInjection;
    private ImplementationService implementationService;
    private SourceRepositoryService sourceRepositoryService;

    public SourceRepositoriesController(SourceRepositoryService sourceRepositoryService, ImplementationService implementationService) {
        this.implementationService = implementationService;
        this.sourceRepositoryService = sourceRepositoryService;
    }

    public SourceRepositoriesController() {
        this.serviceInjection = new ServiceInjection(new Config(), this.getSessionManager());
        this.sourceRepositoryService = this.serviceInjection.getService(SourceRepositoryService.class);
        this.implementationService = this.serviceInjection.getService(ImplementationService.class);
    }

    public List<String> getRepositoryBranches(String sourceRepositoryId) throws Exception {
        return this.sourceRepositoryService.getBranchs(this.getSourceRepositoryImpl(sourceRepositoryId));
    }

    public List<Commit> getRepositoryCommitsForBranch(String sourceRepositoryId, String branch) throws Exception {
        return this.sourceRepositoryService.getCommits(this.getSourceRepositoryImpl(sourceRepositoryId), branch).stream().map((? super T commit) -> this.map((SourceRepositoryCommit)commit)).collect(Collectors.toList());
    }

    private SourceRepository getSourceRepositoryImpl(String sourceRepositoryId) throws ApiException, KathraException {
        SourceRepository sourceRepository = this.sourceRepositoryService.getById(sourceRepositoryId).orElseThrow(() -> new KathraException("SourceRepository " + sourceRepositoryId + " not found", null, KathraException.ErrorCode.NOT_FOUND));
        boolean sourceRepositoryImplementationAuthorized = this.implementationService.getAll().stream().anyMatch(implementation -> implementation.getSourceRepository() != null && implementation.getSourceRepository().getId() != null && implementation.getSourceRepository().getId().equals(sourceRepositoryId));
        if (!sourceRepositoryImplementationAuthorized) {
            throw new KathraException("SourceRepository's implementation '" + sourceRepositoryId + "' forbidden", null, KathraException.ErrorCode.FORBIDDEN);
        }
        return sourceRepository;
    }

    private Commit map(SourceRepositoryCommit commit) {
        return new Commit().id(commit.getId()).author(commit.getAuthorName()).date(commit.getCreatedAt()).hash(commit.getId()).message(commit.getMessage());
    }
}

