/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.appmanager.sourcerepository;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.kathra.appmanager.component.ComponentService;
import org.kathra.appmanager.library.LibraryService;
import org.kathra.appmanager.service.AbstractResourceService;
import org.kathra.appmanager.service.ServiceInjection;
import org.kathra.core.model.Component;
import org.kathra.core.model.Library;
import org.kathra.core.model.Resource;
import org.kathra.core.model.SourceRepository;
import org.kathra.core.model.SourceRepositoryCommit;
import org.kathra.resourcemanager.client.SourceRepositoriesClient;
import org.kathra.sourcemanager.client.SourceManagerClient;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;

public class SourceRepositoryService
extends AbstractResourceService<SourceRepository> {
    private SourceManagerClient sourceManagerClient;
    private SourceRepositoriesClient resourceManager;
    private LibraryService libraryService;
    private ComponentService componentService;

    public SourceRepositoryService() {
    }

    @Override
    public void configure(ServiceInjection serviceInjection) {
        super.configure(serviceInjection);
        this.resourceManager = new SourceRepositoriesClient(serviceInjection.getConfig().getResourceManagerUrl(), serviceInjection.getSessionManager());
        this.sourceManagerClient = new SourceManagerClient(serviceInjection.getConfig().getSourceManagerUrl(), serviceInjection.getSessionManager());
        this.libraryService = serviceInjection.getService(LibraryService.class);
        this.componentService = serviceInjection.getService(ComponentService.class);
    }

    public SourceRepositoryService(SourceRepositoriesClient resourceManager, SourceManagerClient sourceManagerClient, ComponentService componentService, LibraryService libraryService, KathraSessionManager kathraSessionManager) {
        this.sourceManagerClient = sourceManagerClient;
        this.resourceManager = resourceManager;
        this.libraryService = libraryService;
        this.componentService = componentService;
        this.kathraSessionManager = kathraSessionManager;
    }

    public void setSourceManagerClient(SourceManagerClient sourceManagerClient) {
        this.sourceManagerClient = sourceManagerClient;
    }

    public SourceRepositoriesClient getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(SourceRepositoriesClient resourceManager) {
        this.resourceManager = resourceManager;
    }

    public LibraryService getLibraryService() {
        return this.libraryService;
    }

    public void setLibraryService(LibraryService libraryService) {
        this.libraryService = libraryService;
    }

    public SourceRepository createLibraryRepository(Library library, Runnable callback) throws ApiException {
        if (library == null) {
            throw new IllegalArgumentException("library is null");
        }
        if (library.getLanguage() == null) {
            throw new IllegalArgumentException("Programming language's library is null");
        }
        if (library.getType() == null) {
            throw new IllegalArgumentException("Type's library is null");
        }
        if (library.getComponent() == null) {
            throw new IllegalArgumentException("Component's library is null");
        }
        Component component = this.componentService.getById(library.getComponent().getId()).orElseThrow(() -> new IllegalStateException("Unable to find component " + library.getComponent().getId()));
        if (StringUtils.isEmpty((CharSequence)component.getName())) {
            throw new IllegalArgumentException("Component name is null or empty");
        }
        if (component.getMetadata() == null || !component.getMetadata().containsKey("groupPath") || StringUtils.isEmpty((CharSequence)((CharSequence)component.getMetadata().get("groupPath")))) {
            throw new IllegalArgumentException("Component groupPath is null or empty");
        }
        if (component.getMetadata() == null || !component.getMetadata().containsKey("groupId") || StringUtils.isEmpty((CharSequence)((CharSequence)component.getMetadata().get("groupId")))) {
            throw new IllegalArgumentException("Component groupId is null or empty");
        }
        String name = library.getName();
        String parentPath = component.getMetadata().get("groupPath") + "/components/" + component.getName() + "/" + library.getLanguage();
        String path = parentPath + "/" + library.getType();
        String[] deploysKeys = new String[]{(String)component.getMetadata().get("groupId")};
        SourceRepository sourceRepository = this.create(name, path, deploysKeys, callback);
        this.libraryService.patch(new Library().id(library.getId()).sourceRepository(sourceRepository));
        library.setSourceRepository(sourceRepository);
        return sourceRepository;
    }

    public SourceRepository create(String name, String path, String[] deploysKeys, Runnable callback) throws ApiException {
        SourceRepository sourceRepositoryToAdd = new SourceRepository().name(name).path(path);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("SourceRepository's name is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("SourceRepository's path is null or empty");
        }
        if (this.getByPath(path).isPresent()) {
            throw new IllegalArgumentException("SourceRepository with path '" + path + "' already exists");
        }
        try {
            SourceRepository sourceRepository = this.resourceManager.addSourceRepository(sourceRepositoryToAdd);
            Session session = this.kathraSessionManager.getCurrentSession();
            CompletableFuture.runAsync(() -> {
                try {
                    this.kathraSessionManager.handleSession(session);
                    SourceRepository sourceRepositoryWithInfoSourceManager = this.sourceManagerClient.createSourceRepository(sourceRepository, Arrays.asList(deploysKeys));
                    sourceRepositoryWithInfoSourceManager.setId(sourceRepository.getId());
                    sourceRepositoryWithInfoSourceManager.setPath(sourceRepository.getName());
                    sourceRepositoryWithInfoSourceManager.setPath(sourceRepository.getPath());
                    sourceRepositoryWithInfoSourceManager.setStatus(Resource.StatusEnum.READY);
                    this.patch(sourceRepositoryWithInfoSourceManager);
                }
                catch (Exception e) {
                    this.manageError(sourceRepository, e);
                }
                finally {
                    try {
                        if (callback != null) {
                            callback.run();
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("callback execution error", (Throwable)e);
                    }
                }
            });
            return sourceRepository;
        }
        catch (ApiException e) {
            this.manageError(sourceRepositoryToAdd, (Exception)((Object)e));
            throw e;
        }
    }

    public SourceRepositoryCommit commitFileAndTag(SourceRepository sourceRepository, String branch, File file, String filename, String tag) throws ApiException {
        this.checkSrcRepo(sourceRepository);
        if (StringUtils.isEmpty((CharSequence)branch)) {
            throw new IllegalArgumentException("Branch is null or empty");
        }
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        return this.sourceManagerClient.createCommit(sourceRepository.getPath(), branch, file, filename, Boolean.valueOf(false), tag, Boolean.valueOf(false));
    }

    private void checkSrcRepo(SourceRepository sourceRepository) {
        if (sourceRepository == null) {
            throw new IllegalArgumentException("SourceRepository is null");
        }
        if (StringUtils.isEmpty((CharSequence)sourceRepository.getPath())) {
            throw new IllegalArgumentException("SourceRepository's path is null or empty");
        }
    }

    public SourceRepositoryCommit commitArchiveAndTag(SourceRepository sourceRepository, String branch, File file, String path, String tag) throws ApiException {
        this.checkSrcRepo(sourceRepository);
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        if (StringUtils.isEmpty((CharSequence)branch)) {
            throw new IllegalArgumentException("Branch is null or empty");
        }
        return this.sourceManagerClient.createCommit(sourceRepository.getPath(), branch, file, path, Boolean.valueOf(true), tag, Boolean.valueOf(true));
    }

    private Optional<SourceRepository> getByPath(String path) throws ApiException {
        return this.resourceManager.getSourceRepositories().stream().filter(i -> i.getPath().equals(path)).findFirst();
    }

    @Override
    protected void patch(SourceRepository object) throws ApiException {
        this.resourceManager.updateSourceRepositoryAttributes(object.getId(), object);
    }

    @Override
    public Optional<SourceRepository> getById(String id) throws ApiException {
        SourceRepository object = this.resourceManager.getSourceRepository(id);
        return object == null ? Optional.empty() : Optional.of(object);
    }

    @Override
    public List<SourceRepository> getAll() throws ApiException {
        return this.resourceManager.getSourceRepositories();
    }

    public File getFile(SourceRepository sourceRepository, String branch, String filepath) throws ApiException {
        this.checkSrcRepo(sourceRepository);
        if (StringUtils.isEmpty((CharSequence)branch)) {
            throw new IllegalArgumentException("branch is null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)filepath)) {
            throw new IllegalArgumentException("filepath is null or empty");
        }
        return this.sourceManagerClient.getFile(sourceRepository.getPath(), branch, filepath);
    }

    public List<SourceRepositoryCommit> getCommits(SourceRepository sourceRepository, String branch) throws ApiException {
        this.checkSrcRepo(sourceRepository);
        if (StringUtils.isEmpty((CharSequence)branch)) {
            throw new IllegalArgumentException("branch is null or empty");
        }
        return this.sourceManagerClient.getCommits(sourceRepository.getPath(), branch);
    }

    public List<String> getBranchs(SourceRepository sourceRepository) throws ApiException {
        this.checkSrcRepo(sourceRepository);
        return this.sourceManagerClient.getBranches(sourceRepository.getPath());
    }

    public void delete(SourceRepository sourceRepository, boolean purge) throws ApiException {
        try {
            SourceRepository sourceRepositoryToDeleted = this.resourceManager.getSourceRepository(sourceRepository.getId());
            if (this.isDeleted((Resource)sourceRepositoryToDeleted)) {
                return;
            }
            if (purge) {
                this.sourceManagerClient.deleteSourceRepository(sourceRepositoryToDeleted.getPath());
            }
            this.resourceManager.deleteSourceRepository(sourceRepository.getId());
            sourceRepository.status(Resource.StatusEnum.DELETED);
        }
        catch (ApiException e) {
            this.manageError(sourceRepository, (Exception)((Object)e));
            throw e;
        }
    }
}

