/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.codegen.client;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.kathra.client.ApiCallback;
import org.kathra.client.ApiClient;
import org.kathra.client.ProgressRequestBody;
import org.kathra.client.ProgressResponseBody;
import org.kathra.utils.ApiException;
import org.kathra.utils.ApiResponse;
import org.kathra.utils.KathraSessionManager;

public class CodegenClient {
    private ApiClient apiClient = new ApiClient().setUserAgent("CodegenClient 1.1.0-SNAPSHOT");

    public CodegenClient() {
    }

    public CodegenClient(String serviceUrl) {
        this();
        this.apiClient.setBasePath(serviceUrl);
    }

    public CodegenClient(String serviceUrl, KathraSessionManager sessionManager) {
        this(serviceUrl);
        this.apiClient.setSessionManager(sessionManager);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    private void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call generateClientCall(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/client";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (artifactName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("artifactName", (Object)artifactName));
        }
        if (groupId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("groupId", (Object)groupId));
        }
        if (artifactVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("artifactVersion", (Object)artifactVersion));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("language", (Object)language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, File> localVarFormParams = new HashMap<String, File>();
        if (apiFile != null) {
            localVarFormParams.put("apiFile", apiFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/zip"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateClientValidateBeforeCall(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiFile == null) {
            throw new ApiException("Missing the required parameter 'apiFile' when calling generateClient(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling generateClient(Async)");
        }
        Call call = this.generateClientCall(apiFile, language, artifactName, groupId, artifactVersion, progressListener, progressRequestListener);
        return call;
    }

    public File generateClient(File apiFile, String language, String artifactName, String groupId, String artifactVersion) throws ApiException {
        ApiResponse<File> resp = this.generateClientWithHttpInfo(apiFile, language, artifactName, groupId, artifactVersion);
        return (File)resp.getData();
    }

    public ApiResponse<File> generateClientWithHttpInfo(File apiFile, String language, String artifactName, String groupId, String artifactVersion) throws ApiException {
        Call call = this.generateClientValidateBeforeCall(apiFile, language, artifactName, groupId, artifactVersion, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateClientAsync(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.generateClientValidateBeforeCall(apiFile, language, artifactName, groupId, artifactVersion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateImplementationCall(File apiFile, String implemName, String language, String artifactName, String groupId, String artifactVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/implem";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (implemName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("implemName", (Object)implemName));
        }
        if (artifactName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("artifactName", (Object)artifactName));
        }
        if (groupId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("groupId", (Object)groupId));
        }
        if (artifactVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("artifactVersion", (Object)artifactVersion));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("language", (Object)language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, File> localVarFormParams = new HashMap<String, File>();
        if (apiFile != null) {
            localVarFormParams.put("apiFile", apiFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/zip"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateImplementationValidateBeforeCall(File apiFile, String implemName, String language, String artifactName, String groupId, String artifactVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiFile == null) {
            throw new ApiException("Missing the required parameter 'apiFile' when calling generateImplementation(Async)");
        }
        if (implemName == null) {
            throw new ApiException("Missing the required parameter 'implemName' when calling generateImplementation(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling generateImplementation(Async)");
        }
        Call call = this.generateImplementationCall(apiFile, implemName, language, artifactName, groupId, artifactVersion, progressListener, progressRequestListener);
        return call;
    }

    public File generateImplementation(File apiFile, String implemName, String language, String artifactName, String groupId, String artifactVersion) throws ApiException {
        ApiResponse<File> resp = this.generateImplementationWithHttpInfo(apiFile, implemName, language, artifactName, groupId, artifactVersion);
        return (File)resp.getData();
    }

    public ApiResponse<File> generateImplementationWithHttpInfo(File apiFile, String implemName, String language, String artifactName, String groupId, String artifactVersion) throws ApiException {
        Call call = this.generateImplementationValidateBeforeCall(apiFile, implemName, language, artifactName, groupId, artifactVersion, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateImplementationAsync(File apiFile, String implemName, String language, String artifactName, String groupId, String artifactVersion, ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.generateImplementationValidateBeforeCall(apiFile, implemName, language, artifactName, groupId, artifactVersion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateInterfaceCall(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/interface";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (artifactName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("artifactName", (Object)artifactName));
        }
        if (groupId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("groupId", (Object)groupId));
        }
        if (artifactVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("artifactVersion", (Object)artifactVersion));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("language", (Object)language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, File> localVarFormParams = new HashMap<String, File>();
        if (apiFile != null) {
            localVarFormParams.put("apiFile", apiFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/zip"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateInterfaceValidateBeforeCall(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiFile == null) {
            throw new ApiException("Missing the required parameter 'apiFile' when calling generateInterface(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling generateInterface(Async)");
        }
        Call call = this.generateInterfaceCall(apiFile, language, artifactName, groupId, artifactVersion, progressListener, progressRequestListener);
        return call;
    }

    public File generateInterface(File apiFile, String language, String artifactName, String groupId, String artifactVersion) throws ApiException {
        ApiResponse<File> resp = this.generateInterfaceWithHttpInfo(apiFile, language, artifactName, groupId, artifactVersion);
        return (File)resp.getData();
    }

    public ApiResponse<File> generateInterfaceWithHttpInfo(File apiFile, String language, String artifactName, String groupId, String artifactVersion) throws ApiException {
        Call call = this.generateInterfaceValidateBeforeCall(apiFile, language, artifactName, groupId, artifactVersion, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateInterfaceAsync(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.generateInterfaceValidateBeforeCall(apiFile, language, artifactName, groupId, artifactVersion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateModelCall(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/model";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        if (artifactName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("artifactName", (Object)artifactName));
        }
        if (groupId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("groupId", (Object)groupId));
        }
        if (artifactVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("artifactVersion", (Object)artifactVersion));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("language", (Object)language));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, File> localVarFormParams = new HashMap<String, File>();
        if (apiFile != null) {
            localVarFormParams.put("apiFile", apiFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/zip"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(chain -> {
                Response originalResponse = chain.proceed(chain.request());
                return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateModelValidateBeforeCall(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiFile == null) {
            throw new ApiException("Missing the required parameter 'apiFile' when calling generateModel(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling generateModel(Async)");
        }
        Call call = this.generateModelCall(apiFile, language, artifactName, groupId, artifactVersion, progressListener, progressRequestListener);
        return call;
    }

    public File generateModel(File apiFile, String language, String artifactName, String groupId, String artifactVersion) throws ApiException {
        ApiResponse<File> resp = this.generateModelWithHttpInfo(apiFile, language, artifactName, groupId, artifactVersion);
        return (File)resp.getData();
    }

    public ApiResponse<File> generateModelWithHttpInfo(File apiFile, String language, String artifactName, String groupId, String artifactVersion) throws ApiException {
        Call call = this.generateModelValidateBeforeCall(apiFile, language, artifactName, groupId, artifactVersion, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateModelAsync(File apiFile, String language, String artifactName, String groupId, String artifactVersion, ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = (bytesRead, contentLength, done) -> callback.onDownloadProgress(bytesRead, contentLength, done);
            progressRequestListener = (bytesWritten, contentLength, done) -> callback.onUploadProgress(bytesWritten, contentLength, done);
        }
        Call call = this.generateModelValidateBeforeCall(apiFile, language, artifactName, groupId, artifactVersion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

