/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.codegen.controller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import javax.activation.FileDataSource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.camel.cdi.ContextName;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kathra.codegen.ClientOptInput;
import org.kathra.codegen.KathraGenerator;
import org.kathra.codegen.config.CodegenConfigurator;
import org.kathra.codegen.controller.Config;
import org.kathra.codegen.service.CodegenService;
import org.kathra.utils.annotations.Eager;
import org.yaml.snakeyaml.Yaml;
import org.zeroturnaround.zip.ZipUtil;

@Named(value="CodegenController")
@ApplicationScoped
@Eager
@ContextName(value="Codegen")
public class CodegenController
implements CodegenService {
    Config config = new Config();

    public FileDataSource generateClient(FileDataSource apiFile, String language, String artifactName, String groupId, String artifactVersion) throws Exception {
        if (language.equalsIgnoreCase("JAVA")) {
            return this.generateJava(apiFile.getFile(), artifactName, groupId, artifactVersion, "client", null);
        }
        if (language.equalsIgnoreCase("PYTHON")) {
            return this.generatePython(apiFile.getFile(), artifactName, groupId, artifactVersion, "client", null);
        }
        return null;
    }

    public FileDataSource generateImplementation(FileDataSource apiFile, String implemName, String language, String artifactName, String groupId, String artifactVersion) throws Exception {
        if (language.equalsIgnoreCase("JAVA")) {
            return this.generateJava(apiFile.getFile(), artifactName, groupId, artifactVersion, "implem", implemName);
        }
        if (language.equalsIgnoreCase("PYTHON")) {
            return this.generatePythonImpl(apiFile.getFile(), artifactName, groupId, artifactVersion, implemName);
        }
        return null;
    }

    public FileDataSource generateInterface(FileDataSource apiFile, String language, String artifactName, String groupId, String artifactVersion) throws Exception {
        if (language.equalsIgnoreCase("JAVA")) {
            return this.generateJava(apiFile.getFile(), artifactName, groupId, artifactVersion, "interface", null);
        }
        if (language.equalsIgnoreCase("PYTHON")) {
            return this.generatePython(apiFile.getFile(), artifactName, groupId, artifactVersion, "interface", null);
        }
        return null;
    }

    public FileDataSource generateModel(FileDataSource apiFile, String language, String artifactName, String groupId, String artifactVersion) throws Exception {
        if (language.equalsIgnoreCase("JAVA")) {
            return this.generateJava(apiFile.getFile(), artifactName, groupId, artifactVersion, "model", null);
        }
        if (language.equalsIgnoreCase("PYTHON")) {
            return this.generatePython(apiFile.getFile(), artifactName, groupId, artifactVersion, "model", null);
        }
        return null;
    }

    public FileDataSource generatePython(File spec, String artifactName, String groupId, String artifactVersion, String library, String implemName) throws Exception {
        Yaml yaml = new Yaml();
        if (groupId == null || artifactName == null || artifactVersion == null) {
            LinkedHashMap swaggerFile = (LinkedHashMap)yaml.load((InputStream)FileUtils.openInputStream((File)spec));
            if (groupId == null) {
                groupId = this.getPropInSwaggerFile(swaggerFile, "x-groupId");
            }
            if (artifactName == null) {
                artifactName = this.getPropInSwaggerFile(swaggerFile, "x-artifactName");
            }
            if (artifactVersion == null) {
                artifactVersion = this.getPropInSwaggerFile(swaggerFile, "version");
            }
        }
        String groupName = groupId.substring(groupId.lastIndexOf(46) + 1);
        StringBuilder artifactIdSb = new StringBuilder().append(groupName).append("-").append(artifactName).append("-");
        if (library.equalsIgnoreCase("implem")) {
            artifactIdSb.append(implemName);
        } else {
            artifactIdSb.append(library);
        }
        CodegenConfigurator configurator = new CodegenConfigurator();
        String artifactId = artifactIdSb.toString();
        this.initializeConfigurator(spec, "KathraPython", artifactName, groupId, artifactVersion, library, artifactId, configurator);
        configurator.setArtifactVersionApi(artifactVersion);
        return this.getFileDataSource(spec, library, artifactIdSb, artifactId, configurator);
    }

    @Deprecated
    public FileDataSource generatePythonImpl(File spec, String artifactName, String groupId, String artifactVersion, String implemName) throws Exception {
        Yaml yaml = new Yaml();
        LinkedHashMap swaggerFile = (LinkedHashMap)yaml.load((InputStream)FileUtils.openInputStream((File)spec));
        String groupIdApi = this.getPropInSwaggerFile(swaggerFile, "x-groupId");
        String artifactNameApi = this.getPropInSwaggerFile(swaggerFile, "x-artifactName");
        String artifactVersionApi = this.getPropInSwaggerFile(swaggerFile, "version");
        String groupName = groupId.substring(groupId.lastIndexOf(46) + 1);
        StringBuilder artifactIdSb = new StringBuilder().append(groupName).append("-").append(artifactNameApi).append("-");
        artifactIdSb.append(artifactName.replaceAll("-", ""));
        CodegenConfigurator configurator = new CodegenConfigurator();
        String artifactId = artifactIdSb.toString();
        this.initializeConfigurator(spec, "KathraPython", artifactNameApi, groupIdApi, artifactVersion, "implem", artifactId, configurator);
        configurator.setArtifactVersionApi(artifactVersionApi);
        return this.getFileDataSource(spec, "implem", artifactIdSb, artifactId, configurator);
    }

    public FileDataSource generateJava(File spec, String artifactName, String groupId, String artifactVersion, String library, String implemName) throws Exception {
        String artifactId;
        if (groupId == null || artifactName == null || artifactVersion == null) {
            Yaml yaml = new Yaml();
            LinkedHashMap swaggerFile = (LinkedHashMap)yaml.load((InputStream)FileUtils.openInputStream((File)spec));
            if (groupId == null) {
                groupId = this.getPropInSwaggerFile(swaggerFile, "x-groupId");
            }
            if (artifactName == null) {
                artifactName = this.getPropInSwaggerFile(swaggerFile, "x-artifactName");
            }
            if (artifactVersion == null) {
                artifactVersion = this.getPropInSwaggerFile(swaggerFile, "version");
            }
        }
        if (!((String)artifactVersion).trim().endsWith("-SNAPSHOT")) {
            artifactVersion = (String)artifactVersion + "-SNAPSHOT";
        }
        String groupName = groupId.substring(groupId.lastIndexOf(46) + 1);
        StringBuilder sb = new StringBuilder().append(groupName).append("-").append(artifactName).append("-");
        if (library.equalsIgnoreCase("implem")) {
            sb.append(implemName);
            artifactId = artifactName;
        } else {
            sb.append(library);
            artifactId = sb.toString();
        }
        CodegenConfigurator configurator = new CodegenConfigurator();
        this.initializeConfigurator(spec, "KathraJava", artifactName, groupId, (String)artifactVersion, library, artifactId, configurator);
        if (library.equalsIgnoreCase("implem")) {
            this.configureArtifactApiInterface(spec, configurator);
        }
        return this.getFileDataSource(spec, library, sb, artifactId, configurator);
    }

    private FileDataSource getFileDataSource(File spec, String library, StringBuilder sb, String artifactId, CodegenConfigurator configurator) throws IOException {
        ClientOptInput clientOptInput = configurator.toClientOptInput();
        sb.setLength(0);
        sb.append(spec.getPath().toLowerCase()).append("d").append(File.separatorChar);
        File dir = new File(sb.toString() + "gen");
        File zip = new File(sb.toString() + artifactId.toLowerCase() + ".zip");
        dir.mkdirs();
        new KathraGenerator().opts(clientOptInput).generate();
        if (library.equalsIgnoreCase("interface")) {
            Files.copy(spec.toPath(), Paths.get(configurator.getOutputDir().toLowerCase() + File.separatorChar + "swagger.yml", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        dir = new File(configurator.getOutputDir().toLowerCase());
        ZipUtil.pack((File)dir, (File)zip);
        return new FileDataSource(zip);
    }

    private void configureArtifactApiInterface(File spec, CodegenConfigurator configurator) throws IOException, MissingArgumentException {
        Yaml yaml = new Yaml();
        LinkedHashMap swaggerFile = (LinkedHashMap)yaml.load((InputStream)FileUtils.openInputStream((File)spec));
        String groupIdApi = this.getPropInSwaggerFile(swaggerFile, "x-groupId");
        String artifactIdApi = this.getPropInSwaggerFile(swaggerFile, "x-artifactName");
        configurator.setArtifactIdApi(groupIdApi.split("\\.")[groupIdApi.split("\\.").length - 1] + "-" + artifactIdApi.toLowerCase() + "-interface");
        configurator.setGroupIdApi(groupIdApi);
        configurator.setArtifactVersionApi(this.getPropInSwaggerFile(swaggerFile, "version") + "-SNAPSHOT");
        configurator.setApiPackage(artifactIdApi);
        configurator.setModelPackage(artifactIdApi);
    }

    private void initializeConfigurator(File spec, String language, String artifactName, String groupId, String artifactVersion, String library, String artifactId, CodegenConfigurator configurator) {
        if (StringUtils.isNotEmpty((CharSequence)spec.getPath())) {
            configurator.setInputSpec(spec.getPath());
        }
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            configurator.setLang(language);
        }
        if (StringUtils.isNotEmpty((CharSequence)spec.getPath())) {
            configurator.setOutputDir(spec.getPath() + "d" + File.separatorChar + "gen" + File.separatorChar + artifactId.toLowerCase());
        }
        if (StringUtils.isNotEmpty((CharSequence)artifactName)) {
            configurator.setApiPackage(artifactName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.config.getArtifactHostUrl())) {
            configurator.setRepositoryUrl(this.config.getArtifactHostUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.config.getRepositoryPython())) {
            configurator.setRepositoryPythonName(this.config.getRepositoryPython());
        }
        if (StringUtils.isNotEmpty((CharSequence)artifactName)) {
            configurator.setModelPackage(artifactName.toLowerCase());
        }
        if (StringUtils.isNotEmpty((CharSequence)groupId)) {
            configurator.setGroupId(groupId);
            configurator.setInvokerPackage(groupId);
        }
        if (StringUtils.isNotEmpty((CharSequence)artifactId)) {
            configurator.setArtifactId(artifactId);
        }
        if (StringUtils.isNotEmpty((CharSequence)artifactVersion)) {
            configurator.setArtifactVersion(artifactVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)library)) {
            configurator.setLibrary(library);
        }
    }

    private String getPropInSwaggerFile(LinkedHashMap swaggerFile, String propName) throws MissingArgumentException {
        if (swaggerFile.containsKey("info")) {
            LinkedHashMap info = (LinkedHashMap)swaggerFile.get("info");
            String prop = (String)info.get(propName);
            if (prop == null || prop.isEmpty()) {
                throw new MissingArgumentException("Missing " + propName);
            }
            return prop;
        }
        throw new MissingArgumentException("Missing info section from swagger");
    }
}

