/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.iface;

import org.apache.camel.Exchange;
import org.kathra.iface.KathraRequestHandler;
import org.kathra.iface.LogUtils;
import org.kathra.utils.Session;
import org.kathra.utils.security.KeycloakUtils;
import org.slf4j.Logger;

public interface KathraAuthRequestHandler
extends KathraRequestHandler {
    default public void handleAuthenticatedRequest(Exchange exchange) throws Exception {
        this.preprocessExchange(exchange);
        Session session = this.createNewSession(exchange);
        session.authenticated(false);
        this.handleSession(session);
        KeycloakUtils.handleAuthentication((Session)session, (Logger)LogUtils.getLogger(exchange), (String)((String)exchange.getIn().getHeader("Authorization", (Object)"", String.class)));
        LogUtils.getLogger(exchange).info("{} - {} \"{}\" {}", new Object[]{session.getCallerAddress(), session.getCallerName(), session.getRequestedOperation(), session.getUserAgent()});
    }
}

