/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.iface;

import java.net.ConnectException;
import java.util.MissingResourceException;
import java.util.UUID;
import org.apache.camel.Exchange;
import org.kathra.iface.ExchangeUtils;
import org.kathra.iface.LogUtils;
import org.kathra.utils.ApiException;
import org.kathra.utils.KathraApiResponse;
import org.kathra.utils.KathraException;
import org.kathra.utils.serialization.GsonUtils;
import org.slf4j.Logger;

public interface KathraExceptionHandler {
    default public void handleException(Exchange exchange) {
        String controllerName = ExchangeUtils.getControllerNameFromExchange(exchange);
        String exceptionId = controllerName + "Exception-" + UUID.randomUUID().toString();
        Logger logger = LogUtils.getLogger(exchange);
        Exception ex = (Exception)exchange.getProperty("CamelExceptionCaught");
        logger.info(exceptionId, (Throwable)ex);
        KathraApiResponse response = new KathraApiResponse();
        if (ex instanceof KathraException) {
            KathraException kathraException = (KathraException)ex;
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)kathraException.getErrorCode().getCode());
            response.message(exceptionId + ": " + kathraException.getMessage()).statusCode(KathraApiResponse.HttpStatusCode.valueOf((String)kathraException.getErrorCode().name()));
        } else if (ex instanceof MissingResourceException) {
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)"404");
            response.message(ex.getMessage()).statusCode(KathraApiResponse.HttpStatusCode.NOT_FOUND);
        } else if (ex instanceof ApiException) {
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)((ApiException)ex).getCode());
            ApiException apiEx = (ApiException)ex;
            response.message(ex.getMessage());
            response.statusCode(KathraApiResponse.HttpStatusCode.getEnumFromCode((int)apiEx.getCode()));
            if (apiEx.getCode() == 404) {
                response.statusCode(KathraApiResponse.HttpStatusCode.NOT_FOUND);
            } else if (apiEx.getResponseBody() != null) {
                response = (KathraApiResponse)GsonUtils.gson.fromJson(((ApiException)ex).getResponseBody(), KathraApiResponse.class);
            } else if (apiEx.getCause() instanceof ConnectException) {
                response.statusCode(KathraApiResponse.HttpStatusCode.GATEWAY_TIMEOUT).message(apiEx.getMessage());
                exchange.getOut().setHeader("CamelHttpResponseCode", (Object)"504");
            }
        } else {
            response.message(exceptionId + ": " + ex.toString()).statusCode(KathraApiResponse.HttpStatusCode.INTERNAL_SERVER_ERROR);
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)response.getStatusCode().getCode());
        }
        exchange.getOut().setHeader("Content-Type", (Object)"application/json");
        exchange.getOut().setBody((Object)GsonUtils.gson.toJson((Object)response));
    }
}

