/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.iface;

import com.google.common.io.Files;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import io.netty.handler.codec.http.multipart.MixedFileUpload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty4.http.NettyHttpMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.kathra.iface.KathraExceptionHandler;
import org.kathra.iface.LogUtils;
import org.kathra.utils.KathraException;
import org.kathra.utils.KathraSessionManager;
import org.kathra.utils.Session;

public interface KathraRequestHandler
extends KathraSessionManager,
KathraExceptionHandler {
    public static final String HTTP_SERVER = "netty4-http";

    default public Session createNewSession(Exchange exchange) {
        Session session = new Session();
        session.id(exchange.getExchangeId());
        try {
            InetSocketAddress nettyRemoteAddress = (InetSocketAddress)exchange.getIn().getHeader("CamelNettyRemoteAddress", InetSocketAddress.class);
            session.callerAddress(nettyRemoteAddress.getAddress().getHostAddress());
            NettyHttpMessage httpMessage = (NettyHttpMessage)exchange.getIn().getBody(NettyHttpMessage.class);
            session.requestedOperation(httpMessage.getHttpRequest().method().toString() + " " + httpMessage.getHttpRequest().uri() + " " + httpMessage.getHttpRequest().protocolVersion().text());
            session.userAgent((String)exchange.getIn().getHeader("User-Agent", (Object)"Unknown User-Agent", String.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        exchange.setProperty("session", (Object)session);
        return session;
    }

    default public void preprocessExchange(Exchange exchange) throws IOException {
        String contentType = (String)exchange.getIn().getHeader("Content-Type", (Object)"", String.class);
        if (exchange.getIn() instanceof NettyHttpMessage && !contentType.isEmpty() && contentType.contains("multipart/form-data")) {
            HttpPostRequestDecoder request = new HttpPostRequestDecoder((HttpRequest)((NettyHttpMessage)exchange.getIn(NettyHttpMessage.class)).getHttpRequest());
            for (InterfaceHttpData part : request.getBodyHttpDatas()) {
                this.processHttpPart(exchange, part);
            }
            exchange.getIn().setHeader("CamelHttpServletRequest", (Object)request);
        } else if (exchange.getIn().getBody() instanceof Map) {
            ((HashMap)exchange.getIn().getBody(HashMap.class)).forEach((key, value) -> exchange.getIn().setHeader((String)key, value));
        }
        if (((String)exchange.getIn().getHeader("CamelHttpPath", String.class)).contains("%2F")) {
            String endpointUri = exchange.getFromEndpoint().getEndpointUri();
            endpointUri = endpointUri.substring(0, endpointUri.indexOf(63));
            String[] splittedEndpointUri = endpointUri.split("/");
            String[] splittedHttpUrl = ((String)exchange.getIn().getHeader("CamelHttpUrl", String.class)).split("/");
            for (int i = 0; i < splittedEndpointUri.length; ++i) {
                if (!splittedEndpointUri[i].contains("%7B")) continue;
                String name = splittedEndpointUri[i].replace("%7B", "").replace("%7D", "");
                exchange.getIn().setHeader(name, (Object)splittedHttpUrl[i]);
            }
        }
        exchange.getIn().getHeaders().forEach((key, value) -> {
            if (value instanceof String) {
                try {
                    exchange.getIn().setHeader(key, (Object)URLDecoder.decode((String)value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
        if (exchange.getIn().hasAttachments()) {
            exchange.getIn().getAttachments().forEach((key, value) -> exchange.getIn().setHeader(key, (Object)value.getDataSource()));
        }
    }

    default public void processHttpPart(Exchange exchange, InterfaceHttpData part) throws IOException {
        MixedFileUpload attribute;
        if (part instanceof MixedAttribute) {
            MixedAttribute attribute2 = (MixedAttribute)part;
            exchange.getIn().setHeader(attribute2.getName(), (Object)URLDecoder.decode(attribute2.getValue(), "UTF-8"));
        } else if (part instanceof MixedFileUpload && (attribute = (MixedFileUpload)part).isCompleted()) {
            FileDataSource fileDataSource;
            if (attribute.isInMemory()) {
                File file = new File(System.getProperty("java.io.tmpdir") + "/" + UUID.randomUUID() + "_" + attribute.getFilename());
                fileDataSource = new FileDataSource(file);
                Files.write((byte[])attribute.get(), (File)file);
            } else {
                fileDataSource = new FileDataSource(attribute.getFile());
            }
            exchange.getIn().addAttachment(attribute.getName(), new DataHandler((DataSource)fileDataSource));
        }
    }

    default public void postprocessExchange(Exchange exchange) throws IOException {
        HttpPostRequestDecoder httprequest;
        if (exchange.getIn().getBody() != null && exchange.getIn().getBody() instanceof FileDataSource) {
            this.handleFileExchange(exchange);
        }
        if ((httprequest = (HttpPostRequestDecoder)exchange.getIn().getHeader("CamelHttpServletRequest", HttpPostRequestDecoder.class)) != null) {
            httprequest.destroy();
        }
        exchange.getIn().removeHeader("CamelHttpServletRequest");
        if (exchange.getIn().hasAttachments()) {
            exchange.getIn().getAttachments().forEach((key, value) -> {
                exchange.getIn().removeHeader(key);
                FileDataSource fds = (FileDataSource)value.getDataSource();
                FileUtils.deleteQuietly((File)fds.getFile());
            });
            exchange.getIn().setAttachments(null);
        }
    }

    default public void handleFileExchange(Exchange exchange) throws IOException {
        FileDataSource body = (FileDataSource)exchange.getIn().getBody(FileDataSource.class);
        if (body.getName().endsWith(".png")) {
            exchange.getOut().setHeader("Content-Type", (Object)"image/png");
        } else {
            exchange.getOut().setHeader("Content-Disposition", (Object)("attachment;filename=" + body.getName()));
        }
        exchange.getOut().setBody((Object)IOUtils.toByteArray((InputStream)body.getInputStream()));
    }

    default public void handleRequest(Exchange exchange) throws Exception {
        this.preprocessExchange(exchange);
        Session session = this.createNewSession(exchange);
        this.handleSession(session);
        session.authenticated(false);
        session.setCallerName("Anonymous user");
        LogUtils.getLogger(exchange).info("{} - {} \"{}\" {}", new Object[]{session.getCallerAddress(), session.getCallerName(), session.getRequestedOperation(), session.getUserAgent()});
    }

    default public void postProcessResponse(Exchange exchange) throws IOException {
        exchange.getIn().removeHeaders("*");
        this.postprocessExchange(exchange);
        this.deleteSession();
    }

    default public boolean checkParameter(String name, Object value) throws KathraException {
        if (value == null) {
            throw new KathraException(name + " is null").errorCode(KathraException.ErrorCode.BAD_REQUEST);
        }
        if (String.class.isInstance(value.getClass()) && ((String)value).isEmpty()) {
            throw new KathraException(name + " is empty").errorCode(KathraException.ErrorCode.BAD_REQUEST);
        }
        return true;
    }
}

