/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.deploymanager.controller;

import io.fabric8.kubernetes.api.model.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LimitRangeFluent;
import io.fabric8.kubernetes.api.model.LimitRangeSpecFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.extensions.DoneableIngress;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.FileDataSource;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.rabbitmq.RabbitMQComponent;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.kathra.deploymanager.Config;
import org.kathra.deploymanager.service.DeployManagerService;
import org.kathra.utils.KathraException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

@ApplicationScoped
@Named(value="DeployManagerController")
@ContextName(value="DeployManager")
public class DeployManagerController
extends RouteBuilder
implements DeployManagerService {
    public static final Logger logger = LoggerFactory.getLogger((String)"DeployManagerController");
    ProducerTemplate pt;
    KubernetesClient client = new DefaultKubernetesClient();
    private static Config config = new Config();
    Map resources = null;
    Yaml yaml = new Yaml();

    public String deploy(FileDataSource file, String namespace, String commitId, String cluster, String branchName, String jobName) throws Exception {
        LinkedHashMap resource = (LinkedHashMap)this.yaml.load((InputStream)FileUtils.openInputStream((File)file.getFile()));
        if (config.getMode().equals("master") || !config.getClusterName().equals(cluster)) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("namespace", namespace);
            logger.info("Sending resource to dispatcher, size =" + resource.size());
            this.pt.sendBodyAndHeaders("rabbitmq://" + cluster, (Object)resource, headers);
            return "Forwarding and Deploying in cluster " + cluster;
        }
        if (config.getClusterName().equals(cluster)) {
            this.deployResource(namespace, resource);
            return "Deploying in cluster " + config.getClusterName();
        }
        throw new KathraException("Error").errorCode(KathraException.ErrorCode.INTERNAL_SERVER_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployResource(String namespace, Map resource) throws Exception {
        logger.info("Deploying resources in namespace: " + namespace);
        Namespace ns = (Namespace)((Resource)this.client.namespaces().withName(namespace)).get();
        if (ns == null) {
            ((DoneableNamespace)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((DoneableNamespace)this.client.namespaces().createNew()).withNewMetadata().withName(namespace)).addToLabels("name", namespace)).endMetadata()).done();
            this.applyLimitsAndQuotasToNamespace(namespace);
            this.addImagePullSecretToNamespace(namespace);
        }
        List objects = (List)resource.get("objects");
        HasMetadata k8sResource = null;
        for (Map obj : objects) {
            String kind;
            switch (kind = (String)obj.get("kind")) {
                case "Service": {
                    LinkedHashMap annotations;
                    String expose;
                    Map labels;
                    k8sResource = (HasMetadata)((ServiceResource)this.client.services().load(IOUtils.toInputStream((String)this.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                    ObjectMeta metadata = k8sResource.getMetadata();
                    if (metadata == null) {
                        metadata = new ObjectMeta();
                        k8sResource.setMetadata(metadata);
                    }
                    if ((labels = metadata.getLabels()) != null && !labels.isEmpty() && (expose = (String)labels.get("expose")) != null && expose.equals("true")) {
                        this.deployServiceIngress(namespace, metadata.getName());
                        this.deployServiceIngressV2(namespace, metadata.getName());
                    }
                    if ((annotations = k8sResource.getMetadata().getAnnotations()) == null) {
                        annotations = new LinkedHashMap();
                        k8sResource.getMetadata().setAnnotations(annotations);
                    }
                    k8sResource.getMetadata().getAnnotations().put("kathra/exposeUrl", "http://" + metadata.getName() + "." + namespace + "." + config.getTopLevelDomain());
                    break;
                }
                case "Deployment": {
                    k8sResource = (HasMetadata)((ScalableResource)this.client.apps().deployments().load(IOUtils.toInputStream((String)this.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                    break;
                }
                case "Ingress": {
                    k8sResource = (HasMetadata)((Resource)this.client.extensions().ingresses().load(IOUtils.toInputStream((String)this.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                    break;
                }
                case "Secret": {
                    k8sResource = (HasMetadata)((Resource)this.client.secrets().load(IOUtils.toInputStream((String)this.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                    break;
                }
                case "ConfigMap": {
                    k8sResource = (HasMetadata)((Resource)this.client.configMaps().load(IOUtils.toInputStream((String)this.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                    break;
                }
                case "Job": {
                    k8sResource = (HasMetadata)((ScalableResource)this.client.batch().jobs().load(IOUtils.toInputStream((String)this.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                    break;
                }
                case "PersistentVolumeClaim": {
                    k8sResource = (HasMetadata)((Resource)this.client.persistentVolumeClaims().load(IOUtils.toInputStream((String)this.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                    break;
                }
                default: {
                    throw new KathraException("BUG With K8sResource Template");
                }
            }
            try {
                try {
                    ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.client.resource(k8sResource).inNamespace(namespace)).createOrReplace();
                }
                catch (Exception e) {
                    logger.error("Error deploying resource " + k8sResource.toString(), (Throwable)e);
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void applyLimitsAndQuotasToNamespace(String namespaceName) throws Exception {
        Namespace ns = (Namespace)((Resource)this.client.namespaces().withName(namespaceName)).get();
        if (ns == null) {
            throw new KathraException("No namespace with name " + namespaceName);
        }
        ((DoneableLimitRange)((LimitRangeFluent.SpecNested)((LimitRangeSpecFluent.LimitsNested)((LimitRangeSpecFluent.LimitsNested)((LimitRangeSpecFluent.LimitsNested)((LimitRangeSpecFluent.LimitsNested)((LimitRangeSpecFluent.LimitsNested)((DoneableLimitRange)((LimitRangeFluent.MetadataNested)((DoneableLimitRange)((NonNamespaceOperation)this.client.limitRanges().inNamespace(namespaceName)).createOrReplaceWithNew()).withNewMetadata().withName("limits")).endMetadata()).withNewSpec().addNewLimit().withType("Container")).addToDefault("cpu", new Quantity("200m"))).addToDefault("memory", new Quantity("512Mi"))).addToDefaultRequest("cpu", new Quantity("50m"))).addToDefaultRequest("memory", new Quantity("192Mi"))).endLimit()).endSpec()).done();
        HasMetadata computeResources = (HasMetadata)((Resource)this.client.resourceQuotas().load(IOUtils.toInputStream((String)((String)this.resources.get("computeResources")), (String)"utf-8"))).get();
        ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.client.resource(computeResources).inNamespace(namespaceName)).createOrReplace();
        HasMetadata objectCounts = (HasMetadata)((Resource)this.client.resourceQuotas().load(IOUtils.toInputStream((String)((String)this.resources.get("objectCounts")), (String)"utf-8"))).get();
        ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.client.resource(objectCounts).inNamespace(namespaceName)).createOrReplace();
    }

    public void addImagePullSecretToNamespace(String namespaceName) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(".dockerconfigjson", config.getDockerPullSecret());
        ((DoneableSecret)((SecretFluent.MetadataNested)((DoneableSecret)((DoneableSecret)((DoneableSecret)((NonNamespaceOperation)this.client.secrets().inNamespace(namespaceName)).createOrReplaceWithNew()).withData(data)).withType("kubernetes.io/dockerconfigjson")).withNewMetadata().withName("regcred")).endMetadata()).done();
        ((DoneableServiceAccount)((DoneableServiceAccount)((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespaceName)).withName("default")).edit()).addNewImagePullSecret("regcred")).done();
    }

    private void deployServiceIngress(String platformName, String serviceName) {
        ((DoneableIngress)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)((IngressSpecFluent.RulesNested)((DoneableIngress)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((DoneableIngress)((NonNamespaceOperation)this.client.extensions().ingresses().inNamespace(platformName)).createOrReplaceWithNew()).withNewMetadata().withName(serviceName)).addToAnnotations("kubernetes.io/ingress.class", "traefik")).addToLabels("ingress", "plain")).endMetadata()).withNewSpec().addNewRule().withHost(serviceName + "." + platformName + "." + config.getTopLevelDomain())).withNewHttp().addNewPath().withNewBackend().withServiceName(serviceName)).withServicePort(new IntOrString(Integer.valueOf(80)))).endBackend()).endPath()).endHttp()).endRule()).endSpec()).done();
    }

    private void deployServiceIngressV2(String platformName, String serviceName) {
        ((DoneableIngress)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)((IngressSpecFluent.RulesNested)((DoneableIngress)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((DoneableIngress)((NonNamespaceOperation)this.client.extensions().ingresses().inNamespace(platformName)).createOrReplaceWithNew()).withNewMetadata().withName(serviceName + "-workaround")).addToAnnotations("kubernetes.io/ingress.class", "traefik")).addToLabels("ingress", "plain")).endMetadata()).withNewSpec().addNewRule().withHost(serviceName + "-" + platformName + "-svc." + config.getTopLevelDomain())).withNewHttp().addNewPath().withNewBackend().withServiceName(serviceName)).withServicePort(new IntOrString(Integer.valueOf(80)))).endBackend()).endPath()).endHttp()).endRule()).endSpec()).done();
    }

    public void configure() throws Exception {
        this.pt = this.getContext().createProducerTemplate();
        RabbitMQComponent rabbitmq = (RabbitMQComponent)this.getContext().getComponent("rabbitmq");
        rabbitmq.setAddresses(config.getBrokerUrl());
        this.resources = config.getResourcesPolicyFilepath().startsWith("/") ? (Map)this.yaml.load(FileUtils.readFileToString((File)new File(config.getResourcesPolicyFilepath()), (String)"utf-8")) : (Map)this.yaml.load(IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(config.getResourcesPolicyFilepath()), (String)"utf-8"));
        if (this.resources == null) {
            throw new KathraException("Unable to parse resourceQuotas from provided file:" + config.getResourcesPolicyFilepath());
        }
        ((RouteDefinition)this.from("rabbitmq://" + config.getClusterName()).routeId("deploy-route").to("bean:DeployManagerController?method=deployResource(${header.namespace},${body})")).end();
    }
}

