/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.controller;

import com.hubspot.jinjava.Jinjava;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeItem;
import io.fabric8.kubernetes.api.model.LimitRangeSpec;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.extensions.DoneableIngress;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.kathra.Config;
import org.kathra.catalogmanager.client.CatalogManagerClient;
import org.kathra.controller.PlatformService;
import org.kathra.model.KathraResponse;
import org.kathra.model.Platform;
import org.kathra.model.Service;
import org.kathra.model.Template;
import org.kathra.platform.model.KathraCatalogResource;
import org.kathra.platform.model.KathraEnvironmentResource;
import org.kathra.platform.model.KathraEnvironmentResourceParameter;
import org.kathra.utils.annotations.Eager;
import org.kathra.utils.serialization.YamlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="platformController")
@Eager
@ApplicationScoped
public class PlatformController
implements PlatformService {
    public static final String OWNER = "owner";
    public static final String KIND = "kind";
    static Config config = new Config();
    static String kathraPlatformLabel = "kathra-platform";
    static Jinjava jinjava = new Jinjava();
    static final Logger logger = LoggerFactory.getLogger((String)"PlatformController");
    static KubernetesClient client = new DefaultKubernetesClient();
    static CatalogManagerClient catalogClient = new CatalogManagerClient(config.getCatalogManagerUrl());

    @Override
    public List<Platform> listPlatforms(String owner) throws Exception {
        LinkedList<Platform> platforms = new LinkedList<Platform>();
        NamespaceList nss = (NamespaceList)((FilterWatchListDeletable)((FilterWatchListDeletable)client.namespaces().withLabel(OWNER, owner)).withLabel(KIND, kathraPlatformLabel)).list();
        if (null == nss.getItems()) {
            return platforms;
        }
        for (Namespace ns : nss.getItems()) {
            Platform pf = this.getPlatform(ns.getMetadata().getName());
            platforms.add(pf);
        }
        return platforms;
    }

    public List<String> getAllPlatformsIds() {
        NamespaceList nss = (NamespaceList)((FilterWatchListDeletable)client.namespaces().withLabel(KIND, kathraPlatformLabel)).list();
        LinkedList<String> platforms = new LinkedList<String>();
        if (null != nss.getItems()) {
            platforms.addAll(nss.getItems().stream().map(ns -> ns.getMetadata().getName()).collect(Collectors.toList()));
        }
        return platforms;
    }

    @Override
    public KathraResponse deletePlatform(String platformName) {
        FilterWatchListDeletable ns = (FilterWatchListDeletable)((FilterWatchListDeletable)client.namespaces().withLabel("name", platformName)).withLabel(KIND, kathraPlatformLabel);
        NamespaceList list = (NamespaceList)ns.list();
        if (list.getItems() == null || list.getItems().isEmpty()) {
            return new KathraResponse(KathraResponse.Status.failure, "Platform '" + platformName + "' doesn't exists");
        }
        if (list.getItems().size() > 1) {
            return new KathraResponse(KathraResponse.Status.failure, "Multiple entries for Platform '" + platformName + "' seems to exist, please contact your administrator");
        }
        ns.delete();
        return new KathraResponse(KathraResponse.Status.success, "Platform '" + platformName + "' has been successfully deleted");
    }

    public boolean checkIfPlatformExists(String platformName) {
        NamespaceList nss = (NamespaceList)((FilterWatchListDeletable)client.namespaces().withLabel("name", platformName)).list();
        return nss.getItems() != null && !nss.getItems().isEmpty();
    }

    @Override
    public Platform getPlatform(String platformName) throws Exception {
        NamespaceList nss = (NamespaceList)((FilterWatchListDeletable)((FilterWatchListDeletable)client.namespaces().withLabel("name", platformName)).withLabel(KIND, kathraPlatformLabel)).list();
        if (null == nss.getItems()) {
            throw new Exception("This platform doesn't exist");
        }
        Namespace namespace = (Namespace)nss.getItems().get(0);
        Platform pf = new Platform(platformName, (String)namespace.getMetadata().getLabels().get(OWNER));
        ServiceList slist = (ServiceList)((NonNamespaceOperation)client.services().inNamespace(platformName)).list();
        LinkedList<org.kathra.model.Service> services = new LinkedList<org.kathra.model.Service>();
        pf.setStatus(Platform.Status.AVAILABLE);
        if (slist.getItems() != null && !slist.getItems().isEmpty()) {
            for (Service s : slist.getItems()) {
                PodList podList;
                org.kathra.model.Service service = new org.kathra.model.Service().name(s.getMetadata().getName()).id(s.getMetadata().getName()).status(Service.Status.AVAILABLE);
                if (s.getMetadata().getAnnotations() != null && s.getMetadata().getAnnotations().get("kathra/exposeUrl") != null) {
                    service.setUrl((String)s.getMetadata().getAnnotations().get("kathra/exposeUrl"));
                }
                if ((podList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(platformName)).withLabel("project", service.getId())).list()).getItems() != null && !podList.getItems().isEmpty()) {
                    for (Pod pod : podList.getItems()) {
                        if (pod.getStatus().getPhase().equalsIgnoreCase("running")) continue;
                        service.setStatus(Service.Status.ERROR);
                        break;
                    }
                }
                services.add(service);
            }
        }
        pf.setServices(services);
        for (org.kathra.model.Service service : services) {
            if (service.getStatus() == Service.Status.AVAILABLE) continue;
            pf.setStatus(Platform.Status.ERROR);
            break;
        }
        pf.setTags(this.getTagsFromNamespace(namespace));
        return pf;
    }

    private List<String> getTagsFromNamespace(Namespace namespace) {
        if (namespace.getMetadata().getAnnotations() != null && namespace.getMetadata().getAnnotations().containsKey("tags")) {
            return Arrays.asList(((String)namespace.getMetadata().getAnnotations().get("tags")).split(","));
        }
        return new ArrayList<String>();
    }

    public String renderTemplate(KathraEnvironmentResource ser, String yamlTemplate) {
        HashMap<String, String> context = new HashMap<String, String>();
        if (ser.getParameters() != null && !ser.getParameters().isEmpty()) {
            for (KathraEnvironmentResourceParameter parameter : ser.getParameters()) {
                context.put(parameter.getName(), parameter.getValue());
            }
        }
        return jinjava.render(yamlTemplate, context);
    }

    public void deployTemplates(Platform platform) throws Exception {
        for (org.kathra.model.Service service : platform.getServices()) {
            Map map;
            logger.info("Deploying SER : " + service.getId());
            String yamlTemplate = catalogClient.getCatalogResourceTemplate(service.getId());
            Template template = platform.getTemplate(service.getId());
            if (service.getParameters() != null && !service.getParameters().isEmpty()) {
                for (KathraEnvironmentResourceParameter envParam : service.getParameters()) {
                    if (envParam.getValue() != null && !envParam.getValue().isEmpty()) continue;
                    envParam.setValue(template.getParameter(envParam.getName()).getDefaultValue());
                }
                KathraEnvironmentResource ser = new KathraEnvironmentResource().parameters(service.getParameters());
                ser.setId(service.getId());
                ser.setName(service.getName());
                ser.setCatalogResource(service.getId());
                map = YamlUtils.yamlToMap((String)this.renderTemplate(ser, yamlTemplate));
            } else {
                map = YamlUtils.yamlToMap((String)yamlTemplate);
            }
            List objects = (List)map.get("objects");
            HasMetadata k8sResource = null;
            boolean deployCephSecret = false;
            block18: for (Map obj : objects) {
                String kind;
                switch (kind = (String)obj.get(KIND)) {
                    case "Service": {
                        LinkedHashMap annotations;
                        String expose;
                        Map labels;
                        k8sResource = (HasMetadata)((ServiceResource)client.services().load(IOUtils.toInputStream((String)YamlUtils.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                        ObjectMeta metadata = k8sResource.getMetadata();
                        if (metadata == null) {
                            metadata = new ObjectMeta();
                            k8sResource.setMetadata(metadata);
                        }
                        if ((labels = metadata.getLabels()) != null && !labels.isEmpty() && (expose = (String)labels.get("expose")) != null && expose.equals("true")) {
                            this.deployServiceIngress(platform.getName(), metadata.getName());
                        }
                        if ((annotations = k8sResource.getMetadata().getAnnotations()) == null) {
                            annotations = new LinkedHashMap();
                            k8sResource.getMetadata().setAnnotations(annotations);
                        }
                        k8sResource.getMetadata().getAnnotations().put("kathra/exposeUrl", "http://" + metadata.getName() + "." + platform.getName() + "." + config.getTopLevelDomain());
                        break;
                    }
                    case "Deployment": {
                        k8sResource = (HasMetadata)((ScalableResource)client.extensions().deployments().load(IOUtils.toInputStream((String)YamlUtils.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                        break;
                    }
                    case "Ingress": {
                        continue block18;
                    }
                    case "Secret": {
                        k8sResource = (HasMetadata)((Resource)client.secrets().load(IOUtils.toInputStream((String)YamlUtils.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                        break;
                    }
                    case "ConfigMap": {
                        k8sResource = (HasMetadata)((Resource)client.configMaps().load(IOUtils.toInputStream((String)YamlUtils.yaml.dump((Object)obj), (String)"UTF-8"))).get();
                        break;
                    }
                    case "PersistentVolumeClaim": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("BUG With K8sResource Template");
                    }
                }
                ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)client.resource(k8sResource).inNamespace(platform.getName())).createOrReplace();
                logger.info("[" + service.getId() + "]: Deployed " + k8sResource.getKind() + " " + k8sResource.getMetadata().getName());
            }
            if (!deployCephSecret) continue;
            logger.info("Deploying ceph-secret");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("key", "QVFDTnlwbFljS1FnRmhBQW42MVg5SkpFa3JpTFh1UHJLUFpHTGc9PQ==");
            ((DoneableSecret)((DoneableSecret)((DoneableSecret)((SecretFluent.MetadataNested)((DoneableSecret)((NonNamespaceOperation)client.secrets().inNamespace(platform.getName())).createNew()).withNewMetadata().withName("ceph-secret")).endMetadata()).withType("kubernetes.io/rbd")).withData(data)).done();
            logger.info("Deployed ceph-secret");
        }
    }

    private void deployServiceIngress(String platformName, String serviceName) {
        ((DoneableIngress)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)((IngressSpecFluent.RulesNested)((DoneableIngress)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)((DoneableIngress)((NonNamespaceOperation)client.extensions().ingresses().inNamespace(platformName)).createNew()).withNewMetadata().withName(serviceName)).addToAnnotations("kubernetes.io/ingress.class", config.getIngressControllerName())).addToLabels("ingress", "plain")).endMetadata()).withNewSpec().addNewRule().withHost(serviceName + "." + platformName + "." + config.getTopLevelDomain())).withNewHttp().addNewPath().withNewBackend().withServiceName(serviceName)).withServicePort(new IntOrString(Integer.valueOf(80)))).endBackend()).endPath()).endHttp()).endRule()).endSpec()).done();
    }

    @Override
    public KathraResponse deployPlatform(Platform platform) throws Exception {
        Namespace ns = (Namespace)((Resource)client.namespaces().withName(platform.getName())).get();
        if (ns == null) {
            String tagsLabel = null;
            if (platform.getTags() != null) {
                tagsLabel = String.join((CharSequence)",", platform.getTags());
            }
            ns = ((DoneableNamespace)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((DoneableNamespace)client.namespaces().createNew()).withNewMetadata().withName(platform.getName())).addToLabels(OWNER, platform.getOwner())).addToLabels(KIND, kathraPlatformLabel)).addToLabels("name", platform.getName())).addToAnnotations("tags", tagsLabel)).endMetadata()).done();
            if (tagsLabel == null) {
                ns.getMetadata().setAnnotations(null);
            }
        } else {
            throw new Exception("A platform with the same name is already existing");
        }
        this.applyLimitRangesToNamespace(platform.getName());
        platform.setStatus(Platform.Status.DEPLOYING);
        platform.setServices(platform.getServices());
        for (org.kathra.model.Service service : platform.getServices()) {
            KathraCatalogResource catalogResource = catalogClient.getCatalogResource(service.getId());
            service.setStatus(Service.Status.DEPLOYING);
            platform.addTemplate(new Template(service.getId(), catalogResource.getParameters()));
        }
        return new KathraResponse(KathraResponse.Status.success, "Platform '" + platform.getName() + "' is being deployed");
    }

    public void applyLimitRangesToNamespace(String namespaceName) throws Exception {
        Namespace ns = (Namespace)((Resource)client.namespaces().withName(namespaceName)).get();
        if (ns == null) {
            throw new Exception("No namespace with name " + namespaceName);
        }
        LimitRange limitRange = new LimitRange();
        LimitRangeSpec limitRangeSpec = new LimitRangeSpec();
        LimitRangeItem lri = new LimitRangeItem();
        HashMap<String, Quantity> defaultLimits = new HashMap<String, Quantity>();
        defaultLimits.put("cpu", new Quantity("1000m"));
        defaultLimits.put("memory", new Quantity("2048Mi"));
        HashMap<String, Quantity> requestLimits = new HashMap<String, Quantity>();
        requestLimits.put("cpu", new Quantity("2000m"));
        requestLimits.put("memory", new Quantity("4096Mi"));
        lri.setDefault(defaultLimits);
        lri.setMaxLimitRequestRatio(requestLimits);
        lri.setType("Container");
        ArrayList<LimitRangeItem> lriList = new ArrayList<LimitRangeItem>();
        lriList.add(lri);
        limitRangeSpec.setLimits(lriList);
        limitRange.setSpec(limitRangeSpec);
        ((NonNamespaceOperation)client.limitRanges().inNamespace(namespaceName)).create((Object[])new LimitRange[]{limitRange});
    }
}

