/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.controller;

import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.swagger.annotations.ApiModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.kathra.model.KathraNotification;
import org.kathra.model.Platform;
import org.kathra.model.Service;
import org.kathra.model.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(description="Represents a platform proxy")
public class PlatformProxy
extends RouteBuilder {
    public static final String UPDATE_PLATFORM = "updatePlatform";
    public static final String OPERATION = "operation";
    public static final String PLATFORM_NAME = "platformName";
    public static final String WEBSOCKET_CONNECTION_KEY = "websocket.connectionKey";
    public static final String NAMESPACE = "namespace";
    public static final String AVAILABLE_SERVICES = "availableServices";
    public static final String FAILSAFE_SERVICES = "failsafeServices";
    public static final String ERROR_SERVICES = "errorServices";
    public static final String DEPLOYING_SERVICES = "deployingServices";
    Platform platform;
    ConcurrentHashMap<String, Subscriber> subscribers = new ConcurrentHashMap();
    ConcurrentHashMap<String, Watch> watches = new ConcurrentHashMap();
    KubernetesClient client = new DefaultKubernetesClient();
    public final Logger logger;
    static ProducerTemplate pt;

    public PlatformProxy(Platform platform) {
        this.platform = platform;
        this.logger = LoggerFactory.getLogger((String)("PlatformProxy(" + platform.getName() + ")"));
        this.watchNamespace();
        this.watchEvents();
    }

    public void configure() {
        PlatformProxy.initializeProducerTemplate((CamelContext)this.getContext());
        ((RouteDefinition)this.from("timer:init?delay=-1&repeatCount=1").routeId(this.platform.getName()).process(exchange -> this.deployServices())).end();
    }

    private static void initializeProducerTemplate(CamelContext context) {
        if (pt == null) {
            pt = context.createProducerTemplate();
            pt.setDefaultEndpointUri("seda:websocketOutput?blockWhenFull=true");
        }
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Subscriber subscriber) {
        ConcurrentHashMap<String, Subscriber> concurrentHashMap = this.subscribers;
        synchronized (concurrentHashMap) {
            if ("all".equals(subscriber.getUsername()) && !this.subscribers.containsKey(subscriber.getWsKey())) {
                this.subscribers.put(subscriber.getWsKey(), subscriber);
                subscriber.subscribe(this.platform.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(String wsKey) {
        ConcurrentHashMap<String, Subscriber> concurrentHashMap = this.subscribers;
        synchronized (concurrentHashMap) {
            this.subscribers.remove(wsKey);
        }
    }

    public void removeSubscriber(Subscriber subscriber) {
        this.removeSubscriber(subscriber.getWsKey());
    }

    public ConcurrentMap<String, Subscriber> getSubscribers() {
        return this.subscribers;
    }

    public void onClose() throws InterruptedException {
        this.watches.values().forEach(Watch::close);
        Thread.sleep(2000L);
        int watchesSize = this.getSynchWatchesSize();
        while (watchesSize > 0) {
            Thread.sleep(1000L);
            this.watches.values().forEach(Watch::close);
            this.logger.info("Waiting for watches to be closed : {}", this.watches.keys());
            watchesSize = this.getSynchWatchesSize();
        }
        this.logger.info("Closed all watches");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchEvents() {
        Watch watch = (Watch)((NonNamespaceOperation)this.client.events().inNamespace(this.platform.getName())).watch((Object)new Watcher<Event>(){

            public void eventReceived(Watcher.Action action, Event resource) {
                PlatformProxy.this.sendToAllSubscribers(resource, "newEvent");
                if (resource.getReason().equals("Started")) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        PlatformProxy.this.log.error("InterruptedException caught in lambda", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    PlatformProxy.this.updatePlatformStatus(false);
                } else if (!action.equals((Object)Watcher.Action.DELETED)) {
                    PlatformProxy.this.updatePlatformStatus(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClose(KubernetesClientException e) {
                PlatformProxy.this.logger.info("Closing event watch");
                if (e != null) {
                    PlatformProxy.this.logger.info(e.getMessage(), (Throwable)e);
                } else {
                    ConcurrentHashMap<String, Watch> concurrentHashMap = PlatformProxy.this.watches;
                    synchronized (concurrentHashMap) {
                        PlatformProxy.this.watches.remove("event");
                    }
                    PlatformProxy.this.logger.info("Closed event watch");
                }
            }
        });
        ConcurrentHashMap<String, Watch> concurrentHashMap = this.watches;
        synchronized (concurrentHashMap) {
            this.watches.put("event", watch);
        }
        this.logger.info("Added event watch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchNamespace() {
        Watch watch = (Watch)((Resource)this.client.namespaces().withName(this.platform.getName())).watch((Object)new Watcher<Namespace>(){
            int deleteCount = 3;

            public void eventReceived(Watcher.Action action, Namespace resource) {
                PlatformProxy.this.logger.debug("NS :" + resource);
                if (resource.getStatus().getPhase().equalsIgnoreCase("Terminating")) {
                    if (this.deleteCount == 1) {
                        PlatformProxy.this.platform.setStatus(Platform.Status.DELETED);
                        PlatformProxy.this.sendToAllSubscribers(new KathraNotification(KathraNotification.Status.info, "Platform " + PlatformProxy.this.platform.getName() + " has been deleted."), "deletePlatform");
                        PlatformProxy.this.deleteProxy();
                    } else if (this.deleteCount == 3) {
                        PlatformProxy.this.platform.setStatus(Platform.Status.DELETING);
                        PlatformProxy.this.platform.getServices().parallelStream().forEach(s -> s.setStatus(Service.Status.DELETING));
                        PlatformProxy.this.sendToAllSubscribers(PlatformProxy.this.platform, PlatformProxy.UPDATE_PLATFORM);
                    }
                    --this.deleteCount;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClose(KubernetesClientException e) {
                PlatformProxy.this.logger.info("Closing namespace watch");
                if (e != null) {
                    PlatformProxy.this.logger.info(e.getMessage(), (Throwable)e);
                } else {
                    ConcurrentHashMap<String, Watch> concurrentHashMap = PlatformProxy.this.watches;
                    synchronized (concurrentHashMap) {
                        PlatformProxy.this.watches.remove(PlatformProxy.NAMESPACE);
                    }
                    PlatformProxy.this.logger.info("Closed namespace watch");
                }
            }
        });
        ConcurrentHashMap<String, Watch> concurrentHashMap = this.watches;
        synchronized (concurrentHashMap) {
            this.watches.put(NAMESPACE, watch);
        }
        this.logger.info("Added namespace watch");
    }

    private void sendToAllSubscribers(Object body, String operation) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(OPERATION, operation);
        headers.put(PLATFORM_NAME, this.platform.getName());
        for (Subscriber s : this.subscribers.values()) {
            headers.put(WEBSOCKET_CONNECTION_KEY, s.getWsKey());
            pt.sendBodyAndHeaders(body, headers);
        }
    }

    public void sendPfToSubscriber(Subscriber s) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(OPERATION, UPDATE_PLATFORM);
        headers.put(PLATFORM_NAME, this.platform.getName());
        headers.put(WEBSOCKET_CONNECTION_KEY, s.getWsKey());
        pt.sendBodyAndHeaders((Object)this.platform, headers);
    }

    private void deleteProxy() {
        pt.asyncSend("bean:SPMRouteBuilder?method=onDelete(${header.platformName})", exchange -> exchange.getIn().setHeader(PLATFORM_NAME, (Object)this.platform.getName()));
    }

    private void updateServiceStatus(String serviceName, boolean waitForURL) {
        Service s = this.platform.getService(serviceName);
        try {
            if (s == null) {
                this.logger.info("No service with name {}", (Object)serviceName);
                Thread.sleep(5000L);
                return;
            }
            String url = s.getUrl();
            if (url == null || url.isEmpty()) {
                do {
                    Thread.sleep(5000L);
                    url = this.getServiceUrl(s.getId());
                    if (url != null) continue;
                    this.logger.info("No service with name {}", (Object)s.getId());
                    return;
                } while (waitForURL && url.isEmpty());
                if (!url.isEmpty()) {
                    s.setUrl(url);
                }
            }
            this.updateServiceStatus(s);
        }
        catch (InterruptedException e) {
            this.log.error("InterruptedException caught in lambda", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void updateServiceStatus(Service s) {
        Map selector = ((io.fabric8.kubernetes.api.model.Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.platform.getName())).withName(s.getId())).get()).getSpec().getSelector();
        PodList podList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.platform.getName())).withLabels(selector)).list();
        if (podList == null) {
            return;
        }
        List items = podList.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        int expectedPods = items.size();
        int runningPods = (int)items.stream().filter(pod -> pod.getStatus().getPhase().equalsIgnoreCase("running")).count();
        if (runningPods == expectedPods) {
            s.setStatus(Service.Status.AVAILABLE);
        } else if (!s.getStatus().equals((Object)Service.Status.DEPLOYING)) {
            if (runningPods < expectedPods && runningPods >= 1) {
                s.setStatus(Service.Status.FAILSAFE);
            } else if (runningPods == 0) {
                s.setStatus(Service.Status.ERROR);
            }
        }
    }

    private String getServiceUrl(String serviceName) {
        io.fabric8.kubernetes.api.model.Service s = (io.fabric8.kubernetes.api.model.Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.platform.getName())).withName(serviceName)).get();
        if (s == null) {
            return null;
        }
        ObjectMeta metadata = s.getMetadata();
        if (metadata == null) {
            return "";
        }
        Map labels = metadata.getLabels();
        if (labels == null) {
            return "";
        }
        String expose = (String)labels.get("expose");
        if (expose != null && expose.equalsIgnoreCase("true")) {
            this.logger.info("Service({}) Getting url", (Object)serviceName);
            Map annotations = metadata.getAnnotations();
            if (annotations != null) {
                String serviceUrl = (String)annotations.get("fabric8.io/exposeUrl");
                if (serviceUrl != null && !serviceUrl.isEmpty()) {
                    this.logger.info("Service({}) URL OK :", (Object)serviceUrl);
                    return serviceUrl;
                }
                return "";
            }
        } else {
            this.logger.info("Service({}) Not getting url, Internal Service", (Object)serviceName);
            return "Internal Service";
        }
        return "";
    }

    private void updatePlatformStatus(boolean waitForURL) {
        Platform.Status status = this.platform.getStatus();
        if (this.platform.getStatus().equals((Object)Platform.Status.DELETING)) {
            return;
        }
        ConcurrentHashMap<String, AtomicInteger> statusMap = new ConcurrentHashMap<String, AtomicInteger>();
        statusMap.put(AVAILABLE_SERVICES, new AtomicInteger(0));
        statusMap.put(FAILSAFE_SERVICES, new AtomicInteger(0));
        statusMap.put(ERROR_SERVICES, new AtomicInteger(0));
        statusMap.put(DEPLOYING_SERVICES, new AtomicInteger(0));
        AtomicBoolean changed = new AtomicBoolean(false);
        this.platform.getServices().parallelStream().forEach(s -> {
            Service.Status oldStatus = s.getStatus();
            this.updateServiceStatus(s.getId(), waitForURL);
            if (!changed.get() && !s.getStatus().equals((Object)oldStatus)) {
                changed.set(true);
            }
            Map map = statusMap;
            synchronized (map) {
                if (s.getStatus().equals((Object)Service.Status.AVAILABLE)) {
                    ((AtomicInteger)statusMap.get(AVAILABLE_SERVICES)).incrementAndGet();
                } else if (s.getStatus().equals((Object)Service.Status.FAILSAFE)) {
                    ((AtomicInteger)statusMap.get(FAILSAFE_SERVICES)).incrementAndGet();
                } else if (s.getStatus().equals((Object)Service.Status.ERROR)) {
                    ((AtomicInteger)statusMap.get(ERROR_SERVICES)).incrementAndGet();
                } else if (s.getStatus().equals((Object)Service.Status.DEPLOYING)) {
                    ((AtomicInteger)statusMap.get(DEPLOYING_SERVICES)).incrementAndGet();
                }
            }
        });
        this.updatePlateformStatus(statusMap);
        if (!changed.get() && !this.platform.getStatus().equals((Object)status)) {
            changed.set(true);
        }
        if (changed.get()) {
            this.sendToAllSubscribers(this.platform, UPDATE_PLATFORM);
        }
    }

    private void updatePlateformStatus(Map<String, AtomicInteger> statusMap) {
        if (statusMap.get(ERROR_SERVICES).get() > 0) {
            this.platform.setStatus(Platform.Status.ERROR);
        } else if (statusMap.get(DEPLOYING_SERVICES).get() > 0) {
            this.platform.setStatus(Platform.Status.DEPLOYING);
        } else if (statusMap.get(FAILSAFE_SERVICES).get() > 0) {
            this.platform.setStatus(Platform.Status.FAILSAFE);
        } else if (statusMap.get(AVAILABLE_SERVICES).get() > 0) {
            this.platform.setStatus(Platform.Status.AVAILABLE);
        }
    }

    public void deployServices() throws InterruptedException {
        if (this.platform.getStatus().equals((Object)Platform.Status.DEPLOYING)) {
            this.logger.info("Deploying templates");
            int watchesSize = this.getSynchWatchesSize();
            while (watchesSize < 2) {
                Thread.sleep(1000L);
                this.logger.info("Waiting for watches to be created");
                watchesSize = this.getSynchWatchesSize();
            }
            pt.sendBody("bean:platformController?method=deployTemplates(${body})", (Object)this.platform);
            Thread.sleep(5000L);
            this.logger.info("Deployed templates");
        }
        Platform pf = (Platform)pt.requestBodyAndHeader("bean:platformController?method=getPlatform(${header.platformName})", null, PLATFORM_NAME, (Object)this.platform.getName());
        pf.setStatus(Platform.Status.DEPLOYING);
        for (Service s : pf.getServices()) {
            s.setStatus(Service.Status.DEPLOYING);
        }
        this.platform = pf;
        this.updatePlatformStatus(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSynchWatchesSize() {
        int watchesSize;
        ConcurrentHashMap<String, Watch> concurrentHashMap = this.watches;
        synchronized (concurrentHashMap) {
            watchesSize = this.watches.size();
        }
        return watchesSize;
    }

    public List getEvents() {
        return ((EventList)((NonNamespaceOperation)this.client.events().inNamespace(this.platform.getName())).list()).getItems();
    }
}

