/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedList;
import java.util.List;
import org.kathra.model.ValidationRule;

@ApiModel(description="Represents a service parameters")
public class Parameter {
    boolean optional;
    String name;
    String type;
    String defaultValue;
    String description;
    String value;
    List<ValidationRule> rules = new LinkedList<ValidationRule>();

    public Parameter() {
    }

    public Parameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Parameter(boolean optional, String name, String type, String defaultValue, String description, List<ValidationRule> rules) {
        this.optional = optional;
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.description = description;
        this.rules = rules;
    }

    public Parameter(boolean optional, String name, String type, String defaultValue, String description) {
        this.optional = optional;
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public void addRule(ValidationRule rule) {
        if (!this.rules.contains(rule)) {
            this.rules.add(rule);
        }
    }

    @ApiModelProperty(value="option")
    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @ApiModelProperty(value="option", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="option")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(value="option")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @ApiModelProperty(value="option")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="option")
    public List<ValidationRule> getRules() {
        return this.rules;
    }

    public void setRules(List<ValidationRule> rules) {
        this.rules = rules;
    }

    @ApiModelProperty(value="option", required=true)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

