/*
 * Decompiled with CFR 0.152.
 */
package org.kathra.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kathra.model.Service;
import org.kathra.model.Template;

@ApiModel(description="Represents a platform")
public class Platform {
    String name;
    String owner;
    List<Service> services;
    List<Template> templates = new ArrayList<Template>();
    List<String> tags;
    Status status;
    Map<String, Service> serviceIndex = new HashMap<String, Service>();
    Map<String, Template> templateIndex = new HashMap<String, Template>();

    public Platform() {
    }

    public Platform(String name, String owner) {
        this.name = name;
        this.owner = owner;
    }

    public Platform(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Name of the platform", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Owner of the platform", required=true)
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @ApiModelProperty(value="Services in the platform", required=true)
    public List<Service> getServices() {
        return this.services;
    }

    @ApiModelProperty(value="Tags of the platform")
    public List<String> getTags() {
        return this.tags;
    }

    public Template getTemplate(String templateName) {
        return this.templateIndex.get(templateName);
    }

    public void setTemplates(List<Template> templates) {
        this.templates = templates;
        templates.forEach(template -> this.templateIndex.put(template.getName(), (Template)template));
    }

    @ApiModelProperty(value="Templates in the platform", required=true)
    public List<Template> getTemplates() {
        return this.templates;
    }

    @ApiModelProperty(value="Templates in the platform", required=true)
    public void addTemplate(Template template) throws Exception {
        if (this.templateIndex.containsKey(template.getName())) {
            throw new Exception("The template " + template.getName() + " is already in the platform");
        }
        this.templates.add(template);
        this.templateIndex.put(template.getName(), template);
    }

    public Service getService(String serviceName) {
        return this.serviceIndex.get(serviceName);
    }

    public void setServices(List<Service> services) {
        this.serviceIndex.clear();
        this.services = services;
        services.forEach(service -> this.serviceIndex.put(service.getId(), (Service)service));
    }

    public void setTags(List<String> _tags) {
        this.tags = _tags;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static enum Status {
        DEPLOYING,
        AVAILABLE,
        DELETING,
        DELETED,
        FAILSAFE,
        ERROR;

    }
}

